/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client.ipc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.api.proto.Messages;
import org.apache.slider.api.proto.RestTypeMarshalling;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.api.types.PingInformation;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.exceptions.WaitTimeoutException;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.codehaus.jackson.JsonParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderClusterOperations {
    protected static final Logger log = LoggerFactory.getLogger(SliderClusterOperations.class);
    private final SliderClusterProtocol appMaster;
    private static final Messages.EmptyPayloadProto EMPTY = Messages.EmptyPayloadProto.newBuilder().build();

    public SliderClusterOperations(SliderClusterProtocol appMaster) {
        this.appMaster = appMaster;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliderClusterOperations{");
        sb.append("IPC binding=").append(this.appMaster);
        sb.append('}');
        return sb.toString();
    }

    public ClusterNode getNode(String uuid) throws IOException, NoSuchNodeException, YarnException {
        Messages.GetNodeRequestProto req = Messages.GetNodeRequestProto.newBuilder().setUuid(uuid).build();
        Messages.GetNodeResponseProto node = this.appMaster.getNode(req);
        return ClusterNode.fromProtobuf(node.getClusterNode());
    }

    public List<ClusterNode> convertNodeWireToClusterNodes(List<Messages.RoleInstanceState> nodes) throws IOException {
        ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>(nodes.size());
        for (Messages.RoleInstanceState node : nodes) {
            nodeList.add(ClusterNode.fromProtobuf(node));
        }
        return nodeList;
    }

    public String echo(String text) throws YarnException, IOException {
        Messages.EchoRequestProto.Builder builder = Messages.EchoRequestProto.newBuilder();
        builder.setText(text);
        Messages.EchoRequestProto req = builder.build();
        Messages.EchoResponseProto response = this.appMaster.echo(req);
        return response.getText();
    }

    public ClusterDescription getClusterDescription() throws YarnException, IOException {
        Messages.GetJSONClusterStatusRequestProto req = Messages.GetJSONClusterStatusRequestProto.newBuilder().build();
        Messages.GetJSONClusterStatusResponseProto resp = this.appMaster.getJSONClusterStatus(req);
        String statusJson = resp.getClusterSpec();
        try {
            return ClusterDescription.fromJson(statusJson);
        }
        catch (JsonParseException e) {
            log.error("Exception " + (Object)((Object)e) + " parsing:\n" + statusJson, (Throwable)e);
            throw e;
        }
    }

    public AggregateConf getInstanceDefinition() throws YarnException, IOException {
        Messages.GetInstanceDefinitionRequestProto.Builder builder = Messages.GetInstanceDefinitionRequestProto.newBuilder();
        Messages.GetInstanceDefinitionRequestProto request = builder.build();
        Messages.GetInstanceDefinitionResponseProto response = this.appMaster.getInstanceDefinition(request);
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTree internal = (ConfTree)confTreeSerDeser.fromJson(response.getInternal());
        ConfTree resources = (ConfTree)confTreeSerDeser.fromJson(response.getResources());
        ConfTree app = (ConfTree)confTreeSerDeser.fromJson(response.getApplication());
        AggregateConf instanceDefinition = new AggregateConf(resources, app, internal);
        return instanceDefinition;
    }

    public boolean killContainer(String id) throws YarnException, IOException {
        Messages.KillContainerRequestProto.Builder builder = Messages.KillContainerRequestProto.newBuilder();
        builder.setId(id);
        Messages.KillContainerRequestProto req = builder.build();
        Messages.KillContainerResponseProto response = this.appMaster.killContainer(req);
        return response.getSuccess();
    }

    public String[] listNodeUUIDsByRole(String role) throws IOException, YarnException {
        List<String> uuidList = this.innerListNodeUUIDSByRole(role);
        String[] uuids = new String[uuidList.size()];
        return uuidList.toArray(uuids);
    }

    public List<String> innerListNodeUUIDSByRole(String role) throws IOException, YarnException {
        Messages.ListNodeUUIDsByRoleRequestProto req = Messages.ListNodeUUIDsByRoleRequestProto.newBuilder().setRole(role).build();
        Messages.ListNodeUUIDsByRoleResponseProto resp = this.appMaster.listNodeUUIDsByRole(req);
        return resp.getUuidList();
    }

    public List<ClusterNode> listClusterNodesInRole(String role) throws IOException, YarnException {
        List<String> uuidList = this.innerListNodeUUIDSByRole(role);
        Messages.GetClusterNodesRequestProto req = Messages.GetClusterNodesRequestProto.newBuilder().addAllUuid(uuidList).build();
        Messages.GetClusterNodesResponseProto resp = this.appMaster.getClusterNodes(req);
        return this.convertNodeWireToClusterNodes(resp.getClusterNodeList());
    }

    @VisibleForTesting
    public List<ClusterNode> listClusterNodes(String[] uuids) throws IOException, YarnException {
        Messages.GetClusterNodesRequestProto req = Messages.GetClusterNodesRequestProto.newBuilder().addAllUuid(Arrays.asList(uuids)).build();
        Messages.GetClusterNodesResponseProto resp = this.appMaster.getClusterNodes(req);
        return this.convertNodeWireToClusterNodes(resp.getClusterNodeList());
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    public int waitForRoleInstanceLive(String role, long timeout) throws WaitTimeoutException, IOException, YarnException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean flex(ConfTree resources) throws IOException {
        Messages.FlexClusterRequestProto request = Messages.FlexClusterRequestProto.newBuilder().setClusterSpec(resources.toJson()).build();
        Messages.FlexClusterResponseProto response = this.appMaster.flexCluster(request);
        return response.getResponse();
    }

    public void amSuicide(String text, int signal, int delay) throws IOException {
        Messages.AMSuicideRequestProto.Builder builder = Messages.AMSuicideRequestProto.newBuilder();
        if (text != null) {
            builder.setText(text);
        }
        builder.setSignal(signal);
        builder.setDelay(delay);
        Messages.AMSuicideRequestProto req = builder.build();
        this.appMaster.amSuicide(req);
    }

    public ApplicationLivenessInformation getLivenessInformation() throws IOException {
        Messages.GetApplicationLivenessRequestProto.Builder builder = Messages.GetApplicationLivenessRequestProto.newBuilder();
        Messages.ApplicationLivenessInformationProto wire = this.appMaster.getLivenessInformation(builder.build());
        return RestTypeMarshalling.unmarshall(wire);
    }

    public AggregateConf getModelDesired() throws IOException {
        return RestTypeMarshalling.unmarshallToAggregateConf(this.appMaster.getModelDesired(EMPTY));
    }

    public ConfTreeOperations getModelDesiredAppconf() throws IOException {
        return RestTypeMarshalling.unmarshallToCTO(this.appMaster.getModelDesiredAppconf(EMPTY));
    }

    public ConfTreeOperations getModelDesiredResources() throws IOException {
        return RestTypeMarshalling.unmarshallToCTO(this.appMaster.getModelDesiredResources(EMPTY));
    }

    public AggregateConf getModelResolved() throws IOException {
        return RestTypeMarshalling.unmarshallToAggregateConf(this.appMaster.getModelResolved(EMPTY));
    }

    public ConfTreeOperations getModelResolvedAppconf() throws IOException {
        return RestTypeMarshalling.unmarshallToCTO(this.appMaster.getModelResolvedAppconf(EMPTY));
    }

    public ConfTreeOperations getModelResolvedResources() throws IOException {
        return RestTypeMarshalling.unmarshallToCTO(this.appMaster.getModelDesiredResources(EMPTY));
    }

    public ConfTreeOperations getLiveResources() throws IOException {
        return RestTypeMarshalling.unmarshallToCTO(this.appMaster.getLiveResources(EMPTY));
    }

    public Map<String, ContainerInformation> enumContainers() throws IOException {
        int records;
        Messages.GetLiveContainersResponseProto response = this.appMaster.getLiveContainers(Messages.GetLiveContainersRequestProto.newBuilder().build());
        int namesCount = response.getNamesCount();
        if (namesCount != (records = response.getContainersCount())) {
            throw new IOException("Number of names returned (" + namesCount + ") does not match the number of records returned: " + records);
        }
        HashMap<String, ContainerInformation> map = new HashMap<String, ContainerInformation>(namesCount);
        int i = 0;
        while (i < namesCount) {
            map.put(response.getNames(i), RestTypeMarshalling.unmarshall(response.getContainers(i)));
            ++i;
        }
        return map;
    }

    public ContainerInformation getContainer(String containerId) throws IOException {
        Messages.ContainerInformationProto response = this.appMaster.getLiveContainer(Messages.GetLiveContainerRequestProto.newBuilder().setContainerId(containerId).build());
        return RestTypeMarshalling.unmarshall(response);
    }

    public List<ContainerInformation> getContainers() throws IOException {
        Messages.GetLiveContainersResponseProto response = this.appMaster.getLiveContainers(Messages.GetLiveContainersRequestProto.newBuilder().build());
        return RestTypeMarshalling.unmarshall(response);
    }

    public Map<String, ComponentInformation> enumComponents() throws IOException {
        int records;
        Messages.GetLiveComponentsResponseProto response = this.appMaster.getLiveComponents(Messages.GetLiveComponentsRequestProto.newBuilder().build());
        int namesCount = response.getNamesCount();
        if (namesCount != (records = response.getComponentsCount())) {
            throw new IOException("Number of names returned (" + namesCount + ")" + " does not match the number of records returned: " + records);
        }
        HashMap<String, ComponentInformation> map = new HashMap<String, ComponentInformation>(namesCount);
        int i = 0;
        while (i < namesCount) {
            map.put(response.getNames(i), RestTypeMarshalling.unmarshall(response.getComponents(i)));
            ++i;
        }
        return map;
    }

    public ComponentInformation getComponent(String componentName) throws IOException {
        Messages.GetLiveComponentRequestProto.Builder builder = Messages.GetLiveComponentRequestProto.newBuilder();
        builder.setName(componentName);
        Messages.ComponentInformationProto proto = this.appMaster.getLiveComponent(builder.build());
        return RestTypeMarshalling.unmarshall(proto);
    }

    public NodeInformationList getLiveNodes() throws IOException {
        Messages.GetLiveNodesResponseProto response = this.appMaster.getLiveNodes(Messages.GetLiveNodesRequestProto.newBuilder().build());
        int records = response.getNodesCount();
        NodeInformationList nil = new NodeInformationList(records);
        int i = 0;
        while (i < records) {
            nil.add(RestTypeMarshalling.unmarshall(response.getNodes(i)));
            ++i;
        }
        return nil;
    }

    public NodeInformation getLiveNode(String hostname) throws IOException {
        Messages.GetLiveNodeRequestProto.Builder builder = Messages.GetLiveNodeRequestProto.newBuilder();
        builder.setName(hostname);
        return RestTypeMarshalling.unmarshall(this.appMaster.getLiveNode(builder.build()));
    }

    public PingInformation ping(String text) throws IOException {
        return null;
    }

    public void stop(String text) throws IOException {
        this.amSuicide(text, 3, 0);
    }

    public ApplicationLivenessInformation getApplicationLiveness() throws IOException {
        Messages.ApplicationLivenessInformationProto proto = this.appMaster.getLivenessInformation(Messages.GetApplicationLivenessRequestProto.newBuilder().build());
        return RestTypeMarshalling.unmarshall(proto);
    }

    public byte[] getClientCertificateStore(String hostname, String clientId, String password, String type) throws IOException {
        Messages.GetCertificateStoreRequestProto.Builder builder = Messages.GetCertificateStoreRequestProto.newBuilder();
        if (hostname != null) {
            builder.setHostname(hostname);
        }
        Messages.GetCertificateStoreRequestProto requestProto = builder.setRequesterId(clientId).setPassword(password).setType(type).build();
        Messages.GetCertificateStoreResponseProto response = this.appMaster.getClientCertificateStore(requestProto);
        return RestTypeMarshalling.unmarshall(response);
    }
}

