/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.api;

import java.util.Map;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadConfigException;

public class ClusterDescriptionOperations {
    public static ClusterDescription buildFromInstanceDefinition(AggregateConf aggregateConf) throws BadConfigException {
        ClusterDescription cd = new ClusterDescription();
        aggregateConf.resolve();
        Map<String, String> options = cd.options;
        SliderUtils.mergeMapsIgnoreDuplicateKeys(options, aggregateConf.getInternal().global);
        SliderUtils.mergeMapsIgnoreDuplicateKeys(options, aggregateConf.getAppConf().global);
        SliderUtils.mergeMapsIgnoreDuplicateKeys(options, aggregateConf.getResources().global);
        ClusterDescriptionOperations.mergeInComponentMap(cd, aggregateConf.getInternal());
        ClusterDescriptionOperations.mergeInComponentMap(cd, aggregateConf.getAppConf());
        ClusterDescriptionOperations.mergeInComponentMap(cd, aggregateConf.getResources());
        cd.state = 3;
        MapOperations internalOptions = aggregateConf.getInternalOperations().getGlobalOptions();
        MapOperations appOptions = aggregateConf.getAppConfOperations().getGlobalOptions();
        cd.type = internalOptions.getOption("internal.provider.name", "agent");
        cd.dataPath = internalOptions.get("internal.data.dir.path");
        cd.name = internalOptions.get("application.name");
        cd.originConfigurationPath = internalOptions.get("internal.snapshot.conf.path");
        cd.generatedConfigurationPath = internalOptions.get("internal.generated.conf.path");
        cd.setImagePath(internalOptions.get("internal.application.image.path"));
        cd.setApplicationHome(internalOptions.get("internal.application.home"));
        cd.setZkPath(appOptions.get("zookeeper.path"));
        cd.setZkHosts(appOptions.get("zookeeper.quorum"));
        return cd;
    }

    private static void mergeInComponentMap(ClusterDescription cd, ConfTree confTree) {
        Map<String, Map<String, String>> components = confTree.components;
        for (Map.Entry<String, Map<String, String>> compEntry : components.entrySet()) {
            String name = compEntry.getKey();
            Map<String, String> destRole = cd.getOrAddRole(name);
            Map<String, String> sourceComponent = compEntry.getValue();
            SliderUtils.mergeMapsIgnoreDuplicateKeys(destRole, sourceComponent);
        }
    }
}

