/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SequenceValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceValidator.class);
    private Long lastTxId;
    private Long lastRowId;

    SequenceValidator() {
    }

    boolean isInSequence(RecordIdentifier recordIdentifier) {
        if (this.lastTxId != null && recordIdentifier.getTransactionId() < this.lastTxId) {
            LOG.debug("Non-sequential transaction ID. Expected >{}, recordIdentifier={}", (Object)this.lastTxId, (Object)recordIdentifier);
            return false;
        }
        if (this.lastTxId != null && recordIdentifier.getTransactionId() == this.lastTxId.longValue() && this.lastRowId != null && recordIdentifier.getRowId() <= this.lastRowId) {
            LOG.debug("Non-sequential row ID. Expected >{}, recordIdentifier={}", (Object)this.lastRowId, (Object)recordIdentifier);
            return false;
        }
        this.lastTxId = recordIdentifier.getTransactionId();
        this.lastRowId = recordIdentifier.getRowId();
        return true;
    }

    void reset() {
        this.lastTxId = null;
        this.lastRowId = null;
        LOG.debug("reset");
    }

    public String toString() {
        return "SequenceValidator [lastTxId=" + this.lastTxId + ", lastRowId=" + this.lastRowId + "]";
    }
}

