/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.mutate.client.TransactionException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger LOG = LoggerFactory.getLogger(Transaction.class);
    private final Lock lock;
    private final IMetaStoreClient metaStoreClient;
    private final long transactionId;
    private TransactionBatch.TxnState state;

    Transaction(IMetaStoreClient metaStoreClient, Lock.Options lockOptions) throws TransactionException {
        this(metaStoreClient, new Lock(metaStoreClient, lockOptions));
    }

    Transaction(IMetaStoreClient metaStoreClient, Lock lock) throws TransactionException {
        this.metaStoreClient = metaStoreClient;
        this.lock = lock;
        this.transactionId = this.open(lock.getUser());
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public TransactionBatch.TxnState getState() {
        return this.state;
    }

    public void begin() throws TransactionException {
        try {
            this.lock.acquire(this.transactionId);
        }
        catch (LockException e) {
            throw new TransactionException("Unable to acquire lock for transaction: " + this.transactionId, e);
        }
        this.state = TransactionBatch.TxnState.OPEN;
        LOG.debug("Begin. Transaction id: {}", (Object)this.transactionId);
    }

    public void commit() throws TransactionException {
        try {
            this.lock.release();
        }
        catch (LockException e) {
            throw new TransactionException("Unable to release lock: " + this.lock + " for transaction: " + this.transactionId, e);
        }
        try {
            this.metaStoreClient.commitTxn(this.transactionId);
            this.state = TransactionBatch.TxnState.COMMITTED;
        }
        catch (NoSuchTxnException e) {
            throw new TransactionException("Invalid transaction id: " + this.transactionId, e);
        }
        catch (TxnAbortedException e) {
            throw new TransactionException("Aborted transaction cannot be committed: " + this.transactionId, e);
        }
        catch (TException e) {
            throw new TransactionException("Unable to commit transaction: " + this.transactionId, e);
        }
        LOG.debug("Committed. Transaction id: {}", (Object)this.transactionId);
    }

    public void abort() throws TransactionException {
        try {
            this.lock.release();
        }
        catch (LockException e) {
            throw new TransactionException("Unable to release lock: " + this.lock + " for transaction: " + this.transactionId, e);
        }
        try {
            this.metaStoreClient.rollbackTxn(this.transactionId);
            this.state = TransactionBatch.TxnState.ABORTED;
        }
        catch (NoSuchTxnException e) {
            throw new TransactionException("Unable to abort invalid transaction id : " + this.transactionId, e);
        }
        catch (TException e) {
            throw new TransactionException("Unable to abort transaction id : " + this.transactionId, e);
        }
        LOG.debug("Aborted. Transaction id: {}", (Object)this.transactionId);
    }

    public String toString() {
        return "Transaction [transactionId=" + this.transactionId + ", state=" + (Object)((Object)this.state) + "]";
    }

    private long open(String user) throws TransactionException {
        long transactionId = -1L;
        try {
            transactionId = this.metaStoreClient.openTxn(user);
            this.state = TransactionBatch.TxnState.INACTIVE;
        }
        catch (TException e) {
            throw new TransactionException("Unable to open transaction for user: " + user, e);
        }
        LOG.debug("Opened transaction with id: {}", (Object)transactionId);
        return transactionId;
    }
}

