/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.util.LongBitFormat;

class XAttrFormat {
    private static final int XATTR_VALUE_LEN_MAX = 65536;

    XAttrFormat() {
    }

    static List<XAttr> toXAttrs(byte[] attrs) {
        ArrayList<XAttr> xAttrs = new ArrayList<XAttr>();
        if (attrs == null || attrs.length == 0) {
            return xAttrs;
        }
        int i = 0;
        while (i < attrs.length) {
            XAttr.Builder builder = new XAttr.Builder();
            int v = Ints.fromBytes((byte)attrs[i], (byte)attrs[i + 1], (byte)attrs[i + 2], (byte)attrs[i + 3]);
            builder.setNameSpace(XAttrStatusFormat.getNamespace(v));
            builder.setName(XAttrStatusFormat.getName(v));
            int vlen = (0xFF & attrs[i += 4]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                builder.setValue(value);
                i += vlen;
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    static XAttr getXAttr(byte[] attrs, String prefixedName) {
        int vlen;
        if (prefixedName == null || attrs == null) {
            return null;
        }
        XAttr xAttr = XAttrHelper.buildXAttr((String)prefixedName);
        for (int i = 0; i < attrs.length; i += vlen) {
            int v = Ints.fromBytes((byte)attrs[i], (byte)attrs[i + 1], (byte)attrs[i + 2], (byte)attrs[i + 3]);
            XAttr.NameSpace namespace = XAttrStatusFormat.getNamespace(v);
            String name = XAttrStatusFormat.getName(v);
            vlen = (0xFF & attrs[i += 4]) << 8 | 0xFF & attrs[i + 1];
            i += 2;
            if (xAttr.getNameSpace() != namespace || !xAttr.getName().equals(name)) continue;
            if (vlen > 0) {
                byte[] value = new byte[vlen];
                System.arraycopy(attrs, i, value, 0, vlen);
                return new XAttr.Builder().setNameSpace(namespace).setName(name).setValue(value).build();
            }
            return xAttr;
        }
        return null;
    }

    static byte[] toBytes(List<XAttr> xAttrs) {
        if (xAttrs == null || xAttrs.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (XAttr a : xAttrs) {
                int v = XAttrStatusFormat.toInt(a.getNameSpace(), a.getName());
                out.write(Ints.toByteArray((int)v));
                int vlen = a.getValue() == null ? 0 : a.getValue().length;
                Preconditions.checkArgument((vlen < 65536 ? 1 : 0) != 0, (Object)"The length of xAttr values is too long.");
                out.write((byte)(vlen >> 8));
                out.write((byte)vlen);
                if (vlen <= 0) continue;
                out.write(a.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private static enum XAttrStatusFormat {
        NAMESPACE(null, 3),
        RESERVED(XAttrStatusFormat.NAMESPACE.BITS, 5),
        NAME(XAttrStatusFormat.RESERVED.BITS, 24);

        private final LongBitFormat BITS;

        private XAttrStatusFormat(LongBitFormat previous, int length) {
            this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
        }

        static XAttr.NameSpace getNamespace(int xattrStatus) {
            int ordinal = (int)XAttrStatusFormat.NAMESPACE.BITS.retrieve((long)xattrStatus);
            return XAttr.NameSpace.values()[ordinal];
        }

        static String getName(int xattrStatus) {
            int id = (int)XAttrStatusFormat.NAME.BITS.retrieve((long)xattrStatus);
            return XAttrStorage.getName(id);
        }

        static int toInt(XAttr.NameSpace namespace, String name) {
            long xattrStatusInt = 0L;
            xattrStatusInt = XAttrStatusFormat.NAMESPACE.BITS.combine((long)namespace.ordinal(), xattrStatusInt);
            int nid = XAttrStorage.getNameSerialNumber(name);
            xattrStatusInt = XAttrStatusFormat.NAME.BITS.combine((long)nid, xattrStatusInt);
            return (int)xattrStatusInt;
        }
    }
}

