/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.messaging.AlterTableMessage;

public class AlterTableReplicationTask
extends ReplicationTask {
    private final AlterTableMessage alterTableMessage;

    public AlterTableReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "ALTER_TABLE");
        this.alterTableMessage = messageFactory.getDeserializer().getAlterTableMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return true;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        String dbName = this.alterTableMessage.getDB();
        String tableName = this.alterTableMessage.getTable();
        return Collections.singletonList(new ExportCommand(dbName, tableName, null, this.srcStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, null)), true, this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dbName = this.alterTableMessage.getDB();
        String tableName = this.alterTableMessage.getTable();
        return Collections.singletonList(new ImportCommand(ReplicationUtils.mapIfMapAvailable(dbName, (Function<String, String>)this.dbNameMapping), ReplicationUtils.mapIfMapAvailable(tableName, (Function<String, String>)this.tableNameMapping), null, this.dstStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), dbName, tableName, null)), true, this.event.getEventId()));
    }
}

