/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.storm.hive.security.AutoHive;
import org.apache.storm.hive.security.AutoHiveNimbus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoHiveCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHiveCommand.class);

    private AutoHiveCommand() {
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("hive.kerberos.principal", args[1]);
        conf.put("hive.keytab.file", args[2]);
        conf.put(HiveConf.ConfVars.METASTOREURIS.varname, args[3]);
        AutoHive autoHive = new AutoHive();
        autoHive.prepare(conf);
        AutoHiveNimbus autoHiveNimbus = new AutoHiveNimbus();
        autoHiveNimbus.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHiveNimbus.populateCredentials(creds, conf, args[0]);
        LOG.info("Got Hive credentials" + autoHive.getCredentials(creds));
        Subject subject = new Subject();
        autoHive.populateSubject(subject, creds);
        LOG.info("Got a Subject " + subject);
        autoHiveNimbus.renew(creds, conf, args[0]);
        LOG.info("Renewed credentials" + autoHive.getCredentials(creds));
    }
}

