/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi;

import java.io.IOException;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTDecoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTEncoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInputNoShared;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutputNoShared;
import org.apache.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezDecoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezEncoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTBufferTooSmallException;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTCoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;

public class OnHeapCoder
implements FSTCoder {
    protected FSTConfiguration conf;
    protected HeapBytez writeTarget;
    protected HeapBytez readTarget;
    protected FSTObjectOutput out;
    protected FSTObjectInput in;
    protected byte[] buff = new byte[4096];

    public OnHeapCoder() {
        this(true);
    }

    public OnHeapCoder(boolean sharedRefs) {
        this.conf = FSTConfiguration.createUnsafeBinaryConfiguration();
        this.conf.setShareReferences(sharedRefs);
        this.writeTarget = new HeapBytez(new byte[0]);
        this.readTarget = new HeapBytez(new byte[0]);
        this.conf.setStreamCoderFactory(new FSTConfiguration.StreamCoderFactory(){
            ThreadLocal input = new ThreadLocal();
            ThreadLocal output = new ThreadLocal();

            @Override
            public FSTEncoder createStreamEncoder() {
                FSTBytezEncoder fstBytezEncoder = new FSTBytezEncoder(OnHeapCoder.this.conf, OnHeapCoder.this.writeTarget);
                fstBytezEncoder.setAutoResize(false);
                return fstBytezEncoder;
            }

            @Override
            public FSTDecoder createStreamDecoder() {
                return new FSTBytezDecoder(OnHeapCoder.this.conf, OnHeapCoder.this.readTarget);
            }

            @Override
            public ThreadLocal getInput() {
                return this.input;
            }

            @Override
            public ThreadLocal getOutput() {
                return this.output;
            }
        });
        if (sharedRefs) {
            this.out = this.conf.getObjectOutput();
            this.in = this.conf.getObjectInput();
        } else {
            this.out = new FSTObjectOutputNoShared(this.conf);
            this.in = new FSTObjectInputNoShared(this.conf);
        }
    }

    public OnHeapCoder(Class ... preregister) {
        this();
        this.conf.registerClass(preregister);
    }

    public OnHeapCoder(boolean sharedRefs, Class ... preregister) {
        this(sharedRefs);
        this.conf.registerClass(preregister);
    }

    @Override
    public int toByteArray(Object o, byte[] arr, int startIndex, int availableSize) {
        this.out.resetForReUse();
        this.writeTarget.setBase(arr, startIndex, availableSize);
        try {
            this.out.writeObject(o);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        int written = this.out.getWritten();
        return written;
    }

    @Override
    public byte[] toByteArray(Object o) {
        try {
            this.out.resetForReUse();
            this.writeTarget.setBase(this.buff, 0L, this.buff.length);
            try {
                this.out.writeObject(o);
            }
            catch (IOException e) {
                FSTUtil.rethrow(e);
            }
            return this.out.getCopyOfWrittenBuffer();
        }
        catch (FSTBufferTooSmallException ex) {
            this.buff = new byte[this.buff.length * 2];
            return this.toByteArray(o);
        }
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }

    @Override
    public Object toObject(byte[] arr, int startIndex, int availableSize) {
        try {
            this.in.resetForReuse(null);
            this.readTarget.setBase(arr, startIndex, availableSize);
            Object o = this.in.readObject();
            return o;
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    @Override
    public Object toObject(byte[] arr) {
        return this.toObject(arr, 0, arr.length);
    }
}

