/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.thrift;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolFactory;
import org.apache.storm.thrift.transport.TIOStreamTransport;

public class TSerializer {
    private final ByteArrayOutputStream baos_ = new ByteArrayOutputStream();
    private final TIOStreamTransport transport_ = new TIOStreamTransport(this.baos_);
    private TProtocol protocol_;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.transport_);
    }

    public byte[] serialize(TBase base) throws TException {
        this.baos_.reset();
        base.write(this.protocol_);
        return this.baos_.toByteArray();
    }

    public String toString(TBase base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public String toString(TBase base) throws TException {
        return new String(this.serialize(base));
    }
}

