/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;

public final class EdmondsKarpMaximumFlow<V, E> {
    public static final double DEFAULT_EPSILON = 1.0E-9;
    private DirectedGraph<V, E> network;
    private double epsilon;
    private int currentSource;
    private int currentSink;
    private Map<E, Double> maximumFlow;
    private Double maximumFlowValue;
    private int numNodes;
    private Map<V, Integer> indexer;
    private List<Node> nodes;

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> network) {
        this(network, 1.0E-9);
    }

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> network, double epsilon) {
        if (network == null) {
            throw new NullPointerException("network is null");
        }
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("invalid epsilon (must be positive)");
        }
        for (Object e : network.edgeSet()) {
            if (!(network.getEdgeWeight(e) < -epsilon)) continue;
            throw new IllegalArgumentException("invalid capacity (must be non-negative)");
        }
        this.network = network;
        this.epsilon = epsilon;
        this.currentSource = -1;
        this.currentSink = -1;
        this.maximumFlow = null;
        this.maximumFlowValue = null;
        this.buildInternalNetwork();
    }

    private void buildInternalNetwork() {
        int i;
        this.numNodes = this.network.vertexSet().size();
        this.nodes = new ArrayList<Node>();
        Iterator it = this.network.vertexSet().iterator();
        this.indexer = new HashMap<V, Integer>();
        for (i = 0; i < this.numNodes; ++i) {
            Object currentNode = it.next();
            this.nodes.add(new Node(currentNode));
            this.indexer.put((Integer)currentNode, i);
        }
        for (i = 0; i < this.numNodes; ++i) {
            Object we = this.nodes.get((int)i).prototype;
            for (E e : this.network.outgoingEdgesOf(we)) {
                Arc e2;
                Object he = this.network.getEdgeTarget(e);
                int j = this.indexer.get(he);
                Arc e1 = new Arc(i, j, this.network.getEdgeWeight(e), e);
                e1.reversed = e2 = new Arc(j, i, 0.0, null);
                e2.reversed = e1;
                this.nodes.get((int)i).outgoingArcs.add(e1);
                this.nodes.get((int)j).outgoingArcs.add(e2);
            }
        }
    }

    public void calculateMaximumFlow(V source, V sink) {
        int i;
        if (!this.network.containsVertex(source)) {
            throw new IllegalArgumentException("invalid source (null or not from this network)");
        }
        if (!this.network.containsVertex(sink)) {
            throw new IllegalArgumentException("invalid sink (null or not from this network)");
        }
        if (source.equals(sink)) {
            throw new IllegalArgumentException("source is equal to sink");
        }
        this.currentSource = this.indexer.get(source);
        this.currentSink = this.indexer.get(sink);
        for (i = 0; i < this.numNodes; ++i) {
            for (Arc currentArc : this.nodes.get((int)i).outgoingArcs) {
                currentArc.flow = 0.0;
            }
        }
        this.maximumFlowValue = 0.0;
        while (true) {
            this.breadthFirstSearch();
            if (!this.nodes.get((int)this.currentSink).visited) {
                this.maximumFlow = new HashMap<E, Double>();
                for (i = 0; i < this.numNodes; ++i) {
                    for (Arc currentArc : this.nodes.get((int)i).outgoingArcs) {
                        if (currentArc.prototype == null) continue;
                        this.maximumFlow.put(currentArc.prototype, currentArc.flow);
                    }
                }
                return;
            }
            this.augmentFlow();
        }
    }

    private void breadthFirstSearch() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes.get((int)i).visited = false;
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(this.currentSource);
        this.nodes.get((int)this.currentSource).visited = true;
        this.nodes.get((int)this.currentSource).flowAmount = Double.POSITIVE_INFINITY;
        while (queue.size() != 0) {
            int currentNode = (Integer)queue.poll();
            for (Arc currentArc : this.nodes.get((int)currentNode).outgoingArcs) {
                if (!(currentArc.flow + this.epsilon < currentArc.capacity) || this.nodes.get((int)currentArc.head).visited) continue;
                this.nodes.get((int)currentArc.head).visited = true;
                this.nodes.get((int)currentArc.head).flowAmount = Math.min(this.nodes.get((int)currentNode).flowAmount, currentArc.capacity - currentArc.flow);
                this.nodes.get((int)currentArc.head).lastArc = currentArc;
                queue.add(currentArc.head);
            }
        }
    }

    private void augmentFlow() {
        double deltaFlow = this.nodes.get((int)this.currentSink).flowAmount;
        this.maximumFlowValue = this.maximumFlowValue + deltaFlow;
        int currentNode = this.currentSink;
        while (currentNode != this.currentSource) {
            this.nodes.get((int)currentNode).lastArc.flow += deltaFlow;
            this.nodes.get((int)currentNode).lastArc.reversed.flow -= deltaFlow;
            currentNode = this.nodes.get((int)currentNode).lastArc.tail;
        }
    }

    public Double getMaximumFlowValue() {
        return this.maximumFlowValue;
    }

    public Map<E, Double> getMaximumFlow() {
        if (this.maximumFlow == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.maximumFlow);
    }

    public V getCurrentSource() {
        if (this.currentSource == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSource).prototype;
    }

    public V getCurrentSink() {
        if (this.currentSink == -1) {
            return null;
        }
        return this.nodes.get((int)this.currentSink).prototype;
    }

    class Arc {
        int tail;
        int head;
        double capacity;
        double flow;
        Arc reversed;
        E prototype;

        Arc(int tail, int head, double capacity, E prototype) {
            this.tail = tail;
            this.head = head;
            this.capacity = capacity;
            this.prototype = prototype;
        }
    }

    class Node {
        V prototype;
        List<Arc> outgoingArcs = new ArrayList<Arc>();
        boolean visited;
        Arc lastArc;
        double flowAmount;

        Node(V prototype) {
            this.prototype = prototype;
        }
    }
}

