/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpConstants;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.HttpDataFactory;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import org.apache.storm.shade.org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final InterfaceHttpPostRequestDecoder decoder;

    public HttpPostRequestDecoder(HttpRequest request) throws ErrorDataDecoderException {
        this(new DefaultHttpDataFactory(16384L), request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory factory, HttpRequest request) throws ErrorDataDecoderException {
        this(factory, request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) throws ErrorDataDecoderException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.decoder = HttpPostRequestDecoder.isMultipart(request) ? new HttpPostMultipartRequestDecoder(factory, request, charset) : new HttpPostStandardRequestDecoder(factory, request, charset);
    }

    public static boolean isMultipart(HttpRequest request) throws ErrorDataDecoderException {
        if (request.headers().contains("Content-Type")) {
            return HttpPostRequestDecoder.getMultipartDataBoundary(request.headers().get("Content-Type")) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String contentType) throws ErrorDataDecoderException {
        String[] headerContentType = HttpPostRequestDecoder.splitHeaderContentType(contentType);
        if (headerContentType[0].toLowerCase().startsWith("multipart/form-data")) {
            String charset;
            int index;
            String bound;
            int mrank = 1;
            int crank = 2;
            if (headerContentType[1].toLowerCase().startsWith("boundary".toString())) {
                mrank = 1;
                crank = 2;
            } else if (headerContentType[2].toLowerCase().startsWith("boundary".toString())) {
                mrank = 2;
                crank = 1;
            } else {
                return null;
            }
            String boundary = StringUtil.substringAfter(headerContentType[mrank], '=');
            if (boundary == null) {
                throw new ErrorDataDecoderException("Needs a boundary value");
            }
            if (boundary.charAt(0) == '\"' && (bound = boundary.trim()).charAt(index = bound.length() - 1) == '\"') {
                boundary = bound.substring(1, index);
            }
            if (headerContentType[crank].toLowerCase().startsWith("charset".toString()) && (charset = StringUtil.substringAfter(headerContentType[crank], '=')) != null) {
                return new String[]{"--" + boundary, charset};
            }
            return new String[]{"--" + boundary};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() throws NotEnoughDataDecoderException {
        return this.decoder.getBodyHttpDatas();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) throws NotEnoughDataDecoderException {
        return this.decoder.getBodyHttpDatas(name);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String name) throws NotEnoughDataDecoderException {
        return this.decoder.getBodyHttpData(name);
    }

    @Override
    public void offer(HttpChunk chunk) throws ErrorDataDecoderException {
        this.decoder.offer(chunk);
    }

    @Override
    public boolean hasNext() throws EndOfDataDecoderException {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() throws EndOfDataDecoderException {
        return this.decoder.next();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        this.decoder.removeHttpDataFromClean(data);
    }

    private static String[] splitHeaderContentType(String sb) {
        int bEnd;
        int aStart = HttpPostBodyUtil.findNonWhitespace(sb, 0);
        int aEnd = sb.indexOf(59);
        if (aEnd == -1) {
            return new String[]{sb, "", ""};
        }
        int bStart = HttpPostBodyUtil.findNonWhitespace(sb, aEnd + 1);
        if (sb.charAt(aEnd - 1) == ' ') {
            --aEnd;
        }
        if ((bEnd = sb.indexOf(59, bStart)) == -1) {
            bEnd = HttpPostBodyUtil.findEndOfString(sb);
            return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), ""};
        }
        int cStart = HttpPostBodyUtil.findNonWhitespace(sb, bEnd + 1);
        if (sb.charAt(bEnd - 1) == ' ') {
            --bEnd;
        }
        int cEnd = HttpPostBodyUtil.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), sb.substring(cStart, cEnd)};
    }

    public static class ErrorDataDecoderException
    extends Exception {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataDecoderException() {
        }

        public ErrorDataDecoderException(String msg) {
            super(msg);
        }

        public ErrorDataDecoderException(Throwable cause) {
            super(cause);
        }

        public ErrorDataDecoderException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class EndOfDataDecoderException
    extends Exception {
        private static final long serialVersionUID = 1336267941020800769L;
    }

    public static class NotEnoughDataDecoderException
    extends Exception {
        private static final long serialVersionUID = -7846841864603865638L;

        public NotEnoughDataDecoderException() {
        }

        public NotEnoughDataDecoderException(String msg) {
            super(msg);
        }

        public NotEnoughDataDecoderException(Throwable cause) {
            super(cause);
        }

        public NotEnoughDataDecoderException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MultiPartStatus {
        NOTSTARTED,
        PREAMBLE,
        HEADERDELIMITER,
        DISPOSITION,
        FIELD,
        FILEUPLOAD,
        MIXEDPREAMBLE,
        MIXEDDELIMITER,
        MIXEDDISPOSITION,
        MIXEDFILEUPLOAD,
        MIXEDCLOSEDELIMITER,
        CLOSEDELIMITER,
        PREEPILOGUE,
        EPILOGUE;

    }
}

