/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class IncreaseContainerAllocator
extends AbstractContainerAllocator {
    private static final Log LOG = LogFactory.getLog(IncreaseContainerAllocator.class);

    public IncreaseContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext) {
        super(application, rc, rmContext);
    }

    private boolean checkHeadroom(Resource clusterResource, ResourceLimits currentResourceLimits, Resource required) {
        return Resources.greaterThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)currentResourceLimits.getHeadroom(), (Resource)required);
    }

    private CSAssignment createReservedIncreasedCSAssignment(SchedContainerChangeRequest request) {
        CSAssignment assignment = new CSAssignment(request.getDeltaCapacity(), NodeType.NODE_LOCAL, null, this.application, CSAssignment.SkippedType.NONE, false);
        Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)request.getDeltaCapacity());
        assignment.getAssignmentInformation().incrReservations();
        assignment.getAssignmentInformation().addReservationDetails(request.getContainerId(), this.application.getCSLeafQueue().getQueuePath());
        assignment.setIncreasedAllocation(true);
        LOG.info((Object)("Reserved increase container request:" + request.toString()));
        return assignment;
    }

    private CSAssignment createSuccessfullyIncreasedCSAssignment(SchedContainerChangeRequest request, boolean fromReservation) {
        CSAssignment assignment = new CSAssignment(request.getDeltaCapacity(), NodeType.NODE_LOCAL, null, this.application, CSAssignment.SkippedType.NONE, fromReservation);
        Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)request.getDeltaCapacity());
        assignment.getAssignmentInformation().incrAllocations();
        assignment.getAssignmentInformation().addAllocationDetails(request.getContainerId(), this.application.getCSLeafQueue().getQueuePath());
        assignment.setIncreasedAllocation(true);
        this.application.getCSLeafQueue().getOrderingPolicy().containerAllocated(this.application, this.application.getRMContainer(request.getContainerId()));
        LOG.info((Object)("Approved increase container request:" + request.toString() + " fromReservation=" + fromReservation));
        return assignment;
    }

    private CSAssignment allocateIncreaseRequestFromReservedContainer(SchedulerNode node, Resource cluster, SchedContainerChangeRequest increaseRequest) {
        if (Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)increaseRequest.getDeltaCapacity(), (Resource)node.getAvailableResource())) {
            this.application.unreserve(increaseRequest.getPriority(), (FiCaSchedulerNode)node, increaseRequest.getRMContainer());
            this.application.increaseContainer(increaseRequest);
            node.increaseContainer(increaseRequest.getContainerId(), increaseRequest.getDeltaCapacity());
            return this.createSuccessfullyIncreasedCSAssignment(increaseRequest, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Failed to allocate reserved increase request:" + increaseRequest.toString() + ". There's no enough available resource"));
        }
        return CSAssignment.SKIP_ASSIGNMENT;
    }

    private CSAssignment allocateIncreaseRequest(FiCaSchedulerNode node, Resource cluster, SchedContainerChangeRequest increaseRequest) {
        if (Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)increaseRequest.getDeltaCapacity(), (Resource)node.getAvailableResource())) {
            node.increaseContainer(increaseRequest.getContainerId(), increaseRequest.getDeltaCapacity());
            this.application.increaseContainer(increaseRequest);
            return this.createSuccessfullyIncreasedCSAssignment(increaseRequest, false);
        }
        boolean reservationSucceeded = this.application.reserveIncreasedContainer(increaseRequest.getPriority(), node, increaseRequest.getRMContainer(), increaseRequest.getDeltaCapacity());
        if (reservationSucceeded) {
            return this.createReservedIncreasedCSAssignment(increaseRequest);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reserve increase request=" + increaseRequest.toString() + " failed. Skipping.."));
        }
        return CSAssignment.SKIP_ASSIGNMENT;
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, RMContainer reservedContainer) {
        SchedContainerChangeRequest request;
        AppSchedulingInfo sinfo = this.application.getAppSchedulingInfo();
        NodeId nodeId = node.getNodeID();
        if (reservedContainer == null) {
            boolean cannotAllocateAnything;
            if (!sinfo.hasIncreaseRequest(nodeId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip allocating increase request since we don't have any increase request on this node=" + node.getNodeID()));
                }
                return CSAssignment.SKIP_ASSIGNMENT;
            }
            boolean shouldUnreserve = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resourceLimits.getAmountNeededUnreserve(), (Resource)Resources.none());
            boolean bl = cannotAllocateAnything = !this.checkHeadroom(clusterResource, resourceLimits, this.rmContext.getScheduler().getMinimumResourceCapability());
            if (cannotAllocateAnything || shouldUnreserve) {
                if (LOG.isDebugEnabled()) {
                    if (shouldUnreserve) {
                        LOG.debug((Object)"Cannot continue since we have to unreserve some resource, now increase container allocation doesn't support continuous reservation looking..");
                    }
                    if (cannotAllocateAnything) {
                        LOG.debug((Object)("We cannot allocate anything because of low headroom, headroom=" + resourceLimits.getHeadroom()));
                    }
                }
                return CSAssignment.SKIP_ASSIGNMENT;
            }
            CSAssignment assigned = null;
            for (Priority priority : this.application.getPriorities()) {
                Map<ContainerId, SchedContainerChangeRequest> increaseRequestMap;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Looking at increase request for application=" + this.application.getApplicationAttemptId() + " priority=" + priority));
                }
                if (null == (increaseRequestMap = sinfo.getIncreaseRequests(nodeId, priority))) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("There's no increase request for " + this.application.getApplicationAttemptId() + " priority=" + priority));
                    continue;
                }
                Iterator<Map.Entry<ContainerId, SchedContainerChangeRequest>> iter = increaseRequestMap.entrySet().iterator();
                ArrayList<SchedContainerChangeRequest> toBeRemovedRequests = new ArrayList<SchedContainerChangeRequest>();
                while (iter.hasNext()) {
                    boolean headroomSatisifed;
                    Map.Entry<ContainerId, SchedContainerChangeRequest> entry = iter.next();
                    SchedContainerChangeRequest increaseRequest = entry.getValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Looking at increase request=" + increaseRequest.toString()));
                    }
                    if (!(headroomSatisifed = this.checkHeadroom(clusterResource, resourceLimits, increaseRequest.getDeltaCapacity()))) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)" Headroom is not satisfied, skip..");
                        continue;
                    }
                    RMContainer rmContainer = increaseRequest.getRMContainer();
                    if (rmContainer.getContainerState() != ContainerState.RUNNING) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"  Container is not running any more, skip...");
                        }
                        toBeRemovedRequests.add(increaseRequest);
                        continue;
                    }
                    if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)increaseRequest.getTargetCapacity(), (Resource)node.getTotalResource())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("  Target capacity is more than what node can offer, node.resource=" + node.getTotalResource()));
                        }
                        toBeRemovedRequests.add(increaseRequest);
                        continue;
                    }
                    assigned = this.allocateIncreaseRequest(node, clusterResource, increaseRequest);
                    if (assigned.getSkippedType() != CSAssignment.SkippedType.NONE) continue;
                    break;
                }
                if (!toBeRemovedRequests.isEmpty()) {
                    for (SchedContainerChangeRequest req : toBeRemovedRequests) {
                        sinfo.removeIncreaseRequest(req.getNodeId(), req.getPriority(), req.getContainerId());
                    }
                }
                if (assigned == null || assigned.getSkippedType() != CSAssignment.SkippedType.NONE) continue;
                break;
            }
            return assigned == null ? CSAssignment.SKIP_ASSIGNMENT : assigned;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Trying to allocate reserved increase container request..");
        }
        if (null == (request = sinfo.getIncreaseRequest(nodeId, reservedContainer.getContainer().getPriority(), reservedContainer.getContainerId())) || reservedContainer.getContainerState() != ContainerState.RUNNING || !Resources.equals((Resource)reservedContainer.getReservedResource(), (Resource)request.getDeltaCapacity())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("We don't need reserved increase container request for container=" + reservedContainer.getContainerId() + ". Unreserving and return..."));
            }
            return new CSAssignment(this.application, reservedContainer);
        }
        return this.allocateIncreaseRequestFromReservedContainer(node, clusterResource, request);
    }
}

