/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ResourceWeights {
    public static final ResourceWeights NEUTRAL = new ResourceWeights(1.0f);
    private float[] weights = new float[ResourceType.values().length];

    public ResourceWeights(float memoryWeight, float cpuWeight) {
        this.weights[ResourceType.MEMORY.ordinal()] = memoryWeight;
        this.weights[ResourceType.CPU.ordinal()] = cpuWeight;
    }

    public ResourceWeights(float weight) {
        this.setWeight(weight);
    }

    public ResourceWeights() {
    }

    public void setWeight(float weight) {
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = weight;
        }
    }

    public void setWeight(ResourceType resourceType, float weight) {
        this.weights[resourceType.ordinal()] = weight;
    }

    public float getWeight(ResourceType resourceType) {
        return this.weights[resourceType.ordinal()];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        for (int i = 0; i < ResourceType.values().length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            ResourceType resourceType = ResourceType.values()[i];
            sb.append(StringUtils.toLowerCase((String)resourceType.name()));
            sb.append(StringUtils.format((String)" weight=%.1f", (Object[])new Object[]{Float.valueOf(this.getWeight(resourceType))}));
        }
        sb.append(">");
        return sb.toString();
    }
}

