/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.ListIterator;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageEarliestStart;

public class StageEarliestStartByDemand
implements StageEarliestStart {
    private long step;

    @Override
    public long setEarliestStartTime(Plan plan, ReservationDefinition reservation, int index, ReservationRequest current, long stageDeadline) {
        this.step = plan.getStep();
        if (index < 1) {
            return reservation.getArrival();
        }
        ListIterator li = reservation.getReservationRequests().getReservationResources().listIterator(index);
        double totalWeight = this.calcWeight(current);
        long totalDuration = this.getRoundedDuration(current, plan);
        while (li.hasPrevious()) {
            ReservationRequest rr = (ReservationRequest)li.previous();
            totalWeight += this.calcWeight(rr);
            totalDuration += this.getRoundedDuration(rr, plan);
        }
        double ratio = this.calcWeight(current) / totalWeight;
        long window = stageDeadline - reservation.getArrival();
        long windowRemainder = window - totalDuration;
        long earlyStart = (long)((double)(stageDeadline - this.getRoundedDuration(current, plan)) - (double)windowRemainder * ratio);
        earlyStart = StageEarliestStartByDemand.stepRoundUp(earlyStart, this.step);
        return earlyStart;
    }

    protected double calcWeight(ReservationRequest stage) {
        return stage.getDuration() * stage.getCapability().getMemorySize() * (long)stage.getNumContainers();
    }

    protected long getRoundedDuration(ReservationRequest stage, Plan plan) {
        return StageEarliestStartByDemand.stepRoundUp(stage.getDuration(), this.step);
    }

    protected static long stepRoundDown(long t, long step) {
        return t / step * step;
    }

    protected static long stepRoundUp(long t, long step) {
        return (t + step - 1L) / step * step;
    }
}

