/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class InMemoryReservationAllocation
implements ReservationAllocation {
    private final String planName;
    private final ReservationId reservationID;
    private final String user;
    private final ReservationDefinition contract;
    private final long startTime;
    private final long endTime;
    private final Map<ReservationInterval, Resource> allocationRequests;
    private boolean hasGang = false;
    private long acceptedAt = -1L;
    private RLESparseResourceAllocation resourcesOverTime;

    public InMemoryReservationAllocation(ReservationId reservationID, ReservationDefinition contract, String user, String planName, long startTime, long endTime, Map<ReservationInterval, Resource> allocations, ResourceCalculator calculator, Resource minAlloc) {
        this(reservationID, contract, user, planName, startTime, endTime, allocations, calculator, minAlloc, false);
    }

    public InMemoryReservationAllocation(ReservationId reservationID, ReservationDefinition contract, String user, String planName, long startTime, long endTime, Map<ReservationInterval, Resource> allocations, ResourceCalculator calculator, Resource minAlloc, boolean hasGang) {
        this.contract = contract;
        this.startTime = startTime;
        this.endTime = endTime;
        this.reservationID = reservationID;
        this.user = user;
        this.allocationRequests = allocations;
        this.planName = planName;
        this.hasGang = hasGang;
        this.resourcesOverTime = new RLESparseResourceAllocation(calculator);
        for (Map.Entry<ReservationInterval, Resource> r : allocations.entrySet()) {
            this.resourcesOverTime.addInterval(r.getKey(), r.getValue());
        }
    }

    @Override
    public ReservationId getReservationId() {
        return this.reservationID;
    }

    @Override
    public ReservationDefinition getReservationDefinition() {
        return this.contract;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public Map<ReservationInterval, Resource> getAllocationRequests() {
        return Collections.unmodifiableMap(this.allocationRequests);
    }

    @Override
    public String getPlanName() {
        return this.planName;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean containsGangs() {
        return this.hasGang;
    }

    @Override
    public void setAcceptanceTimestamp(long acceptedAt) {
        this.acceptedAt = acceptedAt;
    }

    @Override
    public long getAcceptanceTime() {
        return this.acceptedAt;
    }

    @Override
    public Resource getResourcesAtTime(long tick) {
        if (tick < this.startTime || tick >= this.endTime) {
            return Resource.newInstance((int)0, (int)0);
        }
        return Resources.clone((Resource)this.resourcesOverTime.getCapacityAtTime(tick));
    }

    @Override
    public RLESparseResourceAllocation getResourcesOverTime() {
        return this.resourcesOverTime;
    }

    public String toString() {
        StringBuilder sBuf = new StringBuilder();
        sBuf.append(this.getReservationId()).append(" user:").append(this.getUser()).append(" startTime: ").append(this.getStartTime()).append(" endTime: ").append(this.getEndTime()).append(" alloc:\n[").append(this.resourcesOverTime.toString()).append("] ");
        return sBuf.toString();
    }

    @Override
    public int compareTo(ReservationAllocation other) {
        if (this.getAcceptanceTime() > other.getAcceptanceTime()) {
            return -1;
        }
        if (this.getAcceptanceTime() < other.getAcceptanceTime()) {
            return 1;
        }
        if (this.getReservationId().getId() > other.getReservationId().getId()) {
            return -1;
        }
        if (this.getReservationId().getId() < other.getReservationId().getId()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.reservationID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemoryReservationAllocation other = (InMemoryReservationAllocation)obj;
        return this.reservationID.equals((Object)other.getReservationId());
    }
}

