/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.LSApprovedWorkers;
import org.apache.storm.generated.LSSupervisorAssignments;
import org.apache.storm.generated.LSSupervisorId;
import org.apache.storm.generated.LSTopoHistory;
import org.apache.storm.generated.LSTopoHistoryList;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.LocalStateData;
import org.apache.storm.generated.ThriftSerializedObject;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TDeserializer;
import org.apache.storm.thrift.TSerializer;
import org.apache.storm.thrift.protocol.TProtocolException;
import org.apache.storm.utils.VersionedStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalState {
    public static final Logger LOG = LoggerFactory.getLogger(LocalState.class);
    public static final String LS_WORKER_HEARTBEAT = "worker-heartbeat";
    public static final String LS_ID = "supervisor-id";
    public static final String LS_LOCAL_ASSIGNMENTS = "local-assignments";
    public static final String LS_APPROVED_WORKERS = "approved-workers";
    public static final String LS_TOPO_HISTORY = "topo-hist";
    private VersionedStore versionedStore;

    public LocalState(String backingDir, boolean createBackingDir) throws IOException {
        LOG.debug("New Local State for {}", (Object)backingDir);
        this.versionedStore = new VersionedStore(backingDir, createBackingDir);
    }

    public synchronized Map<String, TBase> snapshot() {
        int attempts = 0;
        while (true) {
            try {
                return this.deserializeLatestVersion();
            }
            catch (Exception e) {
                if (++attempts < 10) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    private Map<String, TBase> deserializeLatestVersion() throws IOException {
        HashMap<String, TBase> result2 = new HashMap<String, TBase>();
        TDeserializer td = new TDeserializer();
        for (Map.Entry<String, ThriftSerializedObject> ent : this.partialDeserializeLatestVersion(td).entrySet()) {
            result2.put(ent.getKey(), this.deserialize(ent.getValue(), td));
        }
        return result2;
    }

    private TBase deserialize(ThriftSerializedObject obj, TDeserializer td) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(obj.get_name());
            }
            catch (ClassNotFoundException ex) {
                clazz = Class.forName(obj.get_name().replaceAll("^backtype\\.storm\\.", "org.apache.storm."));
            }
            TBase instance = (TBase)clazz.newInstance();
            td.deserialize(instance, obj.get_bits());
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, ThriftSerializedObject> partialDeserializeLatestVersion(TDeserializer td) {
        try {
            String latestPath = this.versionedStore.mostRecentVersionPath();
            Map<String, ThriftSerializedObject> result2 = new HashMap<String, ThriftSerializedObject>();
            if (latestPath != null) {
                byte[] serialized = FileUtils.readFileToByteArray((File)new File(latestPath));
                if (serialized.length == 0) {
                    LOG.warn("LocalState file '{}' contained no data, resetting state", (Object)latestPath);
                } else {
                    if (td == null) {
                        td = new TDeserializer();
                    }
                    LocalStateData data = new LocalStateData();
                    td.deserialize((TBase)data, serialized);
                    result2 = data.get_serialized_parts();
                }
            }
            return result2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized Map<String, ThriftSerializedObject> partialSnapshot(TDeserializer td) {
        int attempts = 0;
        while (true) {
            try {
                return this.partialDeserializeLatestVersion(td);
            }
            catch (Exception e) {
                if (++attempts < 10) continue;
                if (e.getCause() instanceof TProtocolException) {
                    LOG.warn("LocalState file is corrupted, resetting state.", (Throwable)e);
                    return new HashMap<String, ThriftSerializedObject>();
                }
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public TBase get(String key) {
        TDeserializer td = new TDeserializer();
        Map<String, ThriftSerializedObject> partial = this.partialSnapshot(td);
        ThriftSerializedObject tso = partial.get(key);
        TBase ret = null;
        if (tso != null) {
            ret = this.deserialize(tso, td);
        }
        return ret;
    }

    public void put(String key, TBase val) {
        this.put(key, val, true);
    }

    public synchronized void put(String key, TBase val, boolean cleanup) {
        Map<String, ThriftSerializedObject> curr = this.partialSnapshot(null);
        TSerializer ser = new TSerializer();
        curr.put(key, this.serialize(val, ser));
        this.persistInternal(curr, ser, cleanup);
    }

    public void remove(String key) {
        this.remove(key, true);
    }

    public synchronized void remove(String key, boolean cleanup) {
        Map<String, ThriftSerializedObject> curr = this.partialSnapshot(null);
        curr.remove(key);
        this.persistInternal(curr, null, cleanup);
    }

    public synchronized void cleanup(int keepVersions) throws IOException {
        this.versionedStore.cleanup(keepVersions);
    }

    public List<LSTopoHistory> getTopoHistoryList() {
        LSTopoHistoryList lsTopoHistoryListWrapper = (LSTopoHistoryList)this.get(LS_TOPO_HISTORY);
        if (null != lsTopoHistoryListWrapper) {
            return lsTopoHistoryListWrapper.get_topo_history();
        }
        return null;
    }

    public void filterOldTopologies(long cutOffAge) {
        LSTopoHistoryList lsTopoHistoryListWrapper = (LSTopoHistoryList)this.get(LS_TOPO_HISTORY);
        ArrayList<LSTopoHistory> filteredTopoHistoryList = new ArrayList<LSTopoHistory>();
        if (null != lsTopoHistoryListWrapper) {
            for (LSTopoHistory topoHistory : lsTopoHistoryListWrapper.get_topo_history()) {
                if (topoHistory.get_time_stamp() <= cutOffAge) continue;
                filteredTopoHistoryList.add(topoHistory);
            }
        }
        this.put(LS_TOPO_HISTORY, new LSTopoHistoryList(filteredTopoHistoryList));
    }

    public void addTopologyHistory(LSTopoHistory lsTopoHistory) {
        LSTopoHistoryList lsTopoHistoryListWrapper = (LSTopoHistoryList)this.get(LS_TOPO_HISTORY);
        ArrayList<LSTopoHistory> currentTopoHistoryList = new ArrayList<LSTopoHistory>();
        if (null != lsTopoHistoryListWrapper) {
            currentTopoHistoryList.addAll(lsTopoHistoryListWrapper.get_topo_history());
        }
        currentTopoHistoryList.add(lsTopoHistory);
        this.put(LS_TOPO_HISTORY, new LSTopoHistoryList(currentTopoHistoryList));
    }

    public String getSupervisorId() {
        LSSupervisorId lsSupervisorId = (LSSupervisorId)this.get(LS_ID);
        if (null != lsSupervisorId) {
            return lsSupervisorId.get_supervisor_id();
        }
        return null;
    }

    public void setSupervisorId(String supervisorId) {
        this.put(LS_ID, new LSSupervisorId(supervisorId));
    }

    public Map<String, Integer> getApprovedWorkers() {
        LSApprovedWorkers lsApprovedWorkers = (LSApprovedWorkers)this.get(LS_APPROVED_WORKERS);
        if (null != lsApprovedWorkers) {
            return lsApprovedWorkers.get_approved_workers();
        }
        return null;
    }

    public void setApprovedWorkers(Map<String, Integer> approvedWorkers) {
        this.put(LS_APPROVED_WORKERS, new LSApprovedWorkers(approvedWorkers));
    }

    public LSWorkerHeartbeat getWorkerHeartBeat() {
        return (LSWorkerHeartbeat)this.get(LS_WORKER_HEARTBEAT);
    }

    public void setWorkerHeartBeat(LSWorkerHeartbeat workerHeartBeat) {
        this.put(LS_WORKER_HEARTBEAT, workerHeartBeat, false);
    }

    public Map<Integer, LocalAssignment> getLocalAssignmentsMap() {
        LSSupervisorAssignments assignments = (LSSupervisorAssignments)this.get(LS_LOCAL_ASSIGNMENTS);
        if (null != assignments) {
            return assignments.get_assignments();
        }
        return null;
    }

    public void setLocalAssignmentsMap(Map<Integer, LocalAssignment> localAssignmentMap) {
        this.put(LS_LOCAL_ASSIGNMENTS, new LSSupervisorAssignments(localAssignmentMap));
    }

    private void persistInternal(Map<String, ThriftSerializedObject> serialized, TSerializer ser, boolean cleanup) {
        try {
            if (ser == null) {
                ser = new TSerializer();
            }
            byte[] toWrite = ser.serialize((TBase)new LocalStateData(serialized));
            String newPath = this.versionedStore.createVersion();
            File file = new File(newPath);
            FileUtils.writeByteArrayToFile((File)file, (byte[])toWrite);
            if ((long)toWrite.length != file.length()) {
                throw new IOException("Tried to serialize " + toWrite.length + " bytes to " + file.getCanonicalPath() + ", but " + file.length() + " bytes were written.");
            }
            this.versionedStore.succeedVersion(newPath);
            if (cleanup) {
                this.versionedStore.cleanup(4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ThriftSerializedObject serialize(TBase o, TSerializer ser) {
        try {
            return new ThriftSerializedObject(o.getClass().getName(), ByteBuffer.wrap(ser.serialize(o)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

