/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.windowing.ITridentWindowManager;
import org.apache.storm.trident.windowing.WindowTridentProcessor;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.config.WindowConfig;
import org.apache.storm.trident.windowing.strategy.WindowStrategy;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.TriggerPolicy;
import org.apache.storm.windowing.WindowLifecycleListener;
import org.apache.storm.windowing.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTridentWindowManager<T>
implements ITridentWindowManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTridentWindowManager.class);
    protected final WindowManager<T> windowManager;
    protected final Aggregator aggregator;
    protected final BatchOutputCollector delegateCollector;
    protected final String windowTaskId;
    protected final WindowsStore windowStore;
    protected final Queue<TriggerResult> pendingTriggers = new ConcurrentLinkedQueue<TriggerResult>();
    protected final AtomicInteger triggerId = new AtomicInteger();
    private final String windowTriggerCountId;
    private final TriggerPolicy<T, ?> triggerPolicy;

    public AbstractTridentWindowManager(WindowConfig windowConfig, String windowTaskId, WindowsStore windowStore, Aggregator aggregator, BatchOutputCollector delegateCollector) {
        this.windowTaskId = windowTaskId;
        this.windowStore = windowStore;
        this.aggregator = aggregator;
        this.delegateCollector = delegateCollector;
        this.windowTriggerCountId = "tc|" + windowTaskId;
        this.windowManager = new WindowManager(new TridentWindowLifeCycleListener());
        WindowStrategy windowStrategy = windowConfig.getWindowStrategy();
        EvictionPolicy evictionPolicy = windowStrategy.getEvictionPolicy();
        this.windowManager.setEvictionPolicy(evictionPolicy);
        this.triggerPolicy = windowStrategy.getTriggerPolicy(this.windowManager, evictionPolicy);
        this.windowManager.setTriggerPolicy(this.triggerPolicy);
    }

    @Override
    public void prepare() {
        this.preInitialize();
        this.initialize();
        this.postInitialize();
    }

    private void preInitialize() {
        LOG.debug("Getting current trigger count for this component/task");
        Object result2 = this.windowStore.get(this.windowTriggerCountId);
        Integer currentCount = 0;
        if (result2 == null) {
            LOG.info("No current trigger count in windows store.");
        } else {
            currentCount = (Integer)result2 + 1;
        }
        this.windowStore.put(this.windowTriggerCountId, currentCount);
        this.triggerId.set(currentCount);
    }

    private void postInitialize() {
        this.triggerPolicy.start();
    }

    protected abstract void initialize();

    protected abstract void onTuplesExpired(List<T> var1);

    private void execAggregatorAndStoreResult(int currentTriggerId, List<T> tupleEvents) {
        List<TridentTuple> resultTuples = this.getTridentTuples(tupleEvents);
        AccumulatedTuplesCollector collector = new AccumulatedTuplesCollector(this.delegateCollector);
        Object state = this.aggregator.init(currentTriggerId, collector);
        for (TridentTuple resultTuple : resultTuples) {
            this.aggregator.aggregate(state, resultTuple, collector);
        }
        this.aggregator.complete(state, collector);
        List<List<Object>> resultantAggregatedValue = collector.values;
        ArrayList entries = Lists.newArrayList((Object[])new WindowsStore.Entry[]{new WindowsStore.Entry(this.windowTriggerCountId, currentTriggerId + 1), new WindowsStore.Entry(WindowTridentProcessor.generateWindowTriggerKey(this.windowTaskId, currentTriggerId), resultantAggregatedValue)});
        this.windowStore.putAll(entries);
        this.pendingTriggers.add(new TriggerResult(currentTriggerId, resultantAggregatedValue));
    }

    protected abstract List<TridentTuple> getTridentTuples(List<T> var1);

    @Override
    public Queue<TriggerResult> getPendingTriggers() {
        return this.pendingTriggers;
    }

    @Override
    public void shutdown() {
        try {
            LOG.info("window manager [{}] is being shutdown", this.windowManager);
            this.windowManager.shutdown();
        }
        finally {
            LOG.info("window store [{}] is being shutdown", (Object)this.windowStore);
            this.windowStore.shutdown();
        }
    }

    class TridentWindowLifeCycleListener
    implements WindowLifecycleListener<T> {
        TridentWindowLifeCycleListener() {
        }

        @Override
        public void onExpiry(List<T> expiredEvents) {
            LOG.debug("onExpiry is invoked");
            AbstractTridentWindowManager.this.onTuplesExpired(expiredEvents);
        }

        @Override
        public void onActivation(List<T> events, List<T> newEvents, List<T> expired, Long timestamp) {
            LOG.debug("onActivation is invoked with events size: [{}]", (Object)events.size());
            int currentTriggerId = AbstractTridentWindowManager.this.triggerId.incrementAndGet();
            AbstractTridentWindowManager.this.execAggregatorAndStoreResult(currentTriggerId, events);
        }
    }

    static class TriggerResult {
        final int id;
        final List<List<Object>> result;

        TriggerResult(int id, List<List<Object>> result2) {
            this.id = id;
            this.result = result2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TriggerResult)) {
                return false;
            }
            TriggerResult that = (TriggerResult)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "TriggerResult{id=" + this.id + ", result=" + this.result + '}';
        }
    }

    static class AccumulatedTuplesCollector
    implements TridentCollector {
        final List<List<Object>> values = new ArrayList<List<Object>>();
        private final BatchOutputCollector delegateCollector;

        AccumulatedTuplesCollector(BatchOutputCollector delegateCollector) {
            this.delegateCollector = delegateCollector;
        }

        @Override
        public void emit(List<Object> values) {
            this.values.add(values);
        }

        @Override
        public void flush() {
        }

        @Override
        public void reportError(Throwable t) {
            this.delegateCollector.reportError(t);
        }
    }
}

