/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.policy;

import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.utils.ObjectReader;

public class WaitStrategyProgressive
implements IWaitStrategy {
    private int level1Count;
    private int level2Count;
    private long level3SleepMs;

    @Override
    public void prepare(Map<String, Object> conf, IWaitStrategy.WaitSituation waitSituation) {
        if (waitSituation == IWaitStrategy.WaitSituation.SPOUT_WAIT) {
            this.level1Count = ObjectReader.getInt(conf.get("topology.spout.wait.progressive.level1.count"));
            this.level2Count = ObjectReader.getInt(conf.get("topology.spout.wait.progressive.level2.count"));
            this.level3SleepMs = ObjectReader.getLong(conf.get("topology.spout.wait.progressive.level3.sleep.millis"));
        } else if (waitSituation == IWaitStrategy.WaitSituation.BOLT_WAIT) {
            this.level1Count = ObjectReader.getInt(conf.get("topology.bolt.wait.progressive.level1.count"));
            this.level2Count = ObjectReader.getInt(conf.get("topology.bolt.wait.progressive.level2.count"));
            this.level3SleepMs = ObjectReader.getLong(conf.get("topology.bolt.wait.progressive.level3.sleep.millis"));
        } else if (waitSituation == IWaitStrategy.WaitSituation.BACK_PRESSURE_WAIT) {
            this.level1Count = ObjectReader.getInt(conf.get("topology.backpressure.wait.progressive.level1.count"));
            this.level2Count = ObjectReader.getInt(conf.get("topology.backpressure.wait.progressive.level2.count"));
            this.level3SleepMs = ObjectReader.getLong(conf.get("topology.backpressure.wait.progressive.level3.sleep.millis"));
        } else {
            throw new IllegalArgumentException("Unknown wait situation : " + (Object)((Object)waitSituation));
        }
    }

    @Override
    public int idle(int idleCounter) throws InterruptedException {
        if (idleCounter < this.level1Count) {
            ++idleCounter;
        } else if (idleCounter < this.level1Count + this.level2Count) {
            ++idleCounter;
            LockSupport.parkNanos(1L);
        } else {
            Thread.sleep(this.level3SleepMs);
        }
        return idleCounter;
    }
}

