/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.ScheduledStormReporter;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvStormReporter
extends ScheduledStormReporter {
    public static final String CSV_LOG_DIR = "csv.log.dir";
    private static final Logger LOG = LoggerFactory.getLogger(CsvStormReporter.class);

    private static File getCsvLogDir(Map stormConf, Map reporterConf) {
        String csvMetricsLogDirectory = ObjectReader.getString(reporterConf.get(CSV_LOG_DIR), null);
        if (csvMetricsLogDirectory == null) {
            csvMetricsLogDirectory = ConfigUtils.absoluteStormLocalDir(stormConf);
            csvMetricsLogDirectory = csvMetricsLogDirectory + ConfigUtils.FILE_SEPARATOR + "csvmetrics";
        }
        File csvMetricsDir = new File(csvMetricsLogDirectory);
        CsvStormReporter.validateCreateOutputDir(csvMetricsDir);
        return csvMetricsDir;
    }

    private static void validateCreateOutputDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.canWrite()) {
            throw new IllegalStateException(dir.getName() + " does not have write permissions.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException(dir.getName() + " is not a directory.");
        }
    }

    public void prepare(MetricRegistry metricsRegistry, Map stormConf, Map reporterConf) {
        StormMetricsFilter filter;
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing...");
        CsvReporter.Builder builder = CsvReporter.forRegistry((MetricRegistry)metricsRegistry);
        Locale locale = ClientMetricsUtils.getMetricsReporterLocale(reporterConf);
        if (locale != null) {
            builder.formatFor(locale);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(reporterConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = ClientMetricsUtils.getMetricsDurationUnit(reporterConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        if ((filter = CsvStormReporter.getMetricsFilter(reporterConf)) != null) {
            builder.filter((MetricFilter)filter);
        }
        this.reportingPeriod = CsvStormReporter.getReportPeriod(reporterConf);
        this.reportingPeriodUnit = CsvStormReporter.getReportPeriodUnit(reporterConf);
        File csvMetricsDir = CsvStormReporter.getCsvLogDir(stormConf, reporterConf);
        this.reporter = builder.build(csvMetricsDir);
    }
}

