/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.internal.LatencyStatAndMetric;

public class MultiLatencyStatAndMetric<T>
implements IMetric {
    private final int numBuckets;
    private ConcurrentHashMap<T, LatencyStatAndMetric> lat = new ConcurrentHashMap();

    public MultiLatencyStatAndMetric(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LatencyStatAndMetric get(T key) {
        LatencyStatAndMetric c = this.lat.get(key);
        if (c == null) {
            MultiLatencyStatAndMetric multiLatencyStatAndMetric = this;
            synchronized (multiLatencyStatAndMetric) {
                c = this.lat.get(key);
                if (c == null) {
                    c = new LatencyStatAndMetric(this.numBuckets);
                    this.lat.put(key, c);
                }
            }
        }
        return c;
    }

    public void record(T key, long latency) {
        this.get(key).record(latency);
    }

    protected String keyToString(T key) {
        if (key instanceof List) {
            List lk = (List)key;
            return (String)lk.get(0) + ":" + (String)lk.get(1);
        }
        return key.toString();
    }

    @Override
    public Object getValueAndReset() {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        for (Map.Entry<T, LatencyStatAndMetric> entry : this.lat.entrySet()) {
            String key = this.keyToString(entry.getKey());
            Double val = (Double)entry.getValue().getValueAndReset();
            ret.put(key, val);
        }
        return ret;
    }

    public Map<String, Map<T, Double>> getTimeLatAvg() {
        HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
        for (Map.Entry<T, LatencyStatAndMetric> entry : this.lat.entrySet()) {
            T key = entry.getKey();
            Map<String, Double> toFlip = entry.getValue().getTimeLatAvg();
            for (Map.Entry<String, Double> subEntry : toFlip.entrySet()) {
                String time = subEntry.getKey();
                HashMap<T, Double> tmp = (HashMap<T, Double>)ret.get(time);
                if (tmp == null) {
                    tmp = new HashMap<T, Double>();
                    ret.put(time, tmp);
                }
                tmp.put(key, subEntry.getValue());
            }
        }
        return ret;
    }

    public void close() {
        for (LatencyStatAndMetric l : this.lat.values()) {
            l.close();
        }
    }
}

