/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.bolt;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.storm.daemon.Task;
import org.apache.storm.executor.ExecutorTransfer;
import org.apache.storm.executor.bolt.BoltExecutor;
import org.apache.storm.hooks.info.BoltAckInfo;
import org.apache.storm.hooks.info.BoltFailInfo;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.MessageId;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltOutputCollectorImpl
implements IOutputCollector {
    private static final Logger LOG = LoggerFactory.getLogger(BoltOutputCollectorImpl.class);
    private final BoltExecutor executor;
    private final Task task;
    private final int taskId;
    private final Random random;
    private final boolean isEventLoggers;
    private final ExecutorTransfer xsfer;
    private final boolean isDebug;
    private boolean ackingEnabled;

    public BoltOutputCollectorImpl(BoltExecutor executor, Task taskData, Random random, boolean isEventLoggers, boolean ackingEnabled, boolean isDebug) {
        this.executor = executor;
        this.task = taskData;
        this.taskId = taskData.getTaskId();
        this.random = random;
        this.isEventLoggers = isEventLoggers;
        this.ackingEnabled = ackingEnabled;
        this.isDebug = isDebug;
        this.xsfer = executor.getExecutorTransfer();
    }

    @Override
    public List<Integer> emit(String streamId, Collection<Tuple> anchors, List<Object> tuple) {
        try {
            return this.boltEmit(streamId, anchors, tuple, null);
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted when emiting tuple.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void emitDirect(int taskId, String streamId, Collection<Tuple> anchors, List<Object> tuple) {
        try {
            this.boltEmit(streamId, anchors, tuple, taskId);
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted when emiting tuple.");
            throw new RuntimeException(e);
        }
    }

    private List<Integer> boltEmit(String streamId, Collection<Tuple> anchors, List<Object> values, Integer targetTaskId) throws InterruptedException {
        List<Integer> outTasks = targetTaskId != null ? this.task.getOutgoingTasks(targetTaskId, streamId, values) : this.task.getOutgoingTasks(streamId, values);
        for (int i = 0; i < outTasks.size(); ++i) {
            MessageId msgId;
            Integer t = outTasks.get(i);
            if (this.ackingEnabled && anchors != null) {
                HashMap<Long, Long> anchorsToIds = new HashMap<Long, Long>();
                for (Tuple a : anchors) {
                    Set<Long> rootIds = a.getMessageId().getAnchorsToIds().keySet();
                    if (rootIds.size() <= 0) continue;
                    long edgeId = MessageId.generateId(this.random);
                    ((TupleImpl)a).updateAckVal(edgeId);
                    for (Long rootId : rootIds) {
                        this.putXor(anchorsToIds, rootId, edgeId);
                    }
                }
                msgId = MessageId.makeId(anchorsToIds);
            } else {
                msgId = MessageId.makeUnanchored();
            }
            TupleImpl tupleExt = new TupleImpl(this.executor.getWorkerTopologyContext(), values, this.executor.getComponentId(), this.taskId, streamId, msgId);
            this.xsfer.tryTransfer(new AddressedTuple(t, tupleExt), this.executor.getPendingEmits());
        }
        if (this.isEventLoggers) {
            this.task.sendToEventLogger(this.executor, values, this.executor.getComponentId(), null, this.random, this.executor.getPendingEmits());
        }
        return outTasks;
    }

    @Override
    public void ack(Tuple input) {
        if (!this.ackingEnabled) {
            return;
        }
        long ackValue = ((TupleImpl)input).getAckVal();
        Map<Long, Long> anchorsToIds = input.getMessageId().getAnchorsToIds();
        for (Map.Entry<Long, Long> entry : anchorsToIds.entrySet()) {
            this.task.sendUnanchored("__ack_ack", new Values(entry.getKey(), Utils.bitXor(entry.getValue(), ackValue)), this.executor.getExecutorTransfer(), this.executor.getPendingEmits());
        }
        long delta = this.tupleTimeDelta((TupleImpl)input);
        if (this.isDebug) {
            LOG.info("BOLT ack TASK: {} TIME: {} TUPLE: {}", new Object[]{this.taskId, delta, input});
        }
        if (!this.task.getUserContext().getHooks().isEmpty()) {
            BoltAckInfo boltAckInfo = new BoltAckInfo(input, this.taskId, delta);
            boltAckInfo.applyOn(this.task.getUserContext());
        }
        if (delta >= 0L) {
            this.executor.getStats().boltAckedTuple(input.getSourceComponent(), input.getSourceStreamId(), delta, this.task.getTaskMetrics().getAcked(input.getSourceStreamId()));
        }
    }

    @Override
    public void fail(Tuple input) {
        if (!this.ackingEnabled) {
            return;
        }
        Set<Long> roots = input.getMessageId().getAnchors();
        for (Long root : roots) {
            this.task.sendUnanchored("__ack_fail", new Values(root), this.executor.getExecutorTransfer(), this.executor.getPendingEmits());
        }
        long delta = this.tupleTimeDelta((TupleImpl)input);
        if (this.isDebug) {
            LOG.info("BOLT fail TASK: {} TIME: {} TUPLE: {}", new Object[]{this.taskId, delta, input});
        }
        BoltFailInfo boltFailInfo = new BoltFailInfo(input, this.taskId, delta);
        boltFailInfo.applyOn(this.task.getUserContext());
        if (delta >= 0L) {
            this.executor.getStats().boltFailedTuple(input.getSourceComponent(), input.getSourceStreamId(), delta, this.task.getTaskMetrics().getFailed(input.getSourceStreamId()));
        }
    }

    @Override
    public void resetTimeout(Tuple input) {
        Set<Long> roots = input.getMessageId().getAnchors();
        for (Long root : roots) {
            this.task.sendUnanchored("__ack_reset_timeout", new Values(root), this.executor.getExecutorTransfer(), this.executor.getPendingEmits());
        }
    }

    @Override
    public void flush() {
        try {
            this.xsfer.flush();
        }
        catch (InterruptedException e) {
            LOG.warn("Bolt thread interrupted during flush()");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reportError(Throwable error) {
        this.executor.getErrorReportingMetrics().incrReportedErrorCount();
        this.executor.getReportError().report(error);
    }

    private long tupleTimeDelta(TupleImpl tuple) {
        Long ms = tuple.getProcessSampleStartTime();
        if (ms != null) {
            return Time.deltaMs(ms);
        }
        return -1L;
    }

    private void putXor(Map<Long, Long> pending, Long key, Long id) {
        Long curr = pending.get(key);
        if (curr == null) {
            curr = 0L;
        }
        pending.put(key, Utils.bitXor(curr, id));
    }
}

