/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import org.apache.storm.daemon.metrics.BuiltinMetrics;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.stats.BoltExecutorStats;

public class BuiltinBoltMetrics
extends BuiltinMetrics {
    private final MultiCountStatAndMetric ackCount;
    private final MultiCountStatAndMetric failCount;
    private final MultiCountStatAndMetric emitCount;
    private final MultiCountStatAndMetric executeCount;
    private final MultiCountStatAndMetric transferCount;
    private final MultiLatencyStatAndMetric executeLatency;
    private final MultiLatencyStatAndMetric processLatency;

    public BuiltinBoltMetrics(BoltExecutorStats stats) {
        this.ackCount = stats.getAcked();
        this.failCount = stats.getFailed();
        this.emitCount = stats.getEmitted();
        this.executeCount = stats.getExecuted();
        this.transferCount = stats.getTransferred();
        this.executeLatency = stats.getExecuteLatencies();
        this.processLatency = stats.getProcessLatencies();
        this.metricMap.put("ack-count", this.ackCount);
        this.metricMap.put("fail-count", this.failCount);
        this.metricMap.put("emit-count", this.emitCount);
        this.metricMap.put("transfer-count", this.transferCount);
        this.metricMap.put("execute-count", this.executeCount);
        this.metricMap.put("process-latency", this.processLatency);
        this.metricMap.put("execute-latency", this.executeLatency);
    }

    public MultiCountStatAndMetric getAckCount() {
        return this.ackCount;
    }

    public MultiCountStatAndMetric getFailCount() {
        return this.failCount;
    }

    public MultiCountStatAndMetric getEmitCount() {
        return this.emitCount;
    }

    public MultiCountStatAndMetric getTransferCount() {
        return this.transferCount;
    }

    public MultiCountStatAndMetric getExecuteCount() {
        return this.executeCount;
    }

    public MultiLatencyStatAndMetric getExecuteLatency() {
        return this.executeLatency;
    }

    public MultiLatencyStatAndMetric getProcessLatency() {
        return this.processLatency;
    }
}

