/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.function.BooleanSupplier;
import org.apache.storm.Thrift;
import org.apache.storm.daemon.GrouperFactory;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.ExecutorTransfer;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.DebugOptions;
import org.apache.storm.generated.JavaObject;
import org.apache.storm.generated.ShellComponent;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.hooks.info.EmitInfo;
import org.apache.storm.metrics2.TaskMetrics;
import org.apache.storm.spout.ShellSpout;
import org.apache.storm.stats.CommonStats;
import org.apache.storm.task.ShellBolt;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private final TaskMetrics taskMetrics;
    private final Executor executor;
    private final WorkerState workerData;
    private final TopologyContext systemTopologyContext;
    private final TopologyContext userTopologyContext;
    private final WorkerTopologyContext workerTopologyContext;
    private final Integer taskId;
    private final String componentId;
    private final Object taskObject;
    private final Map<String, Object> topoConf;
    private final BooleanSupplier emitSampler;
    private final CommonStats executorStats;
    private final Map<String, Map<String, LoadAwareCustomStreamGrouping>> streamComponentToGrouper;
    private final HashMap<String, ArrayList<LoadAwareCustomStreamGrouping>> streamToGroupers;
    private final boolean debug;

    public Task(Executor executor, Integer taskId) throws IOException {
        this.taskId = taskId;
        this.executor = executor;
        this.workerData = executor.getWorkerData();
        this.topoConf = executor.getTopoConf();
        this.componentId = executor.getComponentId();
        this.streamComponentToGrouper = executor.getStreamToComponentToGrouper();
        this.streamToGroupers = Task.getGroupersPerStream(this.streamComponentToGrouper);
        this.executorStats = executor.getStats();
        this.workerTopologyContext = executor.getWorkerTopologyContext();
        this.emitSampler = ConfigUtils.mkStatsSampler(this.topoConf);
        this.systemTopologyContext = this.mkTopologyContext(this.workerData.getSystemTopology());
        this.userTopologyContext = this.mkTopologyContext(this.workerData.getTopology());
        this.taskObject = this.mkTaskObject();
        this.debug = this.topoConf.containsKey("topology.debug") && (Boolean)this.topoConf.get("topology.debug") != false;
        this.addTaskHooks();
        this.taskMetrics = new TaskMetrics(this.workerTopologyContext, this.componentId, this.taskId, this.workerData.getMetricRegistry());
    }

    private static HashMap<String, ArrayList<LoadAwareCustomStreamGrouping>> getGroupersPerStream(Map<String, Map<String, LoadAwareCustomStreamGrouping>> streamComponentToGrouper) {
        HashMap<String, ArrayList<LoadAwareCustomStreamGrouping>> result2 = new HashMap<String, ArrayList<LoadAwareCustomStreamGrouping>>(streamComponentToGrouper.size());
        for (Map.Entry<String, Map<String, LoadAwareCustomStreamGrouping>> entry : streamComponentToGrouper.entrySet()) {
            String stream = entry.getKey();
            Map<String, LoadAwareCustomStreamGrouping> groupers = entry.getValue();
            ArrayList<LoadAwareCustomStreamGrouping> perStreamGroupers = new ArrayList<LoadAwareCustomStreamGrouping>();
            if (groupers != null) {
                for (LoadAwareCustomStreamGrouping grouper : groupers.values()) {
                    perStreamGroupers.add(grouper);
                }
            }
            result2.put(stream, perStreamGroupers);
        }
        return result2;
    }

    public List<Integer> getOutgoingTasks(Integer outTaskId, String stream, List<Object> values) {
        if (this.debug) {
            LOG.info("Emitting direct: {}; {} {} {} ", new Object[]{outTaskId, this.componentId, stream, values});
        }
        String targetComponent = this.workerTopologyContext.getComponentId(outTaskId);
        Map<String, LoadAwareCustomStreamGrouping> componentGrouping = this.streamComponentToGrouper.get(stream);
        LoadAwareCustomStreamGrouping grouping = componentGrouping.get(targetComponent);
        if (null == grouping) {
            outTaskId = null;
        }
        if (grouping != null && grouping != GrouperFactory.DIRECT) {
            throw new IllegalArgumentException("Cannot emitDirect to a task expecting a regular grouping");
        }
        if (!this.userTopologyContext.getHooks().isEmpty()) {
            new EmitInfo(values, stream, this.taskId, Collections.singletonList(outTaskId)).applyOn(this.userTopologyContext);
        }
        try {
            if (this.emitSampler.getAsBoolean()) {
                this.executorStats.emittedTuple(stream, this.taskMetrics.getEmitted(stream));
                if (null != outTaskId) {
                    this.executorStats.transferredTuples(stream, 1, this.taskMetrics.getTransferred(stream));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (null != outTaskId) {
            return Collections.singletonList(outTaskId);
        }
        return new ArrayList<Integer>(0);
    }

    public List<Integer> getOutgoingTasks(String stream, List<Object> values) {
        if (this.debug) {
            LOG.info("Emitting Tuple: taskId={} componentId={} stream={} values={}", new Object[]{this.taskId, this.componentId, stream, values});
        }
        ArrayList<Integer> outTasks = new ArrayList<Integer>();
        ArrayList<LoadAwareCustomStreamGrouping> groupers = this.streamToGroupers.get(stream);
        if (null != groupers) {
            for (int i = 0; i < groupers.size(); ++i) {
                LoadAwareCustomStreamGrouping grouper = groupers.get(i);
                if (grouper == GrouperFactory.DIRECT) {
                    throw new IllegalArgumentException("Cannot do regular emit to direct stream");
                }
                List<Integer> compTasks = grouper.chooseTasks(this.taskId, values);
                outTasks.addAll(compTasks);
            }
        } else {
            throw new IllegalArgumentException("Unknown stream ID: " + stream);
        }
        if (!this.userTopologyContext.getHooks().isEmpty()) {
            new EmitInfo(values, stream, this.taskId, outTasks).applyOn(this.userTopologyContext);
        }
        try {
            if (this.emitSampler.getAsBoolean()) {
                this.executorStats.emittedTuple(stream, this.taskMetrics.getEmitted(stream));
                this.executorStats.transferredTuples(stream, outTasks.size(), this.taskMetrics.getTransferred(stream));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return outTasks;
    }

    public Tuple getTuple(String stream, List values) {
        return new TupleImpl(this.systemTopologyContext, values, this.executor.getComponentId(), this.systemTopologyContext.getThisTaskId(), stream);
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public TopologyContext getUserContext() {
        return this.userTopologyContext;
    }

    public Object getTaskObject() {
        return this.taskObject;
    }

    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    public void sendUnanchored(String stream, List<Object> values, ExecutorTransfer transfer, Queue<AddressedTuple> pendingEmits) {
        Tuple tuple = this.getTuple(stream, values);
        List<Integer> tasks = this.getOutgoingTasks(stream, values);
        for (int i = 0; i < tasks.size(); ++i) {
            AddressedTuple addressedTuple = new AddressedTuple(tasks.get(i), tuple);
            transfer.tryTransfer(addressedTuple, pendingEmits);
        }
    }

    public void sendToEventLogger(Executor executor, List values, String componentId, Object messageId, Random random, Queue<AddressedTuple> overflow) {
        double spct;
        Map<String, DebugOptions> componentDebug = executor.getStormComponentDebug().get();
        DebugOptions debugOptions = componentDebug.get(componentId);
        if (debugOptions == null) {
            debugOptions = componentDebug.get(executor.getStormId());
        }
        double d = spct = debugOptions != null && debugOptions.is_enable() ? debugOptions.get_samplingpct() : 0.0;
        if (spct > 0.0 && random.nextDouble() * 100.0 < spct) {
            this.sendUnanchored("__eventlog", new Values(componentId, messageId, System.currentTimeMillis(), values), executor.getExecutorTransfer(), overflow);
        }
    }

    private TopologyContext mkTopologyContext(StormTopology topology) throws IOException {
        Map<String, Object> conf = this.workerData.getConf();
        return new TopologyContext(topology, this.workerData.getTopologyConf(), this.workerData.getTaskToComponent(), this.workerData.getComponentToSortedTasks(), this.workerData.getComponentToStreamToFields(), this.workerData.getBlobToLastKnownVersion(), this.workerData.getTopologyId(), ConfigUtils.supervisorStormResourcesPath(ConfigUtils.supervisorStormDistRoot(conf, this.workerData.getTopologyId())), ConfigUtils.workerPidsRoot(conf, this.workerData.getWorkerId()), this.taskId, this.workerData.getPort(), this.workerData.getLocalTaskIds(), this.workerData.getDefaultSharedResources(), this.workerData.getUserSharedResources(), this.executor.getSharedExecutorData(), this.executor.getIntervalToTaskToMetricToRegistry(), this.executor.getOpenOrPrepareWasCalled(), this.workerData.getMetricRegistry());
    }

    private Object mkTaskObject() {
        ComponentObject componentObject;
        StormTopology topology = this.systemTopologyContext.getRawTopology();
        Map<String, SpoutSpec> spouts = topology.get_spouts();
        Map<String, Bolt> bolts = topology.get_bolts();
        Map<String, StateSpoutSpec> stateSpouts = topology.get_state_spouts();
        if (spouts.containsKey(this.componentId)) {
            componentObject = spouts.get(this.componentId).get_spout_object();
        } else if (bolts.containsKey(this.componentId)) {
            componentObject = bolts.get(this.componentId).get_bolt_object();
        } else if (stateSpouts.containsKey(this.componentId)) {
            componentObject = stateSpouts.get(this.componentId).get_state_spout_object();
        } else {
            throw new RuntimeException("Could not find " + this.componentId + " in " + topology);
        }
        Object result2 = Utils.getSetComponentObject(componentObject);
        if (result2 instanceof ShellComponent) {
            result2 = spouts.containsKey(this.componentId) ? new ShellSpout((ShellComponent)result2) : new ShellBolt((ShellComponent)result2);
        }
        if (result2 instanceof JavaObject) {
            result2 = Thrift.instantiateJavaObject((JavaObject)result2);
        }
        return result2;
    }

    private void addTaskHooks() {
        List hooksClassList = (List)this.topoConf.get("topology.auto.task.hooks");
        if (null != hooksClassList) {
            for (String hookClass : hooksClassList) {
                try {
                    this.userTopologyContext.addTaskHook((ITaskHook)Class.forName(hookClass).newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Failed to add hook: " + hookClass, e);
                }
            }
        }
    }

    public String toString() {
        return this.taskId.toString();
    }
}

