/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jctools.queues;

import org.apache.storm.shade.org.jctools.queues.BaseLinkedQueue;
import org.apache.storm.shade.org.jctools.queues.LinkedQueueNode;
import org.apache.storm.shade.org.jctools.queues.MessagePassingQueue;
import org.apache.storm.shade.org.jctools.queues.MpscLinkedQueue7;
import org.apache.storm.shade.org.jctools.queues.MpscLinkedQueue8;
import org.apache.storm.shade.org.jctools.util.UnsafeAccess;

public abstract class MpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public static <E> MpscLinkedQueue<E> newMpscLinkedQueue() {
        if (UnsafeAccess.SUPPORTS_GET_AND_SET) {
            return new MpscLinkedQueue8();
        }
        return new MpscLinkedQueue7();
    }

    protected MpscLinkedQueue() {
        this.consumerNode = new LinkedQueueNode();
        this.xchgProducerNode(this.consumerNode);
    }

    protected abstract LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> var1);

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(e);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueNode currConsumerNode = this.consumerNode;
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        LinkedQueueNode<E> tail;
        if (limit == 0) {
            return 0;
        }
        LinkedQueueNode<E> head = tail = new LinkedQueueNode<E>(s.get());
        for (int i = 1; i < limit; ++i) {
            LinkedQueueNode<E> temp = new LinkedQueueNode<E>(s.get());
            tail.soNext(temp);
            tail = temp;
        }
        LinkedQueueNode<E> oldPNode = this.xchgProducerNode(tail);
        oldPNode.soNext(head);
        return limit;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            this.fill(s, 4096);
        }
    }
}

