/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Executor;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBufferFactory;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelException;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.SocketReceiveBufferAllocator;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.SocketSendBufferPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioDatagramWorker
extends AbstractNioWorker {
    private final SocketReceiveBufferAllocator bufferAllocator = new SocketReceiveBufferAllocator();

    NioDatagramWorker(Executor executor) {
        super(executor);
    }

    @Override
    protected boolean read(SelectionKey key) {
        NioDatagramChannel channel = (NioDatagramChannel)key.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        DatagramChannel nioChannel = (DatagramChannel)key.channel();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        ByteBuffer byteBuffer = this.bufferAllocator.get(predictedRecvBufSize).order(bufferFactory.getDefaultOrder());
        boolean failure = true;
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = nioChannel.receive(byteBuffer);
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (remoteAddress != null) {
            byteBuffer.flip();
            int readBytes = byteBuffer.remaining();
            if (readBytes > 0) {
                predictor.previousReceiveBufferSize(readBytes);
                ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
                buffer.setBytes(0, byteBuffer);
                buffer.writerIndex(readBytes);
                predictor.previousReceiveBufferSize(readBytes);
                Channels.fireMessageReceived(channel, (Object)buffer, remoteAddress);
            }
        }
        if (failure) {
            key.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    @Override
    protected boolean scheduleWriteIfNecessary(AbstractNioChannel<?> channel) {
        Thread workerThread = this.thread;
        if (workerThread == null || Thread.currentThread() != workerThread) {
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                this.registerTask(channel.writeTask);
            }
            return true;
        }
        return false;
    }

    static void disconnect(NioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean iothread = NioDatagramWorker.isIoThread(channel);
        try {
            channel.getDatagramChannel().disconnect();
            future.setSuccess();
            if (connected) {
                if (iothread) {
                    Channels.fireChannelDisconnected(channel);
                } else {
                    Channels.fireChannelDisconnectedLater(channel);
                }
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    @Override
    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        return new ChannelRegistionTask((NioDatagramChannel)channel, future);
    }

    @Override
    public void writeFromUserCode(AbstractNioChannel<?> channel) {
        if (!channel.isBound()) {
            NioDatagramWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write0(AbstractNioChannel<?> channel) {
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        DatagramChannel ch = ((NioDatagramChannel)channel).getDatagramChannel();
        AbstractNioChannel.WriteRequestQueue writeBuffer = channel.writeBufferQueue;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                SocketSendBufferPool.SendBuffer buf;
                MessageEvent evt;
                if ((evt = channel.currentWriteEvent) == null) {
                    channel.currentWriteEvent = evt = writeBuffer.poll();
                    if (evt == null) {
                        removeOpWrite = true;
                        channel.writeSuspended = false;
                        break;
                    }
                    channel.currentWriteBuffer = buf = sendBufferPool.acquire(evt.getMessage());
                } else {
                    buf = channel.currentWriteBuffer;
                }
                try {
                    int i;
                    long localWrittenBytes = 0L;
                    SocketAddress raddr = evt.getRemoteAddress();
                    if (raddr == null) {
                        for (i = writeSpinCount; i > 0; --i) {
                            localWrittenBytes = buf.transferTo(ch);
                            if (localWrittenBytes != 0L) {
                                writtenBytes += localWrittenBytes;
                            } else if (!buf.finished()) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (i = writeSpinCount; i > 0; --i) {
                            localWrittenBytes = buf.transferTo(ch, raddr);
                            if (localWrittenBytes != 0L) {
                                writtenBytes += localWrittenBytes;
                            } else if (!buf.finished()) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (localWrittenBytes > 0L || buf.finished()) {
                        buf.release();
                        ChannelFuture future = evt.getFuture();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    buf.release();
                    ChannelFuture future = evt.getFuture();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(t);
                    Channels.fireExceptionCaught(channel, t);
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (addOpWrite) {
                this.setOpWrite(channel);
            } else if (removeOpWrite) {
                this.clearOpWrite(channel);
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
    }

    @Override
    public void run() {
        super.run();
        this.bufferAllocator.releaseExternalResources();
    }

    private final class ChannelRegistionTask
    implements Runnable {
        private final NioDatagramChannel channel;
        private final ChannelFuture future;

        ChannelRegistionTask(NioDatagramChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        public void run() {
            block6: {
                InetSocketAddress localAddress = this.channel.getLocalAddress();
                if (localAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    this.channel.getDatagramChannel().register(NioDatagramWorker.this.selector, this.channel.getInternalInterestOps(), this.channel);
                    if (this.future != null) {
                        this.future.setSuccess();
                    }
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block6;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
        }
    }
}

