/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.util.Util;

public class ChainedRelMetadataProvider
implements RelMetadataProvider {
    private final ImmutableList<RelMetadataProvider> providers;

    protected ChainedRelMetadataProvider(ImmutableList<RelMetadataProvider> providers) {
        this.providers = providers;
        assert (!providers.contains((Object)this));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ChainedRelMetadataProvider && this.providers.equals(((ChainedRelMetadataProvider)obj).providers);
    }

    public int hashCode() {
        return this.providers.hashCode();
    }

    @Override
    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass, final Class<? extends M> metadataClass) {
        final ArrayList<UnboundMetadata<? extends M>> functions = new ArrayList<UnboundMetadata<? extends M>>();
        for (RelMetadataProvider provider : this.providers) {
            UnboundMetadata<? extends M> function = provider.apply(relClass, metadataClass);
            if (function == null) continue;
            functions.add(function);
        }
        switch (functions.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (UnboundMetadata)functions.get(0);
            }
        }
        return new UnboundMetadata<M>(){

            @Override
            public M bind(RelNode rel, RelMetadataQuery mq) {
                ArrayList metadataList = Lists.newArrayList();
                for (UnboundMetadata function : functions) {
                    Object metadata = function.bind(rel, mq);
                    if (metadata == null) continue;
                    metadataList.add(metadata);
                }
                return (Metadata)metadataClass.cast(Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new ChainedInvocationHandler(metadataList)));
            }
        };
    }

    @Override
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (RelMetadataProvider provider : this.providers.reverse()) {
            builder.putAll(provider.handlers(def));
        }
        return builder.build();
    }

    public static RelMetadataProvider of(List<RelMetadataProvider> list) {
        return new ChainedRelMetadataProvider((ImmutableList<RelMetadataProvider>)ImmutableList.copyOf(list));
    }

    private static class ChainedInvocationHandler
    implements InvocationHandler {
        private final List<Metadata> metadataList;

        ChainedInvocationHandler(List<Metadata> metadataList) {
            this.metadataList = ImmutableList.copyOf(metadataList);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Metadata metadata : this.metadataList) {
                try {
                    Object o = method.invoke((Object)metadata, args);
                    if (o == null) continue;
                    return o;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof CyclicMetadataException) continue;
                    Util.throwIfUnchecked(e.getCause());
                    throw new RuntimeException(e.getCause());
                }
            }
            return null;
        }
    }
}

