/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.GenericResourceAwareStrategy;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintSolverStrategy
extends BaseResourceAwareStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintSolverStrategy.class);
    public static final String CONSTRAINT_TYPE_MAX_NODE_CO_LOCATION_CNT = "maxNodeCoLocationCnt";
    public static final String CONSTRAINT_TYPE_INCOMPATIBLE_COMPONENTS = "incompatibleComponents";
    private Map<String, RasNode> nodes;
    private Map<ExecutorDetails, String> execToComp;
    private Map<String, Set<ExecutorDetails>> compToExecs;
    private List<String> favoredNodeIds;
    private List<String> unFavoredNodeIds;
    private ConstraintConfig constraintConfig;

    @VisibleForTesting
    public static boolean validateSolution(Cluster cluster, TopologyDetails td, ConstraintConfig constraintConfig) {
        if (constraintConfig == null) {
            constraintConfig = new ConstraintConfig(td);
        }
        return ConstraintSolverStrategy.checkSpreadSchedulingValid(cluster, td, constraintConfig) && ConstraintSolverStrategy.checkConstraintsSatisfied(cluster, td, constraintConfig) && ConstraintSolverStrategy.checkResourcesCorrect(cluster, td);
    }

    private static boolean checkConstraintsSatisfied(Cluster cluster, TopologyDetails topo, ConstraintConfig constraintConfig) {
        LOG.info("Checking constraints...");
        assert (cluster.getAssignmentById(topo.getId()) != null);
        if (constraintConfig == null) {
            constraintConfig = new ConstraintConfig(topo);
        }
        Map<ExecutorDetails, WorkerSlot> result = cluster.getAssignmentById(topo.getId()).getExecutorToSlot();
        Map<ExecutorDetails, String> execToComp = topo.getExecutorToComponent();
        Map constraintMatrix = constraintConfig.incompatibleComponents;
        HashMap workerCompMap = new HashMap();
        result.forEach((exec, worker) -> {
            String comp = (String)execToComp.get(exec);
            workerCompMap.computeIfAbsent(worker, k -> new HashSet()).add(comp);
        });
        for (Map.Entry entry : workerCompMap.entrySet()) {
            Set comps = (Set)entry.getValue();
            for (String comp1 : comps) {
                for (String comp2 : comps) {
                    if (comp1.equals(comp2) || !((Set)constraintMatrix.get(comp1)).contains(comp2)) continue;
                    LOG.error("Incorrect Scheduling: worker exclusion for Component {} and {} not satisfied on WorkerSlot: {}", new Object[]{comp1, comp2, entry.getKey()});
                    return false;
                }
            }
        }
        return true;
    }

    private static Map<WorkerSlot, RasNode> workerToNodes(Cluster cluster) {
        HashMap<WorkerSlot, RasNode> workerToNodes = new HashMap<WorkerSlot, RasNode>();
        for (RasNode node : RasNodes.getAllNodesFrom(cluster).values()) {
            for (WorkerSlot s : node.getUsedSlots()) {
                workerToNodes.put(s, node);
            }
        }
        return workerToNodes;
    }

    private static boolean checkSpreadSchedulingValid(Cluster cluster, TopologyDetails topo, ConstraintConfig constraintConfig) {
        LOG.info("Checking for a valid scheduling...");
        assert (cluster.getAssignmentById(topo.getId()) != null);
        if (constraintConfig == null) {
            constraintConfig = new ConstraintConfig(topo);
        }
        Map<ExecutorDetails, String> execToComp = topo.getExecutorToComponent();
        HashMap<String, Map> nodeCompMap = new HashMap<String, Map>();
        Map<WorkerSlot, RasNode> workerToNodes = ConstraintSolverStrategy.workerToNodes(cluster);
        boolean ret = true;
        Map spreadCompCnts = constraintConfig.maxCoLocationCnts;
        for (Map.Entry<ExecutorDetails, WorkerSlot> entry : cluster.getAssignmentById(topo.getId()).getExecutorToSlot().entrySet()) {
            ExecutorDetails exec = entry.getKey();
            String comp = execToComp.get(exec);
            WorkerSlot worker = entry.getValue();
            RasNode node = workerToNodes.get(worker);
            String nodeId = node.getId();
            if (!spreadCompCnts.containsKey(comp)) continue;
            int allowedColocationMaxCnt = (Integer)spreadCompCnts.get(comp);
            Map oneNodeCompMap = nodeCompMap.computeIfAbsent(nodeId, k -> new HashMap());
            oneNodeCompMap.put(comp, oneNodeCompMap.getOrDefault(comp, 0) + 1);
            if (allowedColocationMaxCnt >= (Integer)oneNodeCompMap.get(comp)) continue;
            LOG.error("Incorrect Scheduling: MaxCoLocationCnt for Component: {} {} on node {} not satisfied, cnt {} > allowed {}", new Object[]{comp, exec, nodeId, oneNodeCompMap.get(comp), allowedColocationMaxCnt});
            ret = false;
        }
        if (!ret) {
            LOG.error("Incorrect MaxCoLocationCnts: Node-Component-Cnt {}", nodeCompMap);
        }
        return ret;
    }

    private static boolean checkResourcesCorrect(Cluster cluster, TopologyDetails topo) {
        LOG.info("Checking Resources...");
        assert (cluster.getAssignmentById(topo.getId()) != null);
        Map<ExecutorDetails, WorkerSlot> result = cluster.getAssignmentById(topo.getId()).getExecutorToSlot();
        HashMap<RasNode, Collection> nodeToExecs = new HashMap<RasNode, Collection>();
        HashMap<ExecutorDetails, WorkerSlot> mergedExecToWorker = new HashMap<ExecutorDetails, WorkerSlot>();
        Map<String, RasNode> nodes = RasNodes.getAllNodesFrom(cluster);
        if (cluster.getAssignmentById(topo.getId()) != null && cluster.getAssignmentById(topo.getId()).getExecutorToSlot() != null) {
            mergedExecToWorker.putAll(cluster.getAssignmentById(topo.getId()).getExecutorToSlot());
        }
        mergedExecToWorker.putAll(result);
        for (Map.Entry entry : mergedExecToWorker.entrySet()) {
            ExecutorDetails exec = (ExecutorDetails)entry.getKey();
            WorkerSlot worker = (WorkerSlot)entry.getValue();
            RasNode node = nodes.get(worker.getNodeId());
            if (node.getAvailableMemoryResources() < 0.0 && node.getAvailableCpuResources() < 0.0) {
                LOG.error("Incorrect Scheduling: found node with negative available resources");
                return false;
            }
            nodeToExecs.computeIfAbsent(node, k -> new HashSet()).add(exec);
        }
        for (Map.Entry entry : nodeToExecs.entrySet()) {
            RasNode node = (RasNode)entry.getKey();
            Collection execs = (Collection)entry.getValue();
            double cpuUsed = 0.0;
            double memoryUsed = 0.0;
            for (ExecutorDetails exec : execs) {
                cpuUsed += topo.getTotalCpuReqTask(exec).doubleValue();
                memoryUsed += topo.getTotalMemReqTask(exec).doubleValue();
            }
            if (node.getAvailableCpuResources() != node.getTotalCpuResources() - cpuUsed) {
                LOG.error("Incorrect Scheduling: node {} has consumed incorrect amount of cpu. Expected: {} Actual: {} Executors scheduled on node: {}", new Object[]{node.getId(), node.getTotalCpuResources() - cpuUsed, node.getAvailableCpuResources(), execs});
                return false;
            }
            if (node.getAvailableMemoryResources() == node.getTotalMemoryResources() - memoryUsed) continue;
            LOG.error("Incorrect Scheduling: node {} has consumed incorrect amount of memory. Expected: {} Actual: {} Executors scheduled on node: {}", new Object[]{node.getId(), node.getTotalMemoryResources() - memoryUsed, node.getAvailableMemoryResources(), execs});
            return false;
        }
        return true;
    }

    @Override
    public SchedulingResult schedule(Cluster cluster, TopologyDetails td) {
        this.prepare(cluster);
        LOG.debug("Scheduling {}", (Object)td.getId());
        this.nodes = RasNodes.getAllNodesFrom(cluster);
        HashMap workerCompAssignment = new HashMap();
        HashMap nodeCompAssignment = new HashMap();
        int confMaxStateSearch = ObjectReader.getInt((Object)td.getConf().get("topology.ras.constraint.max.state.search"));
        int daemonMaxStateSearch = ObjectReader.getInt((Object)cluster.getConf().get("resource.aware.scheduler.constraint.max.state.search"));
        int maxStateSearch = Math.min(daemonMaxStateSearch, confMaxStateSearch);
        int daemonMaxTimeSec = ObjectReader.getInt((Object)td.getConf().get("scheduling.timeout.seconds.per.topology"), (Integer)60);
        int confMaxTimeSec = ObjectReader.getInt((Object)td.getConf().get("topology.ras.constraint.max.time.secs"), (Integer)daemonMaxTimeSec);
        long maxTimeMs = confMaxTimeSec >= daemonMaxTimeSec ? (long)daemonMaxTimeSec * 1000L - 200L : (long)confMaxTimeSec * 1000L;
        this.favoredNodeIds = this.makeHostToNodeIds((List)td.getConf().get("topology.scheduler.favored.nodes"));
        this.unFavoredNodeIds = this.makeHostToNodeIds((List)td.getConf().get("topology.scheduler.unfavored.nodes"));
        this.execToComp = td.getExecutorToComponent();
        this.compToExecs = this.getCompToExecs(this.execToComp);
        this.constraintConfig = new ConstraintConfig(td);
        HashSet<ExecutorDetails> unassignedExecutors = new HashSet<ExecutorDetails>(cluster.getUnassignedExecutors(td));
        List sortedExecs = this.getSortedExecs(this.constraintConfig.maxCoLocationCnts, this.constraintConfig.incompatibleComponents, this.compToExecs).stream().filter(unassignedExecutors::contains).collect(Collectors.toList());
        SchedulerAssignment existingAssignment = cluster.getAssignmentById(td.getId());
        if (existingAssignment != null) {
            existingAssignment.getExecutorToSlot().forEach((exec, ws) -> {
                String compId = this.execToComp.get(exec);
                RasNode node = this.nodes.get(ws.getNodeId());
                Map oneMap = nodeCompAssignment.computeIfAbsent(node, k -> new HashMap());
                oneMap.put(compId, oneMap.getOrDefault(compId, 0) + 1);
                oneMap = workerCompAssignment.computeIfAbsent(ws, k -> new HashMap());
                oneMap.put(compId, oneMap.getOrDefault(compId, 0) + 1);
            });
        }
        if (!this.checkSchedulingFeasibility(maxStateSearch)) {
            return SchedulingResult.failure(SchedulingStatus.FAIL_OTHER, "Scheduling not feasible!");
        }
        return this.backtrackSearch(new SearcherState(workerCompAssignment, nodeCompAssignment, maxStateSearch, maxTimeMs, sortedExecs, td)).asSchedulingResult();
    }

    private boolean checkSchedulingFeasibility(int maxStateSearch) {
        for (Map.Entry entry : this.constraintConfig.maxCoLocationCnts.entrySet()) {
            String comp = (String)entry.getKey();
            int maxCoLocationCnt = (Integer)entry.getValue();
            int numExecs = this.compToExecs.get(comp).size();
            if (numExecs <= this.nodes.size() * maxCoLocationCnt) continue;
            LOG.error("Unsatisfiable constraint: Component: {} marked as spread has {} executors which is larger than number of nodes * maxCoLocationCnt: {} * {} ", new Object[]{comp, numExecs, this.nodes.size(), maxCoLocationCnt});
            return false;
        }
        if (this.execToComp.size() >= maxStateSearch) {
            LOG.error("Number of executors is greater than the maximum number of states allowed to be searched.  # of executors: {} Max states to search: {}", (Object)this.execToComp.size(), (Object)maxStateSearch);
            return false;
        }
        return true;
    }

    @Override
    protected TreeSet<BaseResourceAwareStrategy.ObjectResources> sortObjectResources(BaseResourceAwareStrategy.AllResources allResources, ExecutorDetails exec, TopologyDetails topologyDetails, BaseResourceAwareStrategy.ExistingScheduleFunc existingScheduleFunc) {
        return GenericResourceAwareStrategy.sortObjectResourcesImpl(allResources, exec, topologyDetails, existingScheduleFunc);
    }

    @VisibleForTesting
    protected SolverResult backtrackSearch(SearcherState state) {
        long startTimeMilli = System.currentTimeMillis();
        int maxExecCnt = state.getExecSize();
        int[] progressIdxForExec = new int[maxExecCnt];
        RasNode[] nodeForExec = new RasNode[maxExecCnt];
        WorkerSlot[] workerSlotForExec = new WorkerSlot[maxExecCnt];
        for (int i = 0; i < maxExecCnt; ++i) {
            progressIdxForExec[i] = -1;
        }
        LOG.info("backtrackSearch: will assign {} executors", (Object)maxExecCnt);
        int loopCnt = 0;
        while (true) {
            block7: {
                LOG.debug("backtrackSearch: loopCnt = {}, state.execIndex = {}", (Object)loopCnt, (Object)state.execIndex);
                if (state.areSearchLimitsExceeded()) {
                    LOG.warn("backtrackSearch: Search limits exceeded, backtracked {} times, looped {} times", (Object)state.numBacktrack, (Object)loopCnt);
                    return new SolverResult(state, false);
                }
                if (Thread.currentThread().isInterrupted()) {
                    return new SolverResult(state, false);
                }
                int execIndex = state.execIndex;
                ExecutorDetails exec = state.currentExec();
                String comp = this.execToComp.get(exec);
                Iterable<String> sortedNodesIter = this.sortAllNodes(state.td, exec, this.favoredNodeIds, this.unFavoredNodeIds);
                int progressIdx = -1;
                for (String nodeId : sortedNodesIter) {
                    RasNode node = this.nodes.get(nodeId);
                    for (WorkerSlot workerSlot : node.getSlotsAvailableToScheduleOn()) {
                        if (++progressIdx <= progressIdxForExec[execIndex]) continue;
                        int n = execIndex;
                        progressIdxForExec[n] = progressIdxForExec[n] + 1;
                        LOG.debug("backtrackSearch: loopCnt = {}, state.execIndex = {}, comp = {}, node/slot-ordinal = {}, nodeId = {}", new Object[]{loopCnt, execIndex, comp, progressIdx, nodeId});
                        if (!this.isExecAssignmentToWorkerValid(workerSlot, state)) continue;
                        state.incStatesSearched();
                        state.tryToSchedule(this.execToComp, node, workerSlot);
                        if (state.areAllExecsScheduled()) {
                            LOG.info("backtrackSearch: AllExecsScheduled at loopCnt={} in {} ms, elapsedtime in state={}, backtrackCnt={}", new Object[]{loopCnt, System.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - state.startTimeMillis, state.numBacktrack});
                            return new SolverResult(state, true);
                        }
                        state = state.nextExecutor();
                        nodeForExec[execIndex] = node;
                        workerSlotForExec[execIndex] = workerSlot;
                        LOG.debug("backtrackSearch: Assigned execId={}, comp={} to node={}, node/slot-ordinal={} at loopCnt={}", new Object[]{execIndex, comp, nodeId, progressIdx, loopCnt});
                        break block7;
                    }
                }
                LOG.debug("backtrackSearch: Failed to schedule execId={}, comp={} at loopCnt={}", new Object[]{execIndex, comp, loopCnt});
                if (execIndex == 0) break;
                state.backtrack(this.execToComp, nodeForExec[execIndex - 1], workerSlotForExec[execIndex - 1]);
                progressIdxForExec[execIndex] = -1;
            }
            ++loopCnt;
        }
        boolean success = state.areAllExecsScheduled();
        LOG.info("backtrackSearch: Scheduled={} in {} milliseconds, elapsedtime in state={}, backtrackCnt={}", new Object[]{success, System.currentTimeMillis() - startTimeMilli, Time.currentTimeMillis() - state.startTimeMillis, state.numBacktrack});
        return new SolverResult(state, success);
    }

    public boolean isExecAssignmentToWorkerValid(WorkerSlot worker, SearcherState state) {
        ExecutorDetails exec = state.currentExec();
        RasNode node = this.nodes.get(worker.getNodeId());
        if (!node.wouldFit(worker, exec, state.td)) {
            LOG.trace("{} would not fit in resources available on {}", (Object)exec, (Object)worker);
            return false;
        }
        String execComp = this.execToComp.get(exec);
        Map compAssignmentCnts = (Map)state.workerCompAssignmentCnts.get(worker);
        if (compAssignmentCnts != null && this.constraintConfig.incompatibleComponents.containsKey(execComp)) {
            Set subMatrix = (Set)this.constraintConfig.incompatibleComponents.get(execComp);
            for (String comp : compAssignmentCnts.keySet()) {
                if (!subMatrix.contains(comp)) continue;
                LOG.trace("{} found {} constraint violation {} on {}", new Object[]{exec, execComp, comp, worker});
                return false;
            }
        }
        if (this.constraintConfig.maxCoLocationCnts.containsKey(execComp)) {
            int coLocationMaxCnt = (Integer)this.constraintConfig.maxCoLocationCnts.get(execComp);
            if (state.nodeCompAssignmentCnts.containsKey(node) && ((Map)state.nodeCompAssignmentCnts.get(node)).getOrDefault(execComp, 0) >= coLocationMaxCnt) {
                LOG.trace("{} Found MaxCoLocationCnt violation {} on node {}, count {} >= colocation count {}", new Object[]{exec, execComp, node.getId(), ((Map)state.nodeCompAssignmentCnts.get(node)).get(execComp), coLocationMaxCnt});
                return false;
            }
        }
        return true;
    }

    private Map<String, Set<ExecutorDetails>> getCompToExecs(Map<ExecutorDetails, String> executorToComp) {
        HashMap<String, Set<ExecutorDetails>> retMap = new HashMap<String, Set<ExecutorDetails>>();
        executorToComp.forEach((exec, comp) -> retMap.computeIfAbsent((String)comp, k -> new HashSet()).add(exec));
        return retMap;
    }

    private ArrayList<ExecutorDetails> getSortedExecs(Map<String, Integer> spreadCompCnts, Map<String, Set<String>> constraintMatrix, Map<String, Set<ExecutorDetails>> compToExecs) {
        ArrayList<ExecutorDetails> retList = new ArrayList<ExecutorDetails>();
        HashMap compConstraintCountMap = new HashMap();
        constraintMatrix.forEach((comp, subMatrix) -> {
            double count = subMatrix.size();
            if (spreadCompCnts.containsKey(comp)) {
                count += (double)(compToExecs.size() / (Integer)spreadCompCnts.get(comp));
            }
            compConstraintCountMap.put(comp, count);
        });
        NavigableMap sortedCompConstraintCountMap = this.sortByValues(compConstraintCountMap);
        for (String comp2 : sortedCompConstraintCountMap.keySet()) {
            retList.addAll((Collection<ExecutorDetails>)compToExecs.get(comp2));
        }
        return retList;
    }

    @VisibleForTesting
    public <K extends Comparable<K>, V extends Comparable<V>> NavigableMap<K, V> sortByValues(Map<K, V> map) {
        Comparator valueComparator = (k1, k2) -> {
            int compare = ((Comparable)map.get(k2)).compareTo(map.get(k1));
            if (compare == 0) {
                return k2.compareTo(k1);
            }
            return compare;
        };
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    protected static final class SearcherState {
        final long startTimeMillis;
        private final long maxEndTimeMs;
        private final Map<WorkerSlot, Map<String, Integer>> workerCompAssignmentCnts;
        private final boolean[] okToRemoveFromWorker;
        private final Map<RasNode, Map<String, Integer>> nodeCompAssignmentCnts;
        private final boolean[] okToRemoveFromNode;
        private final List<ExecutorDetails> execs;
        private final int maxStatesSearched;
        private final TopologyDetails td;
        private int statesSearched = 0;
        private int numBacktrack = 0;
        private int execIndex = 0;

        private SearcherState(Map<WorkerSlot, Map<String, Integer>> workerCompAssignmentCnts, Map<RasNode, Map<String, Integer>> nodeCompAssignmentCnts, int maxStatesSearched, long maxTimeMs, List<ExecutorDetails> execs, TopologyDetails td) {
            assert (!execs.isEmpty());
            assert (execs != null);
            this.workerCompAssignmentCnts = workerCompAssignmentCnts;
            this.nodeCompAssignmentCnts = nodeCompAssignmentCnts;
            this.maxStatesSearched = maxStatesSearched;
            this.execs = execs;
            this.okToRemoveFromWorker = new boolean[execs.size()];
            this.okToRemoveFromNode = new boolean[execs.size()];
            this.td = td;
            this.startTimeMillis = Time.currentTimeMillis();
            this.maxEndTimeMs = maxTimeMs <= 0L ? Long.MAX_VALUE : this.startTimeMillis + maxTimeMs;
        }

        public void incStatesSearched() {
            ++this.statesSearched;
            if (LOG.isDebugEnabled() && this.statesSearched % 1000 == 0) {
                LOG.debug("States Searched: {}", (Object)this.statesSearched);
                LOG.debug("backtrack: {}", (Object)this.numBacktrack);
            }
        }

        public int getStatesSearched() {
            return this.statesSearched;
        }

        public int getExecSize() {
            return this.execs.size();
        }

        public boolean areSearchLimitsExceeded() {
            return this.statesSearched > this.maxStatesSearched || Time.currentTimeMillis() > this.maxEndTimeMs;
        }

        public SearcherState nextExecutor() {
            ++this.execIndex;
            if (this.execIndex >= this.execs.size()) {
                throw new IllegalStateException("Internal Error: exceeded the exec limit " + this.execIndex + " >= " + this.execs.size());
            }
            return this;
        }

        public boolean areAllExecsScheduled() {
            return this.execIndex == this.execs.size() - 1;
        }

        public ExecutorDetails currentExec() {
            return this.execs.get(this.execIndex);
        }

        public void tryToSchedule(Map<ExecutorDetails, String> execToComp, RasNode node, WorkerSlot workerSlot) {
            ExecutorDetails exec = this.currentExec();
            String comp = execToComp.get(exec);
            LOG.trace("Trying assignment of {} {} to {}", new Object[]{exec, comp, workerSlot});
            Map oneMap = this.workerCompAssignmentCnts.computeIfAbsent(workerSlot, k -> new HashMap());
            oneMap.put(comp, oneMap.getOrDefault(comp, 0) + 1);
            this.okToRemoveFromWorker[this.execIndex] = true;
            oneMap = this.nodeCompAssignmentCnts.computeIfAbsent(node, k -> new HashMap());
            oneMap.put(comp, oneMap.getOrDefault(comp, 0) + 1);
            this.okToRemoveFromNode[this.execIndex] = true;
            node.assignSingleExecutor(workerSlot, exec, this.td);
        }

        public void backtrack(Map<ExecutorDetails, String> execToComp, RasNode node, WorkerSlot workerSlot) {
            Map<String, Integer> oneMap;
            --this.execIndex;
            if (this.execIndex < 0) {
                throw new IllegalStateException("Internal Error: exec index became negative");
            }
            ++this.numBacktrack;
            ExecutorDetails exec = this.currentExec();
            String comp = execToComp.get(exec);
            LOG.trace("Backtracking {} {} from {}", new Object[]{exec, comp, workerSlot});
            if (this.okToRemoveFromWorker[this.execIndex]) {
                oneMap = this.workerCompAssignmentCnts.get(workerSlot);
                oneMap.put(comp, oneMap.getOrDefault(comp, 0) - 1);
                this.okToRemoveFromWorker[this.execIndex] = false;
            }
            if (this.okToRemoveFromNode[this.execIndex]) {
                oneMap = this.nodeCompAssignmentCnts.get(node);
                oneMap.put(comp, oneMap.getOrDefault(comp, 0) - 1);
                this.okToRemoveFromNode[this.execIndex] = false;
            }
            node.freeSingleExecutor(exec, this.td);
        }

        public void logNodeCompAssignments() {
            if (this.nodeCompAssignmentCnts == null || this.nodeCompAssignmentCnts.isEmpty()) {
                LOG.info("NodeCompAssignment is empty");
                return;
            }
            StringBuffer sb = new StringBuffer();
            int cntAllNodes = 0;
            int cntFilledNodes = 0;
            for (RasNode node : new TreeSet<RasNode>(this.nodeCompAssignmentCnts.keySet())) {
                ++cntAllNodes;
                Map<String, Integer> oneMap = this.nodeCompAssignmentCnts.get(node);
                if (oneMap.isEmpty()) continue;
                String oneMapJoined = String.join((CharSequence)",", oneMap.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.toList()));
                sb.append(String.format("\n\t(%d) Node %s: %s", ++cntFilledNodes, node.getId(), oneMapJoined));
            }
            LOG.info("NodeCompAssignments available for {} of {} nodes {}", new Object[]{cntFilledNodes, cntAllNodes, sb});
            LOG.info("Executors assignments attempted (cnt={}) are: \n\t{}", (Object)this.execs.size(), (Object)this.execs.stream().map(x -> x.toString()).collect(Collectors.joining(",")));
        }
    }

    protected static final class SolverResult {
        private final SearcherState state;
        private final int statesSearched;
        private final boolean success;
        private final long timeTakenMillis;
        private final int backtracked;

        public SolverResult(SearcherState state, boolean success) {
            this.state = state;
            this.statesSearched = state.getStatesSearched();
            this.success = success;
            this.timeTakenMillis = Time.currentTimeMillis() - state.startTimeMillis;
            this.backtracked = state.numBacktrack;
        }

        public SchedulingResult asSchedulingResult() {
            if (this.success) {
                return SchedulingResult.success("Fully Scheduled by ConstraintSolverStrategy (" + this.statesSearched + " states traversed in " + this.timeTakenMillis + "ms, backtracked " + this.backtracked + " times)");
            }
            this.state.logNodeCompAssignments();
            return SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, "Cannot find scheduling that satisfies all constraints (" + this.statesSearched + " states traversed in " + this.timeTakenMillis + "ms, backtracked " + this.backtracked + " times)");
        }
    }

    public static final class ConstraintConfig {
        private Map<String, Set<String>> incompatibleComponents = new HashMap<String, Set<String>>();
        private Map<String, Integer> maxCoLocationCnts = new HashMap<String, Integer>();

        ConstraintConfig(TopologyDetails topo) {
            this(topo.getConf(), (Set<String>)Sets.union(topo.getComponents().keySet(), new HashSet<String>(topo.getExecutorToComponent().values())));
        }

        ConstraintConfig(Map<String, Object> conf, Set<String> comps) {
            Object rasConstraints = conf.get("topology.ras.constraints");
            comps.forEach(k -> this.incompatibleComponents.computeIfAbsent((String)k, x -> new HashSet()));
            if (rasConstraints instanceof List) {
                List constraints = (List)rasConstraints;
                for (List constraintPair : constraints) {
                    String comp12 = (String)constraintPair.get(0);
                    String comp2 = (String)constraintPair.get(1);
                    if (!comps.contains(comp12)) {
                        LOG.warn("Comp: {} declared in constraints is not valid!", (Object)comp12);
                        continue;
                    }
                    if (!comps.contains(comp2)) {
                        LOG.warn("Comp: {} declared in constraints is not valid!", (Object)comp2);
                        continue;
                    }
                    this.incompatibleComponents.get(comp12).add(comp2);
                    this.incompatibleComponents.get(comp2).add(comp12);
                }
            } else {
                Map constraintMap = (Map)rasConstraints;
                constraintMap.forEach((comp1, v) -> {
                    if (comps.contains(comp1)) {
                        v.forEach((ctype, constraint) -> {
                            switch (ctype) {
                                case "maxNodeCoLocationCnt": {
                                    try {
                                        int numValue = Integer.parseInt("" + constraint);
                                        if (numValue < 1) {
                                            LOG.warn("{} {} declared for Comp {} is not valid, expected >= 1", new Object[]{ctype, numValue, comp1});
                                            break;
                                        }
                                        this.maxCoLocationCnts.put((String)comp1, numValue);
                                    }
                                    catch (Exception ex) {
                                        LOG.warn("{} {} declared for Comp {} is not valid, expected >= 1", new Object[]{ctype, constraint, comp1});
                                    }
                                    break;
                                }
                                case "incompatibleComponents": {
                                    if (!(constraint instanceof List) && !(constraint instanceof String)) {
                                        LOG.warn("{} {} declared for Comp {} is not valid, expecting a list of components or 1 component", new Object[]{ctype, constraint, comp1});
                                        break;
                                    }
                                    List<String> list = constraint instanceof String ? Arrays.asList((String)constraint) : (List<String>)constraint;
                                    for (String comp2 : list) {
                                        if (!comps.contains(comp2)) {
                                            LOG.warn("{} {} declared for Comp {} is not a valid component", new Object[]{ctype, comp2, comp1});
                                            continue;
                                        }
                                        this.incompatibleComponents.get(comp1).add(comp2);
                                        this.incompatibleComponents.get(comp2).add((String)comp1);
                                    }
                                    break;
                                }
                                default: {
                                    LOG.warn("ConstraintType={} invalid for component={}, valid values are {} and {}, ignoring value={}", new Object[]{ctype, comp1, ConstraintSolverStrategy.CONSTRAINT_TYPE_MAX_NODE_CO_LOCATION_CNT, ConstraintSolverStrategy.CONSTRAINT_TYPE_INCOMPATIBLE_COMPONENTS, constraint});
                                }
                            }
                        });
                    } else {
                        LOG.warn("Component {} is not a valid component", comp1);
                    }
                });
            }
            Object obj = conf.get("topology.spread.components");
            if (obj instanceof List) {
                List spread = (List)obj;
                if (spread != null) {
                    for (String comp : spread) {
                        if (!comps.contains(comp)) {
                            LOG.warn("Comp {} declared for spread not valid", (Object)comp);
                            continue;
                        }
                        if (this.maxCoLocationCnts.containsKey(comp)) {
                            LOG.warn("Comp {} maxNodeCoLocationCnt={} already defined in {}, ignoring spread config in {}", new Object[]{comp, this.maxCoLocationCnts.get(comp), "topology.ras.constraints", "topology.spread.components"});
                            continue;
                        }
                        this.maxCoLocationCnts.put(comp, 1);
                    }
                }
            } else {
                LOG.warn("Ignoring invalid {} config={}", (Object)"topology.spread.components", obj);
            }
        }

        public Map<String, Set<String>> getIncompatibleComponents() {
            return this.incompatibleComponents;
        }

        public Map<String, Integer> getMaxCoLocationCnts() {
            return this.maxCoLocationCnts;
        }
    }
}

