/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.storm.generated.ComponentType;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceAwareStrategy
implements IStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceAwareStrategy.class);
    protected Cluster cluster;
    private Map<String, List<String>> networkTopography;
    private final Map<String, String> superIdToRack = new HashMap<String, String>();
    private final Map<String, String> superIdToHostname = new HashMap<String, String>();
    private final Map<String, List<RasNode>> hostnameToNodes = new HashMap<String, List<RasNode>>();
    private final Map<String, List<RasNode>> rackIdToNodes = new HashMap<String, List<RasNode>>();
    protected RasNodes nodes;

    @VisibleForTesting
    void prepare(Cluster cluster) {
        this.cluster = cluster;
        this.nodes = new RasNodes(cluster);
        this.networkTopography = cluster.getNetworkTopography();
        HashMap<String, String> hostToRack = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.networkTopography.entrySet()) {
            String rackId = entry.getKey();
            for (String hostName : entry.getValue()) {
                hostToRack.put(hostName, rackId);
            }
        }
        for (RasNode node : this.nodes.getNodes()) {
            String superId = node.getId();
            String hostName = node.getHostname();
            String rackId = hostToRack.getOrDefault(hostName, "/default-rack");
            this.superIdToHostname.put(superId, hostName);
            this.superIdToRack.put(superId, rackId);
            this.hostnameToNodes.computeIfAbsent(hostName, hn -> new ArrayList()).add(node);
            this.rackIdToNodes.computeIfAbsent(rackId, hn -> new ArrayList()).add(node);
        }
        this.logClusterInfo();
    }

    @Override
    public void prepare(Map<String, Object> config) {
    }

    protected SchedulingResult mkNotEnoughResources(TopologyDetails td) {
        return SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, td.getExecutors().size() + " executors not scheduled");
    }

    protected boolean scheduleExecutor(ExecutorDetails exec, TopologyDetails td, Collection<ExecutorDetails> scheduledTasks, Iterable<String> sortedNodes) {
        WorkerSlot targetSlot = this.findWorkerForExec(exec, td, sortedNodes);
        if (targetSlot != null) {
            RasNode targetNode = this.idToNode(targetSlot.getNodeId());
            targetNode.assignSingleExecutor(targetSlot, exec, td);
            scheduledTasks.add(exec);
            LOG.debug("TASK {} assigned to Node: {} avail [ mem: {} cpu: {} ] total [ mem: {} cpu: {} ] on slot: {} on Rack: {}", new Object[]{exec, targetNode.getHostname(), targetNode.getAvailableMemoryResources(), targetNode.getAvailableCpuResources(), targetNode.getTotalMemoryResources(), targetNode.getTotalCpuResources(), targetSlot, this.nodeToRack(targetNode)});
            return true;
        }
        String comp = td.getExecutorToComponent().get(exec);
        NormalizedResourceRequest requestedResources = td.getTotalResources(exec);
        LOG.warn("Not Enough Resources to schedule Task {} - {} {}", new Object[]{exec, comp, requestedResources});
        return false;
    }

    protected abstract TreeSet<ObjectResources> sortObjectResources(AllResources var1, ExecutorDetails var2, TopologyDetails var3, ExistingScheduleFunc var4);

    protected WorkerSlot findWorkerForExec(ExecutorDetails exec, TopologyDetails td, Iterable<String> sortedNodes) {
        for (String id : sortedNodes) {
            RasNode node = this.nodes.getNodeById(id);
            if (!node.couldEverFit(exec, td)) continue;
            for (WorkerSlot ws : node.getSlotsAvailableToScheduleOn()) {
                if (!node.wouldFit(ws, exec, td)) continue;
                return ws;
            }
        }
        return null;
    }

    protected TreeSet<ObjectResources> sortNodes(List<RasNode> availNodes, ExecutorDetails exec, TopologyDetails topologyDetails, String rackId, Map<String, AtomicInteger> scheduledCount) {
        AllResources allRackResources = new AllResources("RACK");
        List<ObjectResources> nodes = allRackResources.objectResources;
        for (RasNode rasNode : availNodes) {
            String superId2 = rasNode.getId();
            ObjectResources node = new ObjectResources(superId2);
            node.availableResources = rasNode.getTotalAvailableResources();
            node.totalResources = rasNode.getTotalResources();
            nodes.add(node);
            allRackResources.availableResourcesOverall.add(node.availableResources);
            allRackResources.totalResourcesOverall.add(node.totalResources);
        }
        LOG.debug("Rack {}: Overall Avail [ {} ] Total [ {} ]", new Object[]{rackId, allRackResources.availableResourcesOverall, allRackResources.totalResourcesOverall});
        return this.sortObjectResources(allRackResources, exec, topologyDetails, superId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(superId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    protected List<String> makeHostToNodeIds(List<String> hosts) {
        if (hosts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(hosts.size());
        for (String host : hosts) {
            List<RasNode> nodes = this.hostnameToNodes.get(host);
            if (nodes == null) continue;
            for (RasNode node : nodes) {
                ret.add(node.getId());
            }
        }
        return ret;
    }

    protected Iterable<String> sortAllNodes(TopologyDetails td, ExecutorDetails exec, List<String> favoredNodeIds, List<String> unFavoredNodeIds) {
        return new LazyNodeSorting(td, exec, favoredNodeIds, unFavoredNodeIds);
    }

    private AllResources createClusterAllResources() {
        AllResources allResources = new AllResources("Cluster");
        List<ObjectResources> racks = allResources.objectResources;
        for (Map.Entry<String, List<String>> entry : this.networkTopography.entrySet()) {
            String rackId = entry.getKey();
            List<String> nodeHosts = entry.getValue();
            ObjectResources rack = new ObjectResources(rackId);
            racks.add(rack);
            for (String nodeHost : nodeHosts) {
                for (RasNode node : this.hostnameToNodes(nodeHost)) {
                    rack.availableResources.add(node.getTotalAvailableResources());
                    rack.totalResources.add(node.getTotalAvailableResources());
                }
            }
            allResources.totalResourcesOverall.add(rack.totalResources);
            allResources.availableResourcesOverall.add(rack.availableResources);
        }
        LOG.debug("Cluster Overall Avail [ {} ] Total [ {} ]", (Object)allResources.availableResourcesOverall, (Object)allResources.totalResourcesOverall);
        return allResources;
    }

    private Map<String, AtomicInteger> getScheduledCount(TopologyDetails topologyDetails) {
        String topoId = topologyDetails.getId();
        SchedulerAssignment assignment = this.cluster.getAssignmentById(topoId);
        HashMap<String, AtomicInteger> scheduledCount = new HashMap<String, AtomicInteger>();
        if (assignment != null) {
            for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                String superId = entry.getKey().getNodeId();
                String rackId = this.superIdToRack.get(superId);
                scheduledCount.computeIfAbsent(rackId, rid -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
            }
        }
        return scheduledCount;
    }

    @VisibleForTesting
    TreeSet<ObjectResources> sortRacks(ExecutorDetails exec, TopologyDetails topologyDetails) {
        AllResources allResources = this.createClusterAllResources();
        Map<String, AtomicInteger> scheduledCount = this.getScheduledCount(topologyDetails);
        return this.sortObjectResources(allResources, exec, topologyDetails, rackId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(rackId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    protected String nodeToRack(RasNode node) {
        return this.superIdToRack.get(node.getId());
    }

    private Set<Component> sortComponents(Map<String, Component> componentMap) {
        TreeSet<Component> sortedComponents = new TreeSet<Component>((o1, o2) -> {
            int connections1 = 0;
            int connections2 = 0;
            for (String childId : Sets.union(o1.getChildren(), o1.getParents())) {
                connections1 += ((Component)componentMap.get(childId)).getExecs().size() * o1.getExecs().size();
            }
            for (String childId : Sets.union(o2.getChildren(), o2.getParents())) {
                connections2 += ((Component)componentMap.get(childId)).getExecs().size() * o2.getExecs().size();
            }
            if (connections1 > connections2) {
                return -1;
            }
            if (connections1 < connections2) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        });
        sortedComponents.addAll(componentMap.values());
        return sortedComponents;
    }

    private Set<Component> sortNeighbors(Component thisComp, Map<String, Component> componentMap) {
        TreeSet<Component> sortedComponents = new TreeSet<Component>((o1, o2) -> {
            int connections2;
            int connections1 = o1.getExecs().size() * thisComp.getExecs().size();
            if (connections1 < (connections2 = o2.getExecs().size() * thisComp.getExecs().size())) {
                return -1;
            }
            if (connections1 > connections2) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        });
        sortedComponents.addAll(componentMap.values());
        return sortedComponents;
    }

    protected List<ExecutorDetails> orderExecutors(TopologyDetails td, Collection<ExecutorDetails> unassignedExecutors) {
        Boolean orderByProximity = ObjectReader.getBoolean((Object)td.getConf().get("topology.ras.order.executors.by.proximity.needs"), (boolean)false);
        if (!orderByProximity.booleanValue()) {
            return this.orderExecutorsDefault(td, unassignedExecutors);
        }
        LOG.info("{} is set to true", (Object)"topology.ras.order.executors.by.proximity.needs");
        return this.orderExecutorsByProximityNeeds(td, unassignedExecutors);
    }

    private List<ExecutorDetails> orderExecutorsDefault(TopologyDetails td, Collection<ExecutorDetails> unassignedExecutors) {
        Map<String, Component> componentMap = td.getComponents();
        LinkedList<ExecutorDetails> execsScheduled = new LinkedList<ExecutorDetails>();
        HashMap compToExecsToSchedule = new HashMap();
        for (Component component : componentMap.values()) {
            compToExecsToSchedule.put(component.getId(), new LinkedList());
            for (ExecutorDetails exec : component.getExecs()) {
                if (!unassignedExecutors.contains(exec)) continue;
                ((Queue)compToExecsToSchedule.get(component.getId())).add(exec);
            }
        }
        Set<Component> sortedComponents = this.sortComponents(componentMap);
        sortedComponents.addAll(componentMap.values());
        for (Component currComp : sortedComponents) {
            HashMap<String, Component> neighbors = new HashMap<String, Component>();
            for (String compId : Sets.union(currComp.getChildren(), currComp.getParents())) {
                neighbors.put(compId, componentMap.get(compId));
            }
            Set<Component> sortedNeighbors = this.sortNeighbors(currComp, neighbors);
            Queue currCompExesToSched = (Queue)compToExecsToSchedule.get(currComp.getId());
            boolean flag = false;
            do {
                flag = false;
                if (!currCompExesToSched.isEmpty()) {
                    execsScheduled.add((ExecutorDetails)currCompExesToSched.poll());
                    flag = true;
                }
                for (Component neighborComp : sortedNeighbors) {
                    Queue neighborCompExesToSched = (Queue)compToExecsToSchedule.get(neighborComp.getId());
                    if (neighborCompExesToSched.isEmpty()) continue;
                    execsScheduled.add((ExecutorDetails)neighborCompExesToSched.poll());
                    flag = true;
                }
            } while (flag);
        }
        return execsScheduled;
    }

    private List<ExecutorDetails> orderExecutorsByProximityNeeds(TopologyDetails td, Collection<ExecutorDetails> unassignedExecutors) {
        Map<String, Component> componentMap = td.getComponents();
        LinkedList<ExecutorDetails> execsScheduled = new LinkedList<ExecutorDetails>();
        HashMap<String, Queue<ExecutorDetails>> compToExecsToSchedule = new HashMap<String, Queue<ExecutorDetails>>();
        for (Component component : componentMap.values()) {
            compToExecsToSchedule.put(component.getId(), new LinkedList());
            for (ExecutorDetails exec : component.getExecs()) {
                if (!unassignedExecutors.contains(exec)) continue;
                ((Queue)compToExecsToSchedule.get(component.getId())).add(exec);
            }
        }
        List<Component> sortedComponents = this.topologicalSortComponents(componentMap);
        for (Component currComp : sortedComponents) {
            int numExecs = ((Queue)compToExecsToSchedule.get(currComp.getId())).size();
            for (int i = 0; i < numExecs; ++i) {
                execsScheduled.addAll(this.takeExecutors(currComp, componentMap, compToExecsToSchedule));
            }
        }
        return execsScheduled;
    }

    private List<Component> topologicalSortComponents(Map<String, Component> componentMap) {
        int i;
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        boolean[] visited = new boolean[componentMap.size()];
        int[] inDegree = new int[componentMap.size()];
        ArrayList<String> componentIds = new ArrayList<String>(componentMap.keySet());
        HashMap compIdToIndex = new HashMap();
        for (i = 0; i < componentIds.size(); ++i) {
            compIdToIndex.put(componentIds.get(i), i);
        }
        for (i = 0; i < inDegree.length; ++i) {
            String compId = (String)componentIds.get(i);
            Component comp = componentMap.get(compId);
            for (String childId : comp.getChildren()) {
                int n = (Integer)compIdToIndex.get(childId);
                inDegree[n] = inDegree[n] + 1;
            }
        }
        block3: for (int t = 0; t < inDegree.length; ++t) {
            for (int i2 = 0; i2 < inDegree.length; ++i2) {
                if (inDegree[i2] != 0 || visited[i2]) continue;
                String compId = (String)componentIds.get(i2);
                Component comp = componentMap.get(compId);
                sortedComponents.add(comp);
                visited[i2] = true;
                for (String childId : comp.getChildren()) {
                    int n = (Integer)compIdToIndex.get(childId);
                    inDegree[n] = inDegree[n] - 1;
                }
                continue block3;
            }
        }
        return sortedComponents;
    }

    private List<ExecutorDetails> takeExecutors(Component currComp, Map<String, Component> componentMap, Map<String, Queue<ExecutorDetails>> compToExecsToSchedule) {
        ArrayList<ExecutorDetails> execsScheduled = new ArrayList<ExecutorDetails>();
        Queue<ExecutorDetails> currQueue = compToExecsToSchedule.get(currComp.getId());
        int currUnscheduledNumExecs = currQueue.size();
        if (currUnscheduledNumExecs == 0) {
            return execsScheduled;
        }
        execsScheduled.add(currQueue.poll());
        Set<String> sortedChildren = this.getSortedChildren(currComp, componentMap);
        for (String childId : sortedChildren) {
            Component childComponent = componentMap.get(childId);
            Queue<ExecutorDetails> childQueue = compToExecsToSchedule.get(childId);
            int childUnscheduledNumExecs = childQueue.size();
            if (childUnscheduledNumExecs == 0) continue;
            int numExecsToTake = 1;
            if (this.hasShuffleGroupingFromParentToChild(currComp, childComponent)) {
                numExecsToTake = Math.max(1, childUnscheduledNumExecs / currUnscheduledNumExecs);
            }
            for (int i = 0; i < numExecsToTake; ++i) {
                execsScheduled.addAll(this.takeExecutors(childComponent, componentMap, compToExecsToSchedule));
            }
        }
        return execsScheduled;
    }

    private Set<String> getSortedChildren(Component component, Map<String, Component> componentMap) {
        Set<String> children = component.getChildren();
        TreeSet<String> sortedChildren = new TreeSet<String>((o1, o2) -> {
            Component child1 = (Component)componentMap.get(o1);
            Component child2 = (Component)componentMap.get(o2);
            boolean child1IsShuffle = this.hasShuffleGroupingFromParentToChild(component, child1);
            boolean child2IsShuffle = this.hasShuffleGroupingFromParentToChild(component, child2);
            if (child1IsShuffle && child2IsShuffle) {
                return o1.compareTo((String)o2);
            }
            if (child1IsShuffle) {
                return 1;
            }
            return -1;
        });
        sortedChildren.addAll(children);
        return sortedChildren;
    }

    private boolean hasShuffleGroupingFromParentToChild(Component parent, Component child) {
        for (Map.Entry<GlobalStreamId, Grouping> inputEntry : child.getInputs().entrySet()) {
            GlobalStreamId globalStreamId = inputEntry.getKey();
            Grouping grouping = inputEntry.getValue();
            if (!globalStreamId.get_componentId().equals(parent.getId()) || !inputEntry.getValue().is_set_local_or_shuffle() && !grouping.is_set_shuffle()) continue;
            return true;
        }
        return false;
    }

    protected List<Component> getSpouts(TopologyDetails td) {
        ArrayList<Component> spouts = new ArrayList<Component>();
        for (Component c : td.getComponents().values()) {
            if (c.getType() != ComponentType.SPOUT) continue;
            spouts.add(c);
        }
        return spouts;
    }

    private void logClusterInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cluster:");
            for (Map.Entry<String, List<String>> clusterEntry : this.networkTopography.entrySet()) {
                String rackId = clusterEntry.getKey();
                LOG.debug("Rack: {}", (Object)rackId);
                for (String nodeHostname : clusterEntry.getValue()) {
                    for (RasNode node : this.hostnameToNodes(nodeHostname)) {
                        LOG.debug("-> Node: {} {}", (Object)node.getHostname(), (Object)node.getId());
                        LOG.debug("--> Avail Resources: {Mem {}, CPU {} Slots: {}}", new Object[]{node.getAvailableMemoryResources(), node.getAvailableCpuResources(), node.totalSlotsFree()});
                        LOG.debug("--> Total Resources: {Mem {}, CPU {} Slots: {}}", new Object[]{node.getTotalMemoryResources(), node.getTotalCpuResources(), node.totalSlots()});
                    }
                }
            }
        }
    }

    public List<RasNode> hostnameToNodes(String hostname) {
        return this.hostnameToNodes.getOrDefault(hostname, Collections.emptyList());
    }

    public RasNode idToNode(String id) {
        RasNode ret = this.nodes.getNodeById(id);
        if (ret == null) {
            LOG.error("Cannot find Node with Id: {}", (Object)id);
        }
        return ret;
    }

    protected static class ObjectResources {
        public final String id;
        public NormalizedResourceOffer availableResources;
        public NormalizedResourceOffer totalResources;
        public double effectiveResources = 0.0;

        public ObjectResources(String id) {
            this.id = id;
            this.availableResources = new NormalizedResourceOffer();
            this.totalResources = new NormalizedResourceOffer();
        }

        public ObjectResources(ObjectResources other) {
            this(other.id, other.availableResources, other.totalResources, other.effectiveResources);
        }

        public ObjectResources(String id, NormalizedResourceOffer availableResources, NormalizedResourceOffer totalResources, double effectiveResources) {
            this.id = id;
            this.availableResources = availableResources;
            this.totalResources = totalResources;
            this.effectiveResources = effectiveResources;
        }

        public String toString() {
            return this.id;
        }
    }

    protected static class AllResources {
        List<ObjectResources> objectResources = new LinkedList<ObjectResources>();
        final NormalizedResourceOffer availableResourcesOverall;
        final NormalizedResourceOffer totalResourcesOverall;
        String identifier;

        public AllResources(String identifier) {
            this.identifier = identifier;
            this.availableResourcesOverall = new NormalizedResourceOffer();
            this.totalResourcesOverall = new NormalizedResourceOffer();
        }

        public AllResources(AllResources other) {
            this(null, new NormalizedResourceOffer(other.availableResourcesOverall), new NormalizedResourceOffer(other.totalResourcesOverall), other.identifier);
            ArrayList<ObjectResources> objectResourcesList = new ArrayList<ObjectResources>();
            for (ObjectResources objectResource : other.objectResources) {
                objectResourcesList.add(new ObjectResources(objectResource));
            }
            this.objectResources = objectResourcesList;
        }

        public AllResources(List<ObjectResources> objectResources, NormalizedResourceOffer availableResourcesOverall, NormalizedResourceOffer totalResourcesOverall, String identifier) {
            this.objectResources = objectResources;
            this.availableResourcesOverall = availableResourcesOverall;
            this.totalResourcesOverall = totalResourcesOverall;
            this.identifier = identifier;
        }
    }

    protected static interface ExistingScheduleFunc {
        public int getNumExistingSchedule(String var1);
    }

    private class LazyNodeSorting
    implements Iterable<String> {
        private final Map<String, AtomicInteger> perNodeScheduledCount = new HashMap<String, AtomicInteger>();
        private final TreeSet<ObjectResources> sortedRacks;
        private final Map<String, TreeSet<ObjectResources>> cachedNodes = new HashMap<String, TreeSet<ObjectResources>>();
        private final ExecutorDetails exec;
        private final TopologyDetails td;
        private final List<String> favoredNodeIds;
        private final List<String> unFavoredNodeIds;
        private final List<String> greyListedSupervisorIds;
        private final Set<String> skippedNodeIds = new HashSet<String>();

        LazyNodeSorting(TopologyDetails td, ExecutorDetails exec, List<String> favoredNodeIds, List<String> unFavoredNodeIds) {
            this.favoredNodeIds = favoredNodeIds;
            this.unFavoredNodeIds = unFavoredNodeIds;
            this.greyListedSupervisorIds = BaseResourceAwareStrategy.this.cluster.getGreyListedSupervisors();
            this.unFavoredNodeIds.removeAll(favoredNodeIds);
            this.favoredNodeIds.removeAll(this.greyListedSupervisorIds);
            this.unFavoredNodeIds.removeAll(this.greyListedSupervisorIds);
            this.skippedNodeIds.addAll(favoredNodeIds);
            this.skippedNodeIds.addAll(unFavoredNodeIds);
            this.skippedNodeIds.addAll(this.greyListedSupervisorIds);
            this.td = td;
            this.exec = exec;
            String topoId = td.getId();
            SchedulerAssignment assignment = BaseResourceAwareStrategy.this.cluster.getAssignmentById(topoId);
            if (assignment != null) {
                for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                    String superId = entry.getKey().getNodeId();
                    this.perNodeScheduledCount.computeIfAbsent(superId, sid -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
                }
            }
            this.sortedRacks = BaseResourceAwareStrategy.this.sortRacks(exec, td);
        }

        private TreeSet<ObjectResources> getSortedNodesFor(String rackId) {
            return this.cachedNodes.computeIfAbsent(rackId, rid -> BaseResourceAwareStrategy.this.sortNodes(BaseResourceAwareStrategy.this.rackIdToNodes.getOrDefault(rid, Collections.emptyList()), this.exec, this.td, (String)rid, this.perNodeScheduledCount));
        }

        @Override
        public Iterator<String> iterator() {
            return new LazyNodeSortingIterator(this, this.sortedRacks);
        }
    }

    private static class LazyNodeSortingIterator
    implements Iterator<String> {
        private final LazyNodeSorting parent;
        private final Iterator<ObjectResources> rackIterator;
        private Iterator<ObjectResources> nodeIterator;
        private String nextValueFromNode = null;
        private final Iterator<String> pre;
        private final Iterator<String> post;
        private final Set<String> skip;

        LazyNodeSortingIterator(LazyNodeSorting parent, TreeSet<ObjectResources> sortedRacks) {
            this.parent = parent;
            this.rackIterator = sortedRacks.iterator();
            this.pre = parent.favoredNodeIds.iterator();
            this.post = Stream.concat(parent.unFavoredNodeIds.stream(), parent.greyListedSupervisorIds.stream()).collect(Collectors.toList()).iterator();
            this.skip = parent.skippedNodeIds;
        }

        private Iterator<ObjectResources> getNodeIterator() {
            if (this.nodeIterator != null && this.nodeIterator.hasNext()) {
                return this.nodeIterator;
            }
            if (this.rackIterator.hasNext()) {
                ObjectResources rack = this.rackIterator.next();
                String rackId = rack.id;
                this.nodeIterator = this.parent.getSortedNodesFor(rackId).iterator();
                return this.nodeIterator;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            Iterator<ObjectResources> nodeIterator;
            if (this.pre.hasNext()) {
                return true;
            }
            if (this.nextValueFromNode != null) {
                return true;
            }
            while ((nodeIterator = this.getNodeIterator()) != null && nodeIterator.hasNext()) {
                String tmp = nodeIterator.next().id;
                if (this.skip.contains(tmp)) continue;
                this.nextValueFromNode = tmp;
                return true;
            }
            return this.post.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pre.hasNext()) {
                return this.pre.next();
            }
            if (this.nextValueFromNode != null) {
                String tmp = this.nextValueFromNode;
                this.nextValueFromNode = null;
                return tmp;
            }
            return this.post.next();
        }
    }
}

