/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasNodes {
    private static final Logger LOG = LoggerFactory.getLogger(RasNodes.class);
    private Map<String, RasNode> nodeMap;

    public RasNodes(Cluster cluster) {
        this.nodeMap = RasNodes.getAllNodesFrom(cluster);
    }

    public static Map<String, RasNode> getAllNodesFrom(Cluster cluster) {
        Object topId;
        HashMap<String, RasNode> nodeIdToNode = new HashMap<String, RasNode>();
        HashMap assignmentRelationshipMap = new HashMap();
        HashMap workerIdToWorker = new HashMap();
        for (SchedulerAssignment schedulerAssignment : cluster.getAssignments().values()) {
            topId = schedulerAssignment.getTopologyId();
            for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : schedulerAssignment.getSlotToExecutors().entrySet()) {
                WorkerSlot slot = entry.getKey();
                String nodeId = slot.getNodeId();
                if (!assignmentRelationshipMap.containsKey(nodeId)) {
                    assignmentRelationshipMap.put(nodeId, new HashMap());
                    workerIdToWorker.put(nodeId, new HashMap());
                }
                ((Map)workerIdToWorker.get(nodeId)).put(slot.getId(), slot);
                if (!((Map)assignmentRelationshipMap.get(nodeId)).containsKey(topId)) {
                    ((Map)assignmentRelationshipMap.get(nodeId)).put(topId, new HashMap());
                }
                if (!((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).containsKey(slot.getId())) {
                    ((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).put(slot.getId(), new LinkedList());
                }
                Collection<ExecutorDetails> execs = entry.getValue();
                ((Collection)((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).get(slot.getId())).addAll(execs);
            }
        }
        for (SupervisorDetails supervisorDetails : cluster.getSupervisors().values()) {
            topId = supervisorDetails.getAllPorts().iterator();
            while (topId.hasNext()) {
                int port = (Integer)topId.next();
                WorkerSlot worker = new WorkerSlot(supervisorDetails.getId(), (Number)port);
                if (!workerIdToWorker.containsKey(supervisorDetails.getId())) {
                    workerIdToWorker.put(supervisorDetails.getId(), new HashMap());
                }
                if (((Map)workerIdToWorker.get(supervisorDetails.getId())).containsKey(worker.getId())) continue;
                ((Map)workerIdToWorker.get(supervisorDetails.getId())).put(worker.getId(), worker);
            }
            nodeIdToNode.put(supervisorDetails.getId(), new RasNode(supervisorDetails.getId(), supervisorDetails, cluster, (Map)workerIdToWorker.get(supervisorDetails.getId()), (Map)assignmentRelationshipMap.get(supervisorDetails.getId())));
        }
        for (Map.Entry entry : assignmentRelationshipMap.entrySet()) {
            String nodeId = (String)entry.getKey();
            Map assignments = (Map)entry.getValue();
            if (nodeIdToNode.containsKey(nodeId)) continue;
            LOG.info("Found an assigned slot(s) on a dead supervisor {} with assignments {}", (Object)nodeId, (Object)assignments);
            nodeIdToNode.put(nodeId, new RasNode(nodeId, null, cluster, (Map)workerIdToWorker.get(nodeId), assignments));
        }
        return nodeIdToNode;
    }

    public RasNode getNodeById(String nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public void freeSlots(Collection<WorkerSlot> workerSlots) {
        for (RasNode node : this.nodeMap.values()) {
            for (WorkerSlot ws : node.getUsedSlots()) {
                if (!workerSlots.contains(ws)) continue;
                LOG.debug("freeing ws {} on node {}", (Object)ws, (Object)node);
                node.free(ws);
            }
        }
    }

    public Collection<RasNode> getNodes() {
        return this.nodeMap.values();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (RasNode node : this.nodeMap.values()) {
            ret.append(node).append("\n");
        }
        return ret.toString();
    }
}

