/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.multitenant.DefaultPool;
import org.apache.storm.scheduler.multitenant.FreePool;
import org.apache.storm.scheduler.multitenant.IsolatedPool;
import org.apache.storm.scheduler.multitenant.Node;
import org.apache.storm.scheduler.multitenant.NodePool;
import org.apache.storm.scheduler.utils.ConfigLoaderFactoryService;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultitenantScheduler
implements IScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MultitenantScheduler.class);
    protected IConfigLoader configLoader;
    private Map<String, Object> conf;

    @Override
    public void prepare(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) {
        this.conf = conf;
        this.configLoader = ConfigLoaderFactoryService.createConfigLoader(conf);
    }

    private Map<String, Number> getUserConf() {
        Map fromFile;
        Map ret;
        if (this.configLoader != null) {
            ret = this.configLoader.load("multitenant.scheduler.user.pools");
            if (ret != null) {
                return ret;
            }
            LOG.warn("Config loader returned null. Will try to read from multitenant-scheduler.yaml");
        }
        if ((ret = (Map)(fromFile = Utils.findAndReadConfigFile((String)"multitenant-scheduler.yaml", (boolean)false)).get("multitenant.scheduler.user.pools")) != null) {
            return ret;
        }
        LOG.warn("Reading from multitenant-scheduler.yaml returned null. This could because the file is not available. Will load configs from storm configuration");
        ret = (Map)this.conf.get("multitenant.scheduler.user.pools");
        if (ret == null) {
            return new HashMap<String, Number>();
        }
        return ret;
    }

    @Override
    public Map config() {
        return this.getUserConf();
    }

    @Override
    public void schedule(Topologies topologies, Cluster cluster) {
        LOG.debug("Rerunning scheduling...");
        Map<String, Node> nodeIdToNode = Node.getAllNodesFrom(cluster);
        Map<String, Number> userConf = this.getUserConf();
        HashMap<String, IsolatedPool> userPools = new HashMap<String, IsolatedPool>();
        for (Map.Entry<String, Number> entry : userConf.entrySet()) {
            userPools.put(entry.getKey(), new IsolatedPool(entry.getValue().intValue()));
        }
        DefaultPool defaultPool = new DefaultPool();
        FreePool freePool = new FreePool();
        freePool.init(cluster, nodeIdToNode);
        for (IsolatedPool pool : userPools.values()) {
            pool.init(cluster, nodeIdToNode);
        }
        defaultPool.init(cluster, nodeIdToNode);
        for (TopologyDetails td : topologies.getTopologies()) {
            String user = td.getTopologySubmitter();
            LOG.debug("Found top {} run by user {}", (Object)td.getId(), (Object)user);
            NodePool pool = (NodePool)userPools.get(user);
            if (pool == null || !pool.canAdd(td)) {
                pool = defaultPool;
            }
            pool.addTopology(td);
        }
        for (IsolatedPool pool : userPools.values()) {
            pool.scheduleAsNeeded(freePool, defaultPool);
        }
        defaultPool.scheduleAsNeeded(freePool);
        LOG.debug("Scheduling done...");
    }
}

