/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvenScheduler
implements IScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(EvenScheduler.class);

    @VisibleForTesting
    public static List<WorkerSlot> sortSlots(List<WorkerSlot> availableSlots) {
        if (availableSlots != null && availableSlots.size() > 0) {
            TreeMap slotGroups = new TreeMap();
            for (WorkerSlot slot : availableSlots) {
                String node = slot.getNodeId();
                List<WorkerSlot> slots = null;
                if (slotGroups.containsKey(node)) {
                    slots = (List)slotGroups.get(node);
                } else {
                    slots = new ArrayList();
                    slotGroups.put(node, slots);
                }
                slots.add(slot);
            }
            for (List slots : slotGroups.values()) {
                Collections.sort(slots, new Comparator<WorkerSlot>(){

                    @Override
                    public int compare(WorkerSlot o1, WorkerSlot o2) {
                        return o1.getPort() - o2.getPort();
                    }
                });
            }
            ArrayList list = new ArrayList(slotGroups.values());
            Collections.sort(list, new Comparator<List<WorkerSlot>>(){

                @Override
                public int compare(List<WorkerSlot> o1, List<WorkerSlot> o2) {
                    return o2.size() - o1.size();
                }
            });
            return ServerUtils.interleaveAll(list);
        }
        return null;
    }

    public static Map<WorkerSlot, List<ExecutorDetails>> getAliveAssignedWorkerSlotExecutors(Cluster cluster, String topologyId) {
        SchedulerAssignment existingAssignment = cluster.getAssignmentById(topologyId);
        Map<ExecutorDetails, WorkerSlot> executorToSlot = null;
        if (existingAssignment != null) {
            executorToSlot = existingAssignment.getExecutorToSlot();
        }
        return Utils.reverseMap(executorToSlot);
    }

    private static Map<ExecutorDetails, WorkerSlot> scheduleTopology(TopologyDetails topology, Cluster cluster) {
        List<WorkerSlot> availableSlots = cluster.getAvailableSlots();
        Set<ExecutorDetails> allExecutors = topology.getExecutors();
        Map<WorkerSlot, List<ExecutorDetails>> aliveAssigned = EvenScheduler.getAliveAssignedWorkerSlotExecutors(cluster, topology.getId());
        int totalSlotsToUse = Math.min(topology.getNumWorkers(), availableSlots.size() + aliveAssigned.size());
        List<WorkerSlot> sortedList = EvenScheduler.sortSlots(availableSlots);
        if (sortedList == null) {
            LOG.error("No available slots for topology: {}", (Object)topology.getName());
            return new HashMap<ExecutorDetails, WorkerSlot>();
        }
        int toIndex = totalSlotsToUse - aliveAssigned.size() > sortedList.size() ? sortedList.size() : totalSlotsToUse - aliveAssigned.size();
        List<WorkerSlot> reassignSlots = sortedList.subList(0, toIndex);
        HashSet<ExecutorDetails> aliveExecutors = new HashSet<ExecutorDetails>();
        for (List<ExecutorDetails> list : aliveAssigned.values()) {
            aliveExecutors.addAll(list);
        }
        Sets.SetView reassignExecutors = Sets.difference(allExecutors, aliveExecutors);
        HashMap<ExecutorDetails, WorkerSlot> reassignment = new HashMap<ExecutorDetails, WorkerSlot>();
        if (reassignSlots.size() == 0) {
            return reassignment;
        }
        ArrayList executors = new ArrayList(reassignExecutors);
        Collections.sort(executors, new Comparator<ExecutorDetails>(){

            @Override
            public int compare(ExecutorDetails o1, ExecutorDetails o2) {
                return o1.getStartTask() - o2.getStartTask();
            }
        });
        for (int i = 0; i < executors.size(); ++i) {
            reassignment.put((ExecutorDetails)executors.get(i), reassignSlots.get(i % reassignSlots.size()));
        }
        if (reassignment.size() != 0) {
            LOG.info("Available slots: {}", (Object)availableSlots.toString());
        }
        return reassignment;
    }

    public static void scheduleTopologiesEvenly(Topologies topologies, Cluster cluster) {
        for (TopologyDetails topology : cluster.needsSchedulingTopologies()) {
            String topologyId = topology.getId();
            Map<ExecutorDetails, WorkerSlot> newAssignment = EvenScheduler.scheduleTopology(topology, cluster);
            HashMap nodePortToExecutors = Utils.reverseMap(newAssignment);
            for (Map.Entry entry : nodePortToExecutors.entrySet()) {
                WorkerSlot nodePort = (WorkerSlot)entry.getKey();
                List executors = (List)entry.getValue();
                cluster.assign(nodePort, topologyId, executors);
            }
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) {
    }

    @Override
    public void schedule(Topologies topologies, Cluster cluster) {
        EvenScheduler.scheduleTopologiesEvenly(topologies, cluster);
    }

    @Override
    public Map<String, Map<String, Double>> config() {
        return new HashMap<String, Map<String, Double>>();
    }
}

