/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import com.codahale.metrics.Meter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.apache.commons.io.IOUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.nimbus.TopoCache;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.shade.com.google.common.base.Joiner;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.apache.storm.zookeeper.ClientZookeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderListenerCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderListenerCallback.class);
    private static final String STORM_JAR_SUFFIX = "-stormjar.jar";
    private static final String STORM_CODE_SUFFIX = "-stormcode.ser";
    private static final String STORM_CONF_SUFFIX = "-stormconf.ser";
    private final Meter numGainedLeader;
    private final Meter numLostLeader;
    private final BlobStore blobStore;
    private final TopoCache tc;
    private final IStormClusterState clusterState;
    private final CuratorFramework zk;
    private final ILeaderElector leaderElector;
    private final Map conf;
    private final List<ACL> acls;
    private final int requeueDelayMs;

    public LeaderListenerCallback(Map conf, CuratorFramework zk, BlobStore blobStore, ILeaderElector leaderElector, TopoCache tc, IStormClusterState clusterState, List<ACL> acls, StormMetricsRegistry metricsRegistry) {
        this.blobStore = blobStore;
        this.tc = tc;
        this.clusterState = clusterState;
        this.zk = zk;
        this.leaderElector = leaderElector;
        this.conf = conf;
        this.acls = acls;
        this.numGainedLeader = metricsRegistry.registerMeter("nimbus:num-gained-leadership");
        this.numLostLeader = metricsRegistry.registerMeter("nimbus:num-lost-leadership");
        this.requeueDelayMs = ObjectReader.getInt(conf.get("nimbus.code.sync.freq.secs")) * 1000;
    }

    public void leaderCallBack() {
        this.numGainedLeader.mark();
        this.setUpNimbusInfo(this.acls);
        LOG.info("Sync remote assignments and id-info to local");
        this.clusterState.syncRemoteAssignments(null);
        this.clusterState.syncRemoteIds(null);
        this.clusterState.setAssignmentsBackendSynchronized();
        TreeSet<String> activeTopologyIds = new TreeSet<String>(ClientZookeeper.getChildren((CuratorFramework)this.zk, (String)"/storms", (boolean)false));
        Set<String> activeTopologyBlobKeys = this.populateTopologyBlobKeys(activeTopologyIds);
        Set<String> activeTopologyCodeKeys = this.filterTopologyCodeKeys(activeTopologyBlobKeys);
        HashSet allLocalBlobKeys = Sets.newHashSet((Iterator)this.blobStore.listKeys());
        Set<String> allLocalTopologyBlobKeys = this.filterTopologyBlobKeys(allLocalBlobKeys);
        Sets.SetView diffTopology = Sets.difference(activeTopologyBlobKeys, allLocalTopologyBlobKeys);
        LOG.info("active-topology-blobs [{}] local-topology-blobs [{}] diff-topology-blobs [{}]", new Object[]{this.generateJoinedString(activeTopologyIds), this.generateJoinedString(allLocalTopologyBlobKeys), this.generateJoinedString((Set<String>)diffTopology)});
        if (diffTopology.isEmpty()) {
            Set<String> activeTopologyDependencies = this.getTopologyDependencyKeys(activeTopologyCodeKeys);
            Sets.SetView diffDependencies = Sets.difference(activeTopologyDependencies, (Set)allLocalBlobKeys);
            LOG.info("active-topology-dependencies [{}] local-blobs [{}] diff-topology-dependencies [{}]", new Object[]{this.generateJoinedString(activeTopologyDependencies), this.generateJoinedString(allLocalBlobKeys), this.generateJoinedString((Set<String>)diffDependencies)});
            if (diffDependencies.isEmpty()) {
                LOG.info("Accepting leadership, all active topologies and corresponding dependencies found locally.");
                this.tc.clear();
            } else {
                LOG.info("Code for all active topologies is available locally, but some dependencies are not found locally, giving up leadership.");
                this.surrenderLeadership();
            }
        } else {
            LOG.info("code for all active topologies not available locally, giving up leadership.");
            this.surrenderLeadership();
        }
    }

    public void notLeaderCallback() {
        this.numLostLeader.mark();
        this.tc.clear();
    }

    private void setUpNimbusInfo(List<ACL> acls) {
        String leaderInfoPath = this.conf.get("storm.zookeeper.root") + "/leader-info";
        NimbusInfo nimbusInfo = NimbusInfo.fromConf((Map)this.conf);
        if (ClientZookeeper.existsNode((CuratorFramework)this.zk, (String)leaderInfoPath, (boolean)false)) {
            ClientZookeeper.setData((CuratorFramework)this.zk, (String)leaderInfoPath, (byte[])Utils.javaSerialize((Object)nimbusInfo));
        } else {
            ClientZookeeper.createNode((CuratorFramework)this.zk, (String)leaderInfoPath, (byte[])Utils.javaSerialize((Object)nimbusInfo), (CreateMode)CreateMode.PERSISTENT, acls);
        }
    }

    private String generateJoinedString(Set<String> activeTopologyIds) {
        return Joiner.on((String)",").join(activeTopologyIds);
    }

    private Set<String> populateTopologyBlobKeys(Set<String> activeTopologyIds) {
        TreeSet<String> activeTopologyBlobKeys = new TreeSet<String>();
        for (String activeTopologyId : activeTopologyIds) {
            activeTopologyBlobKeys.add(activeTopologyId + STORM_JAR_SUFFIX);
            activeTopologyBlobKeys.add(activeTopologyId + STORM_CODE_SUFFIX);
            activeTopologyBlobKeys.add(activeTopologyId + STORM_CONF_SUFFIX);
        }
        return activeTopologyBlobKeys;
    }

    private Set<String> filterTopologyBlobKeys(Set<String> blobKeys) {
        HashSet<String> topologyBlobKeys = new HashSet<String>();
        for (String blobKey : blobKeys) {
            if (!blobKey.endsWith(STORM_JAR_SUFFIX) && !blobKey.endsWith(STORM_CODE_SUFFIX) && !blobKey.endsWith(STORM_CONF_SUFFIX)) continue;
            topologyBlobKeys.add(blobKey);
        }
        return topologyBlobKeys;
    }

    private Set<String> filterTopologyCodeKeys(Set<String> blobKeys) {
        HashSet<String> topologyCodeKeys = new HashSet<String>();
        for (String blobKey : blobKeys) {
            if (!blobKey.endsWith(STORM_CODE_SUFFIX)) continue;
            topologyCodeKeys.add(blobKey);
        }
        return topologyCodeKeys;
    }

    private Set<String> getTopologyDependencyKeys(Set<String> activeTopologyCodeKeys) {
        TreeSet<String> activeTopologyDependencies = new TreeSet<String>();
        Subject subject = ReqContext.context().subject();
        for (String activeTopologyCodeKey : activeTopologyCodeKeys) {
            try {
                InputStreamWithMeta blob = this.blobStore.getBlob(activeTopologyCodeKey, subject);
                Throwable throwable = null;
                try {
                    byte[] blobContent = IOUtils.readFully((InputStream)blob, (int)new Long(blob.getFileLength()).intValue());
                    StormTopology stormCode = (StormTopology)Utils.deserialize((byte[])blobContent, StormTopology.class);
                    if (stormCode.is_set_dependency_jars()) {
                        activeTopologyDependencies.addAll(stormCode.get_dependency_jars());
                    }
                    if (!stormCode.is_set_dependency_artifacts()) continue;
                    activeTopologyDependencies.addAll(stormCode.get_dependency_artifacts());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (blob == null) continue;
                    if (throwable != null) {
                        try {
                            blob.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    blob.close();
                }
            }
            catch (IOException | AuthorizationException | KeyNotFoundException e) {
                LOG.error("Exception occurs while reading blob for key: " + activeTopologyCodeKey + ", exception: " + e, e);
                throw new RuntimeException("Exception occurs while reading blob for key: " + activeTopologyCodeKey + ", exception: " + e, e);
            }
        }
        return activeTopologyDependencies;
    }

    private void surrenderLeadership() {
        try {
            this.leaderElector.quitElectionFor(this.requeueDelayMs);
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime((Exception)e);
        }
    }
}

