/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.generated.SupervisorAssignments;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.scheduler.INodeAssignmentSentCallBack;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.SupervisorClient;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentDistributionService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentDistributionService.class);
    private ExecutorService service;
    private volatile boolean active = false;
    private Random random;
    private int threadsNum = 0;
    private int queueSize = 0;
    private volatile Map<Integer, LinkedBlockingQueue<NodeAssignments>> assignmentsQueue;
    private Map<String, Supervisor> localSupervisors;
    private Map conf;
    private boolean isLocalMode = false;
    private INodeAssignmentSentCallBack sendAssignmentCallback;

    public static AssignmentDistributionService getInstance(Map conf, INodeAssignmentSentCallBack callback) {
        AssignmentDistributionService service = new AssignmentDistributionService();
        service.prepare(conf, callback);
        return service;
    }

    public void prepare(Map conf, INodeAssignmentSentCallBack callBack) {
        int i;
        this.conf = conf;
        this.sendAssignmentCallback = callBack;
        this.random = new Random(47L);
        this.threadsNum = ObjectReader.getInt(conf.get("nimbus.assignments.service.threads"), (Integer)10);
        this.queueSize = ObjectReader.getInt(conf.get("nimbus.assignments.service.thread.queue.size"), (Integer)100);
        this.assignmentsQueue = new HashMap<Integer, LinkedBlockingQueue<NodeAssignments>>();
        for (i = 0; i < this.threadsNum; ++i) {
            this.assignmentsQueue.put(i, new LinkedBlockingQueue(this.queueSize));
        }
        this.service = Executors.newFixedThreadPool(this.threadsNum);
        this.active = true;
        for (i = 0; i < this.threadsNum; ++i) {
            this.service.submit(new DistributeTask(this, i));
        }
        this.localSupervisors = new HashMap<String, Supervisor>();
        if (ConfigUtils.isLocalMode((Map)conf)) {
            this.isLocalMode = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.active = false;
        this.service.shutdownNow();
        try {
            this.service.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to close assignments distribute service");
        }
        this.assignmentsQueue = null;
    }

    public void addAssignmentsForNode(String node, String host, Integer serverPort, SupervisorAssignments assignments, StormMetricsRegistry metricsRegistry) {
        try {
            if (serverPort == null) {
                LOG.warn("Discard an assignment distribution for node {} because server port info is missing.", (Object)node);
                return;
            }
            boolean success = this.nextQueue().offer(NodeAssignments.getInstance(node, host, serverPort, assignments, metricsRegistry), 5L, TimeUnit.SECONDS);
            if (!success) {
                LOG.warn("Discard an assignment distribution for node {} because the target sub queue is full.", (Object)node);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Add node assignments interrupted: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void addLocalSupervisor(Supervisor supervisor) {
        this.localSupervisors.put(supervisor.getId(), supervisor);
    }

    private Integer nextQueueId() {
        return this.random.nextInt(this.threadsNum);
    }

    private LinkedBlockingQueue<NodeAssignments> nextQueue() {
        return this.assignmentsQueue.get(this.nextQueueId());
    }

    private LinkedBlockingQueue<NodeAssignments> getQueueById(Integer queueIndex) {
        return this.assignmentsQueue.get(queueIndex);
    }

    public NodeAssignments nextAssignments(Integer queueIndex) throws InterruptedException {
        NodeAssignments target = null;
        while ((target = this.getQueueById(queueIndex).poll()) == null) {
            Time.sleep((long)100L);
        }
        return target;
    }

    public boolean isActive() {
        return this.active;
    }

    public Map getConf() {
        return this.conf;
    }

    static class DistributeTask
    implements Runnable {
        private AssignmentDistributionService service;
        private Integer queueIndex;

        DistributeTask(AssignmentDistributionService service, Integer index) {
            this.service = service;
            this.queueIndex = index;
        }

        @Override
        public void run() {
            while (this.service.isActive()) {
                try {
                    NodeAssignments nodeAssignments = this.service.nextAssignments(this.queueIndex);
                    this.sendAssignmentsToNode(nodeAssignments);
                }
                catch (InterruptedException e) {
                    if (this.service.isActive()) {
                        LOG.error("Get an unexpected interrupt when distributing assignments to node, {}", e.getCause());
                        continue;
                    }
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendAssignmentsToNode(NodeAssignments assignments) {
            if (this.service.isLocalMode) {
                Supervisor supervisor = (Supervisor)this.service.localSupervisors.get(assignments.getNode());
                if (supervisor != null) {
                    supervisor.sendSupervisorAssignments(assignments.getAssignments());
                    this.service.sendAssignmentCallback.nodeAssignmentSent(assignments.getNode(), true);
                    return;
                }
                LOG.error("Can not find node {} for assignments distribution", (Object)assignments.getNode());
                this.service.sendAssignmentCallback.nodeAssignmentSent(assignments.getNode(), false);
                throw new RuntimeException("null for node " + assignments.getNode() + " supervisor instance.");
            }
            try (SupervisorClient client = SupervisorClient.getConfiguredClient((Map)this.service.getConf(), (String)assignments.getHost(), (int)assignments.getServerPort());){
                try {
                    client.getIface().sendSupervisorAssignments(assignments.getAssignments());
                    this.service.sendAssignmentCallback.nodeAssignmentSent(assignments.getNode(), true);
                    return;
                }
                catch (Exception e) {
                    assignments.getMetricsRegistry().getMeter("nimbus:num-send-assignment-exceptions").mark();
                    LOG.error("Exception when trying to send assignments to node {}: {}", (Object)assignments.getNode(), (Object)e.getMessage());
                    this.service.sendAssignmentCallback.nodeAssignmentSent(assignments.getNode(), false);
                }
                return;
            }
            catch (Throwable e) {
                LOG.error("Exception to create supervisor client for node {}: {}", (Object)assignments.getNode(), (Object)e.getMessage());
            }
        }
    }

    static class NodeAssignments {
        private String node;
        private String host;
        private Integer serverPort;
        private SupervisorAssignments assignments;
        private StormMetricsRegistry metricsRegistry;

        private NodeAssignments(String node, String host, Integer serverPort, SupervisorAssignments assignments, StormMetricsRegistry metricsRegistry) {
            this.node = node;
            this.host = host;
            this.serverPort = serverPort;
            this.assignments = assignments;
            this.metricsRegistry = metricsRegistry;
        }

        public static NodeAssignments getInstance(String node, String host, Integer serverPort, SupervisorAssignments assignments, StormMetricsRegistry metricsRegistry) {
            return new NodeAssignments(node, host, serverPort, assignments, metricsRegistry);
        }

        public String getNode() {
            return this.node;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getServerPort() {
            return this.serverPort;
        }

        public SupervisorAssignments getAssignments() {
            return this.assignments;
        }

        public StormMetricsRegistry getMetricsRegistry() {
            return this.metricsRegistry;
        }
    }
}

