/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.supervisor.IAdvancedFSOps;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.localizer.BlobChangingCallback;
import org.apache.storm.localizer.LocalResource;
import org.apache.storm.localizer.LocalizedResource;
import org.apache.storm.localizer.LocalizedResourceRetentionSet;
import org.apache.storm.localizer.LocallyCachedBlob;
import org.apache.storm.localizer.LocallyCachedTopologyBlob;
import org.apache.storm.localizer.PortAndAssignment;
import org.apache.storm.localizer.PortAndAssignmentImpl;
import org.apache.storm.localizer.TimePortAndAssignment;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusLeaderNotFoundException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.WrappedKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLocalizer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncLocalizer.class);
    private static final CompletableFuture<Void> ALL_DONE_FUTURE = CompletableFuture.completedFuture(null);
    private static final int ATTEMPTS_INTERVAL_TIME = 100;
    private final Timer singleBlobLocalizationDuration;
    private final Timer blobCacheUpdateDuration;
    private final Timer blobLocalizationDuration;
    private final Meter numBlobUpdateVersionChanged;
    private final Meter localResourceFileNotFoundWhenReleasingSlot;
    protected final ConcurrentHashMap<String, ConcurrentHashMap<String, LocalizedResource>> userFiles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ConcurrentHashMap<String, LocalizedResource>> userArchives = new ConcurrentHashMap();
    private final boolean isLocalMode;
    private final ConcurrentHashMap<String, CompletableFuture<Void>> blobPending;
    private final Map<String, Object> conf;
    private final AdvancedFSOps fsOps;
    private final boolean symlinksDisabled;
    private final ConcurrentHashMap<String, LocallyCachedBlob> topologyBlobs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CompletableFuture<Void>> topologyBasicDownloaded = new ConcurrentHashMap();
    private final Path localBaseDir;
    private final int blobDownloadRetries;
    private final ScheduledExecutorService downloadExecService;
    private final ScheduledExecutorService taskExecService;
    private final long cacheCleanupPeriod;
    private final StormMetricsRegistry metricsRegistry;
    @VisibleForTesting
    protected long cacheTargetSize;

    @VisibleForTesting
    AsyncLocalizer(Map<String, Object> conf, AdvancedFSOps ops, String baseDir, StormMetricsRegistry metricsRegistry) throws IOException {
        this.conf = conf;
        this.singleBlobLocalizationDuration = metricsRegistry.registerTimer("supervisor:single-blob-localization-duration");
        this.blobCacheUpdateDuration = metricsRegistry.registerTimer("supervisor:blob-cache-update-duration");
        this.blobLocalizationDuration = metricsRegistry.registerTimer("supervisor:blob-localization-duration");
        this.numBlobUpdateVersionChanged = metricsRegistry.registerMeter("supervisor:num-blob-update-version-changed");
        this.localResourceFileNotFoundWhenReleasingSlot = metricsRegistry.registerMeter("supervisor:local-resource-file-not-found-when-releasing-slot");
        this.metricsRegistry = metricsRegistry;
        this.isLocalMode = ConfigUtils.isLocalMode(conf);
        this.fsOps = ops;
        this.localBaseDir = Paths.get(baseDir, new String[0]);
        this.cacheTargetSize = ObjectReader.getInt((Object)conf.get("supervisor.localizer.cache.target.size.mb"), (Integer)10240).longValue() << 20;
        this.cacheCleanupPeriod = ObjectReader.getInt((Object)conf.get("supervisor.localizer.cleanup.interval.ms"), (Integer)30000).longValue();
        this.blobDownloadRetries = ObjectReader.getInt((Object)conf.get("supervisor.blobstore.download.max_retries"), (Integer)3);
        int downloadThreadPoolSize = ObjectReader.getInt((Object)conf.get("supervisor.blobstore.download.thread.count"), (Integer)5);
        this.downloadExecService = Executors.newScheduledThreadPool(downloadThreadPoolSize, new ThreadFactoryBuilder().setNameFormat("AsyncLocalizer Download Executor - %d").build());
        this.taskExecService = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("AsyncLocalizer Task Executor - %d").build());
        this.reconstructLocalizedResources();
        this.symlinksDisabled = (Boolean)conf.getOrDefault("storm.disable.symlinks", false);
        this.blobPending = new ConcurrentHashMap();
    }

    public AsyncLocalizer(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) throws IOException {
        this(conf, AdvancedFSOps.make(conf), ConfigUtils.supervisorLocalDir(conf), metricsRegistry);
    }

    @VisibleForTesting
    LocallyCachedBlob getTopoJar(String topologyId, String owner) {
        return this.topologyBlobs.computeIfAbsent(ConfigUtils.masterStormJarKey((String)topologyId), tjk -> {
            try {
                return new LocallyCachedTopologyBlob(topologyId, this.isLocalMode, this.conf, this.fsOps, LocallyCachedTopologyBlob.TopologyBlobType.TOPO_JAR, owner, this.metricsRegistry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    LocallyCachedBlob getTopoCode(String topologyId, String owner) {
        return this.topologyBlobs.computeIfAbsent(ConfigUtils.masterStormCodeKey((String)topologyId), tck -> {
            try {
                return new LocallyCachedTopologyBlob(topologyId, this.isLocalMode, this.conf, this.fsOps, LocallyCachedTopologyBlob.TopologyBlobType.TOPO_CODE, owner, this.metricsRegistry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    LocallyCachedBlob getTopoConf(String topologyId, String owner) {
        return this.topologyBlobs.computeIfAbsent(ConfigUtils.masterStormConfKey((String)topologyId), tck -> {
            try {
                return new LocallyCachedTopologyBlob(topologyId, this.isLocalMode, this.conf, this.fsOps, LocallyCachedTopologyBlob.TopologyBlobType.TOPO_CONF, owner, this.metricsRegistry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private LocalizedResource getUserArchive(String user, String key) {
        assert (user != null) : "All user archives require a user present";
        ConcurrentMap keyToResource = this.userArchives.computeIfAbsent(user, u -> new ConcurrentHashMap());
        return keyToResource.computeIfAbsent(key, k -> new LocalizedResource(key, this.localBaseDir, true, (IAdvancedFSOps)this.fsOps, this.conf, user, this.metricsRegistry));
    }

    private LocalizedResource getUserFile(String user, String key) {
        assert (user != null) : "All user archives require a user present";
        ConcurrentMap keyToResource = this.userFiles.computeIfAbsent(user, u -> new ConcurrentHashMap());
        return keyToResource.computeIfAbsent(key, k -> new LocalizedResource(key, this.localBaseDir, false, (IAdvancedFSOps)this.fsOps, this.conf, user, this.metricsRegistry));
    }

    public CompletableFuture<Void> requestDownloadTopologyBlobs(LocalAssignment assignment, int port, BlobChangingCallback cb) throws IOException {
        TimePortAndAssignment pna = new TimePortAndAssignment(new PortAndAssignmentImpl(port, assignment), this.blobLocalizationDuration);
        String topologyId = pna.getToplogyId();
        CompletableFuture<Void> baseBlobs = this.requestDownloadBaseTopologyBlobs(pna, cb);
        return baseBlobs.thenComposeAsync(v -> this.blobPending.compute(topologyId, (tid, old) -> {
            CompletableFuture<Void> ret = old;
            if (ret == null) {
                ret = CompletableFuture.supplyAsync(new DownloadBlobs(pna, cb), this.taskExecService);
            } else {
                try {
                    this.addReferencesToBlobs(pna, cb);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    pna.complete();
                }
            }
            LOG.debug("Reserved blobs {} {}", (Object)topologyId, ret);
            return ret;
        }));
    }

    @VisibleForTesting
    CompletableFuture<Void> requestDownloadBaseTopologyBlobs(PortAndAssignment pna, BlobChangingCallback cb) {
        String topologyId = pna.getToplogyId();
        LocallyCachedBlob topoJar = this.getTopoJar(topologyId, pna.getAssignment().get_owner());
        topoJar.addReference(pna, cb);
        LocallyCachedBlob topoCode = this.getTopoCode(topologyId, pna.getAssignment().get_owner());
        topoCode.addReference(pna, cb);
        LocallyCachedBlob topoConf = this.getTopoConf(topologyId, pna.getAssignment().get_owner());
        topoConf.addReference(pna, cb);
        return this.topologyBasicDownloaded.computeIfAbsent(topologyId, tid -> this.downloadOrUpdate(topoJar, topoCode, topoConf));
    }

    private CompletableFuture<Void> downloadOrUpdate(LocallyCachedBlob ... blobs) {
        return this.downloadOrUpdate(Arrays.asList(blobs));
    }

    private CompletableFuture<Void> downloadOrUpdate(Collection<? extends LocallyCachedBlob> blobs) {
        CompletableFuture[] all = new CompletableFuture[blobs.size()];
        int i = 0;
        for (LocallyCachedBlob locallyCachedBlob : blobs) {
            all[i] = CompletableFuture.runAsync(() -> {
                LOG.debug("STARTING download of {}", (Object)blob);
                try (ClientBlobStore blobStore = this.getClientBlobStore();){
                    boolean done = false;
                    long failures = 0L;
                    while (!done) {
                        try {
                            LocallyCachedBlob locallyCachedBlob = blob;
                            synchronized (locallyCachedBlob) {
                                if (blob.isUsed()) {
                                    long remoteVersion;
                                    long localVersion = blob.getLocalVersion();
                                    if (localVersion != (remoteVersion = blob.getRemoteVersion(blobStore)) || !blob.isFullyDownloaded()) {
                                        if (blob.isFullyDownloaded()) {
                                            this.numBlobUpdateVersionChanged.mark();
                                        }
                                        Timer.Context t = this.singleBlobLocalizationDuration.time();
                                        try {
                                            long newVersion = blob.fetchUnzipToTemp(blobStore);
                                            blob.informReferencesAndCommitNewVersion(newVersion);
                                            t.stop();
                                        }
                                        finally {
                                            blob.cleanupOrphanedData();
                                        }
                                    }
                                } else {
                                    LOG.debug("Skipping update of unused blob {}", (Object)blob);
                                }
                            }
                            done = true;
                        }
                        catch (Exception e) {
                            if (++failures > (long)this.blobDownloadRetries) {
                                throw new RuntimeException("Could not download...", e);
                            }
                            LOG.warn("Failed to download blob {} will try again in {} ms", new Object[]{blob, 100, e});
                            Utils.sleep((long)100L);
                        }
                    }
                }
                LOG.debug("FINISHED download of {}", (Object)blob);
            }, this.downloadExecService);
            ++i;
        }
        return CompletableFuture.allOf(all);
    }

    @VisibleForTesting
    void updateBlobs() {
        try (Timer.Context t = this.blobCacheUpdateDuration.time();){
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            futures.add(this.downloadOrUpdate(this.topologyBlobs.values()));
            if (this.symlinksDisabled) {
                LOG.warn("symlinks are disabled so blobs cannot be downloaded.");
            } else {
                for (ConcurrentMap concurrentMap : this.userArchives.values()) {
                    futures.add(this.downloadOrUpdate(concurrentMap.values()));
                }
                for (ConcurrentMap concurrentMap : this.userFiles.values()) {
                    futures.add(this.downloadOrUpdate(concurrentMap.values()));
                }
            }
            for (CompletableFuture completableFuture : futures) {
                try {
                    completableFuture.get();
                }
                catch (Exception e) {
                    if (Utils.exceptionCauseIsInstanceOf(TTransportException.class, (Throwable)e)) {
                        LOG.error("Network error while updating blobs, will retry again later", (Throwable)e);
                        continue;
                    }
                    if (Utils.exceptionCauseIsInstanceOf(NimbusLeaderNotFoundException.class, (Throwable)e)) {
                        LOG.error("Nimbus unavailable to update blobs, will retry again later", (Throwable)e);
                        continue;
                    }
                    LOG.error("Could not update blob, will retry again later", (Throwable)e);
                }
            }
        }
    }

    public void start() {
        this.taskExecService.scheduleWithFixedDelay(this::updateBlobs, 30L, 30L, TimeUnit.SECONDS);
        LOG.debug("Scheduling cleanup every {} millis", (Object)this.cacheCleanupPeriod);
        this.taskExecService.scheduleAtFixedRate(this::cleanup, this.cacheCleanupPeriod, this.cacheCleanupPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws InterruptedException {
        this.downloadExecService.shutdown();
        this.taskExecService.shutdown();
    }

    private List<LocalResource> getLocalResources(PortAndAssignment pna) throws IOException {
        List<LocalResource> tmp;
        String topologyId = pna.getToplogyId();
        Map topoConf = ConfigUtils.readSupervisorStormConf(this.conf, (String)topologyId);
        Map blobstoreMap = (Map)topoConf.get("topology.blobstore.map");
        ArrayList<LocalResource> ret = new ArrayList<LocalResource>();
        if (blobstoreMap != null && (tmp = SupervisorUtils.blobstoreMapToLocalresources(blobstoreMap)) != null) {
            ret.addAll(tmp);
        }
        StormTopology stormCode = ConfigUtils.readSupervisorTopology(this.conf, (String)topologyId, (AdvancedFSOps)this.fsOps);
        ArrayList dependencies = new ArrayList();
        if (stormCode.is_set_dependency_jars()) {
            dependencies.addAll(stormCode.get_dependency_jars());
        }
        if (stormCode.is_set_dependency_artifacts()) {
            dependencies.addAll(stormCode.get_dependency_artifacts());
        }
        for (String dependency : dependencies) {
            ret.add(new LocalResource(dependency, false, true));
        }
        return ret;
    }

    @VisibleForTesting
    void addReferencesToBlobs(PortAndAssignment pna, BlobChangingCallback cb) throws IOException, KeyNotFoundException, AuthorizationException {
        List<LocalResource> localResourceList = this.getLocalResources(pna);
        if (!localResourceList.isEmpty()) {
            this.getBlobs(localResourceList, pna, cb);
        }
    }

    public void recoverRunningTopology(LocalAssignment currentAssignment, int port, BlobChangingCallback cb) throws IOException {
        PortAndAssignmentImpl pna = new PortAndAssignmentImpl(port, currentAssignment);
        String topologyId = pna.getToplogyId();
        LocallyCachedBlob topoJar = this.getTopoJar(topologyId, pna.getAssignment().get_owner());
        topoJar.addReference(pna, cb);
        LocallyCachedBlob topoCode = this.getTopoCode(topologyId, pna.getAssignment().get_owner());
        topoCode.addReference(pna, cb);
        LocallyCachedBlob topoConf = this.getTopoConf(topologyId, pna.getAssignment().get_owner());
        topoConf.addReference(pna, cb);
        CompletableFuture localResource = this.blobPending.computeIfAbsent(topologyId, tid -> ALL_DONE_FUTURE);
        try {
            this.addReferencesToBlobs(pna, cb);
        }
        catch (AuthorizationException | KeyNotFoundException e) {
            LOG.error("Could not recover all blob references for {}", (Object)pna);
        }
        LOG.debug("Recovered blobs {} {}", (Object)topologyId, (Object)localResource);
    }

    public void releaseSlotFor(LocalAssignment assignment, int port) throws IOException {
        List<LocalResource> localResources;
        LocallyCachedBlob topoConfBlob;
        LocallyCachedBlob topoCode;
        PortAndAssignmentImpl pna = new PortAndAssignmentImpl(port, assignment);
        String topologyId = assignment.get_topology_id();
        LOG.debug("Releasing slot for {} {}", (Object)topologyId, (Object)port);
        String topoJarKey = ConfigUtils.masterStormJarKey((String)topologyId);
        String topoCodeKey = ConfigUtils.masterStormCodeKey((String)topologyId);
        String topoConfKey = ConfigUtils.masterStormConfKey((String)topologyId);
        LocallyCachedBlob topoJar = this.topologyBlobs.get(topoJarKey);
        if (topoJar != null) {
            topoJar.removeReference(pna);
        }
        if ((topoCode = this.topologyBlobs.get(topoCodeKey)) != null) {
            topoCode.removeReference(pna);
        }
        if ((topoConfBlob = this.topologyBlobs.get(topoConfKey)) != null) {
            topoConfBlob.removeReference(pna);
        }
        try {
            localResources = this.getLocalResources(pna);
        }
        catch (IOException e) {
            LOG.info("Port and assignment info: {}", (Object)pna);
            if (e instanceof FileNotFoundException) {
                this.localResourceFileNotFoundWhenReleasingSlot.mark();
                LOG.warn("Local base blobs have not been downloaded yet. ", (Throwable)e);
                return;
            }
            LOG.error("Unable to read local file. ", (Throwable)e);
            throw e;
        }
        for (LocalResource lr : localResources) {
            this.removeBlobReference(lr.getBlobName(), pna, lr.shouldUncompress());
        }
    }

    @VisibleForTesting
    File getLocalUserDir(String userName) {
        return LocalizedResource.getLocalUserDir(this.localBaseDir, userName).toFile();
    }

    @VisibleForTesting
    File getLocalUserFileCacheDir(String userName) {
        return LocalizedResource.getLocalUserFileCacheDir(this.localBaseDir, userName).toFile();
    }

    private void recoverLocalizedArchivesForUser(String user) throws IOException {
        for (String key : LocalizedResource.getLocalizedArchiveKeys(this.localBaseDir, user)) {
            this.getUserArchive(user, key);
        }
    }

    private void recoverLocalizedFilesForUser(String user) throws IOException {
        for (String key : LocalizedResource.getLocalizedFileKeys(this.localBaseDir, user)) {
            this.getUserFile(user, key);
        }
    }

    private void reconstructLocalizedResources() {
        try {
            LOG.info("Reconstruct localized resources");
            Collection<String> users = LocalizedResource.getLocalizedUsers(this.localBaseDir);
            if (users != null && !users.isEmpty()) {
                for (String user : users) {
                    LOG.debug("reconstructing resources owned by {}", (Object)user);
                    this.recoverLocalizedFilesForUser(user);
                    this.recoverLocalizedArchivesForUser(user);
                }
            } else {
                LOG.debug("No left over resources found for any user");
            }
        }
        catch (Exception e) {
            LOG.error("ERROR reconstructing localized resources", (Throwable)e);
        }
    }

    void removeBlobReference(String key, PortAndAssignment pna, boolean uncompress) {
        ConcurrentMap lrsrcSet;
        String user = pna.getOwner();
        String topo = pna.getToplogyId();
        ConcurrentMap concurrentMap = lrsrcSet = uncompress ? (ConcurrentMap)this.userArchives.get(user) : (ConcurrentMap)this.userFiles.get(user);
        if (lrsrcSet != null) {
            LocalizedResource lrsrc = (LocalizedResource)lrsrcSet.get(key);
            if (lrsrc != null) {
                LOG.debug("removing blob reference to: {} for topo: {}", (Object)key, (Object)topo);
                lrsrc.removeReference(pna);
            } else {
                LOG.warn("trying to remove non-existent blob, key: " + key + " for user: " + user + " topo: " + topo);
            }
        } else {
            LOG.warn("trying to remove blob for non-existent resource set for user: " + user + " key: " + key + " topo: " + topo);
        }
    }

    protected ClientBlobStore getClientBlobStore() {
        return ServerUtils.getClientBlobStoreForSupervisor(this.conf);
    }

    List<LocalizedResource> getBlobs(List<LocalResource> localResources, PortAndAssignment pna, BlobChangingCallback cb) throws AuthorizationException, KeyNotFoundException, IOException {
        if (((Boolean)this.conf.getOrDefault("storm.disable.symlinks", false)).booleanValue()) {
            throw new WrappedKeyNotFoundException("symlinks are disabled so blobs cannot be downloaded.");
        }
        String user = pna.getOwner();
        ArrayList<LocalizedResource> results = new ArrayList<LocalizedResource>();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        try {
            for (LocalResource localResource : localResources) {
                String key = localResource.getBlobName();
                boolean uncompress = localResource.shouldUncompress();
                LocalizedResource lrsrc = uncompress ? this.getUserArchive(user, key) : this.getUserFile(user, key);
                LOG.debug("fetching blob: {}", (Object)key);
                lrsrc.addReference(pna, localResource.needsCallback() ? cb : null);
                futures.add(this.downloadOrUpdate(lrsrc));
                results.add(lrsrc);
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        catch (ExecutionException e) {
            Utils.unwrapAndThrow(AuthorizationException.class, (Throwable)e);
            Utils.unwrapAndThrow(KeyNotFoundException.class, (Throwable)e);
            throw new IOException("Error getting blobs", e);
        }
        catch (RejectedExecutionException re) {
            throw new IOException("RejectedExecutionException: ", re);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted Exception", ie);
        }
        return results;
    }

    private void forEachTopologyDistDir(ConsumePathAndId consumer) throws IOException {
        Path stormCodeRoot = Paths.get(ConfigUtils.supervisorStormDistRoot(this.conf), new String[0]);
        if (Files.exists(stormCodeRoot, new LinkOption[0]) && Files.isDirectory(stormCodeRoot, new LinkOption[0])) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(stormCodeRoot);){
                for (Path child : children) {
                    if (!Files.isDirectory(child, new LinkOption[0])) continue;
                    String topologyId = child.getFileName().toString();
                    consumer.accept(child, topologyId);
                }
            }
        }
    }

    @VisibleForTesting
    void cleanup() {
        try {
            LocalizedResourceRetentionSet toClean = new LocalizedResourceRetentionSet(this.cacheTargetSize);
            for (Map.Entry<String, ConcurrentHashMap<String, LocalizedResource>> entry : this.userArchives.entrySet()) {
                toClean.addResources((ConcurrentMap<String, ? extends LocallyCachedBlob>)entry.getValue());
                LOG.debug("Resources to be cleaned after adding {} archives : {}", (Object)entry.getKey(), (Object)toClean);
            }
            for (Map.Entry<String, ConcurrentHashMap<String, LocalizedResource>> entry : this.userFiles.entrySet()) {
                toClean.addResources((ConcurrentMap<String, ? extends LocallyCachedBlob>)entry.getValue());
                LOG.debug("Resources to be cleaned after adding {} files : {}", (Object)entry.getKey(), (Object)toClean);
            }
            toClean.addResources(this.topologyBlobs);
            Throwable throwable = null;
            try (ClientBlobStore store = this.getClientBlobStore();){
                toClean.cleanup(store);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HashSet<String> safeTopologyIds = new HashSet<String>();
            for (String blobKey : this.topologyBlobs.keySet()) {
                safeTopologyIds.add(ConfigUtils.getIdFromBlobKey((String)blobKey));
            }
            this.topologyBasicDownloaded.keySet().removeIf(topoId -> !safeTopologyIds.contains(topoId));
            this.blobPending.keySet().removeIf(topoId -> !safeTopologyIds.contains(topoId));
            try {
                this.forEachTopologyDistDir((p, topologyId) -> {
                    if (!safeTopologyIds.contains(topologyId)) {
                        this.fsOps.deleteIfExists(p.toFile());
                    }
                });
            }
            catch (Exception exception) {
                LOG.error("Could not read topology directories for cleanup", (Throwable)exception);
            }
            LOG.debug("Resource cleanup: {}", (Object)toClean);
            HashSet hashSet = new HashSet(this.userArchives.keySet());
            hashSet.addAll(this.userFiles.keySet());
            for (String user : hashSet) {
                ConcurrentMap filesForUser = this.userFiles.get(user);
                ConcurrentMap archivesForUser = this.userArchives.get(user);
                if (filesForUser != null && filesForUser.size() != 0 || archivesForUser != null && archivesForUser.size() != 0) continue;
                LOG.debug("removing empty set: {}", (Object)user);
                try {
                    LocalizedResource.completelyRemoveUnusedUser(this.localBaseDir, user);
                    this.userFiles.remove(user);
                    this.userArchives.remove(user);
                }
                catch (IOException e) {
                    LOG.error("Error trying to delete cached user files", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("AsyncLocalizer cleanup failure", (Throwable)ex);
        }
        catch (Error error) {
            LOG.error("AsyncLocalizer cleanup failure", (Throwable)error);
            Utils.exitProcess((int)20, (String)"AsyncLocalizer cleanup failure");
        }
    }

    private class DownloadBlobs
    implements Supplier<Void> {
        private final PortAndAssignment pna;
        private final BlobChangingCallback cb;

        DownloadBlobs(PortAndAssignment pna, BlobChangingCallback cb) {
            this.pna = pna;
            this.cb = cb;
        }

        @Override
        public Void get() {
            try {
                String topologyId = this.pna.getToplogyId();
                String topoOwner = this.pna.getOwner();
                String stormroot = ConfigUtils.supervisorStormDistRoot((Map)AsyncLocalizer.this.conf, (String)topologyId);
                Map topoConf = ConfigUtils.readSupervisorStormConf((Map)AsyncLocalizer.this.conf, (String)topologyId);
                Map blobstoreMap = (Map)topoConf.get("topology.blobstore.map");
                List localResourceList = AsyncLocalizer.this.getLocalResources(this.pna);
                if (!localResourceList.isEmpty()) {
                    File userDir = AsyncLocalizer.this.getLocalUserFileCacheDir(topoOwner);
                    if (!AsyncLocalizer.this.fsOps.fileExists(userDir)) {
                        AsyncLocalizer.this.fsOps.forceMkdir(userDir);
                    }
                    List<LocalizedResource> localizedResources = AsyncLocalizer.this.getBlobs(localResourceList, this.pna, this.cb);
                    AsyncLocalizer.this.fsOps.setupBlobPermissions(userDir, topoOwner);
                    if (!AsyncLocalizer.this.symlinksDisabled) {
                        for (LocalizedResource localizedResource : localizedResources) {
                            Map blobInfo;
                            String keyName = localizedResource.getKey();
                            File rsrcFilePath = localizedResource.getCurrentSymlinkPath().toFile();
                            String symlinkName = null;
                            symlinkName = blobstoreMap != null ? ((blobInfo = (Map)blobstoreMap.get(keyName)) != null && blobInfo.containsKey("localname") ? (String)blobInfo.get("localname") : keyName) : keyName;
                            AsyncLocalizer.this.fsOps.createSymlink(new File(stormroot, symlinkName), rsrcFilePath);
                        }
                    }
                }
                this.pna.complete();
                return null;
            }
            catch (Exception e) {
                LOG.warn("Caught Exception While Downloading (rethrowing)... ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static interface ConsumePathAndId {
        public void accept(Path var1, String var2) throws IOException;
    }
}

