/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.SupervisorInfo;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResources;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorHeartbeat
implements Runnable {
    private final IStormClusterState stormClusterState;
    private final String supervisorId;
    private final Map<String, Object> conf;
    private final Supervisor supervisor;
    public static final Logger LOG = LoggerFactory.getLogger(SupervisorHeartbeat.class);

    public SupervisorHeartbeat(Map<String, Object> conf, Supervisor supervisor) {
        this.stormClusterState = supervisor.getStormClusterState();
        this.supervisorId = supervisor.getId();
        this.supervisor = supervisor;
        this.conf = conf;
    }

    private Map<String, SupervisorInfo> buildSupervisorInfo(Map<String, Object> conf, Supervisor supervisor, Map<String, Object> validatedNumaMap) {
        List metaDatas = (List)supervisor.getiSupervisor().getMetadata();
        List<Long> allPortList = new ArrayList<Long>();
        if (metaDatas != null) {
            for (Object data : metaDatas) {
                Integer port = ObjectReader.getInt(data);
                if (port == null) continue;
                allPortList.add(port.longValue());
            }
        }
        List<Long> allUsedPorts = new ArrayList<Long>();
        allUsedPorts.addAll(supervisor.getCurrAssignment().get().keySet());
        Map<String, Double> totalSupervisorResources = this.mkSupervisorCapacities(conf);
        NormalizedResourceOffer totalSupervisorNormalizedResources = new NormalizedResourceOffer(totalSupervisorResources);
        HashMap<String, SupervisorInfo> result = new HashMap<String, SupervisorInfo>();
        if (validatedNumaMap != null) {
            for (Map.Entry<String, Object> numaMapEntry : validatedNumaMap.entrySet()) {
                SupervisorInfo supervisorInfo = new SupervisorInfo();
                supervisorInfo.set_time_secs((long)Time.currentTimeSecs());
                supervisorInfo.set_hostname(supervisor.getHostName());
                supervisorInfo.set_assignment_id(supervisor.getAssignmentId() + "-numa-" + numaMapEntry.getKey());
                supervisorInfo.set_server_port(supervisor.getThriftServerPort());
                Map numaMap = (Map)numaMapEntry.getValue();
                List numaPortList = ((List)numaMap.get("numa.ports")).stream().map(e -> e.longValue()).collect(Collectors.toList());
                List usedNumaPorts = ListUtils.intersection(numaPortList, allUsedPorts);
                supervisorInfo.set_used_ports(usedNumaPorts);
                supervisorInfo.set_meta(numaPortList);
                allPortList = ListUtils.subtract(allPortList, numaPortList);
                allUsedPorts = ListUtils.subtract(allUsedPorts, (List)usedNumaPorts);
                supervisorInfo.set_scheduler_meta((Map)conf.get("supervisor.scheduler.meta"));
                supervisorInfo.set_uptime_secs((long)supervisor.getUpTime().upTime());
                supervisorInfo.set_version(supervisor.getStormVersion());
                Map<String, Double> supervisorCapacitiesFromNumaMap = this.mkSupervisorCapacitiesFromNumaMap(numaMap);
                NormalizedResourceOffer numaNormalizedResources = new NormalizedResourceOffer(supervisorCapacitiesFromNumaMap);
                totalSupervisorNormalizedResources.remove(numaNormalizedResources);
                supervisorInfo.set_resources_map(supervisorCapacitiesFromNumaMap);
                result.put(supervisor.getId() + "-numa-" + numaMapEntry.getKey(), supervisorInfo);
            }
        }
        if (totalSupervisorNormalizedResources.getTotalCpu() > 0.0 && totalSupervisorNormalizedResources.getTotalMemoryMb() > 0.0 && !allPortList.isEmpty()) {
            SupervisorInfo supervisorInfo = new SupervisorInfo();
            supervisorInfo.set_time_secs((long)Time.currentTimeSecs());
            supervisorInfo.set_hostname(supervisor.getHostName());
            supervisorInfo.set_assignment_id(supervisor.getAssignmentId());
            supervisorInfo.set_server_port(supervisor.getThriftServerPort());
            supervisorInfo.set_used_ports(allUsedPorts);
            supervisorInfo.set_meta(allPortList);
            supervisorInfo.set_scheduler_meta((Map)conf.get("supervisor.scheduler.meta"));
            supervisorInfo.set_uptime_secs((long)supervisor.getUpTime().upTime());
            supervisorInfo.set_version(supervisor.getStormVersion());
            supervisorInfo.set_resources_map(totalSupervisorNormalizedResources.toNormalizedMap());
            result.put(supervisor.getId(), supervisorInfo);
        }
        return result;
    }

    private Map<String, Double> mkSupervisorCapacitiesFromNumaMap(Map<String, Object> numaMap) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        ret.put("supervisor.cpu.capacity", Double.valueOf(((List)numaMap.get("numa.cores")).size() * 100));
        ret.put("supervisor.memory.capacity.mb", Double.valueOf(((Integer)numaMap.get("numa.memory.mb")).intValue()));
        ret.putAll(numaMap.getOrDefault("numa.generic.resources.map", Collections.emptyMap()));
        return NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(ret);
    }

    private Map<String, Double> mkSupervisorCapacities(Map<String, Object> conf) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        Double mem = ObjectReader.getDouble((Object)conf.get("supervisor.memory.capacity.mb"), (Double)4096.0);
        ret.put("supervisor.memory.capacity.mb", mem);
        Double cpu = ObjectReader.getDouble((Object)conf.get("supervisor.cpu.capacity"), (Double)400.0);
        ret.put("supervisor.cpu.capacity", cpu);
        Map rawResourcesMap = conf.getOrDefault("supervisor.resources.map", Collections.emptyMap());
        for (Map.Entry stringNumberEntry : rawResourcesMap.entrySet()) {
            ret.put((String)stringNumberEntry.getKey(), ((Number)stringNumberEntry.getValue()).doubleValue());
        }
        LOG.debug(NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(ret).toString());
        return NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(ret);
    }

    @Override
    public void run() {
        Map<String, Object> validatedNumaMap = SupervisorUtils.getNumaMap(this.conf);
        Map<String, SupervisorInfo> supervisorInfoList = this.buildSupervisorInfo(this.conf, this.supervisor, validatedNumaMap);
        for (Map.Entry<String, SupervisorInfo> supervisorInfoEntry : supervisorInfoList.entrySet()) {
            this.stormClusterState.supervisorHeartbeat(supervisorInfoEntry.getKey(), supervisorInfoEntry.getValue());
        }
    }
}

