/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.generated.SettableBlobMeta;

public class LocalFsBlobStoreFile
extends BlobStoreFile {
    private final String key;
    private final boolean isTmp;
    private final File path;
    private final boolean mustBeNew;
    private Long modTime = null;
    private SettableBlobMeta meta;

    public LocalFsBlobStoreFile(File base, String name) {
        if ("data".equals(name)) {
            this.isTmp = false;
        } else {
            Matcher m = TMP_NAME_PATTERN.matcher(name);
            if (!m.matches()) {
                throw new IllegalArgumentException("File name does not match '" + name + "' !~ " + TMP_NAME_PATTERN);
            }
            this.isTmp = true;
        }
        this.key = base.getName();
        this.path = new File(base, name);
        this.mustBeNew = false;
    }

    public LocalFsBlobStoreFile(File base, boolean isTmp, boolean mustBeNew) {
        this.key = base.getName();
        this.isTmp = isTmp;
        this.mustBeNew = mustBeNew;
        this.path = this.isTmp ? new File(base, System.currentTimeMillis() + ".tmp") : new File(base, "data");
    }

    public void delete() throws IOException {
        this.path.delete();
    }

    public boolean isTmp() {
        return this.isTmp;
    }

    public String getKey() {
        return this.key;
    }

    public long getModTime() throws IOException {
        if (this.modTime == null) {
            this.modTime = this.path.lastModified();
        }
        return this.modTime;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isTmp()) {
            throw new IllegalStateException("Cannot read from a temporary part file.");
        }
        return new FileInputStream(this.path);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        boolean success = false;
        try {
            success = this.path.createNewFile();
        }
        catch (IOException e) {
            this.path.getParentFile().mkdirs();
            success = this.path.createNewFile();
        }
        if (!success) {
            throw new IOException(this.path + " already exists");
        }
        return new FileOutputStream(this.path);
    }

    public void commit() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        File dest = new File(this.path.getParentFile(), "data");
        if (this.mustBeNew) {
            Files.move(this.path.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE);
        } else {
            Files.move(this.path.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void cancel() throws IOException {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only write to a temporary part file.");
        }
        this.delete();
    }

    public SettableBlobMeta getMetadata() {
        return this.meta;
    }

    public void setMetadata(SettableBlobMeta meta) {
        this.meta = meta;
    }

    public String toString() {
        return this.path + ":" + (this.isTmp ? "tmp" : "data") + ":" + this.key;
    }

    public long getFileLength() {
        return this.path.length();
    }
}

