/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.listener;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AddIndexEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterIndexEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropIndexEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotificationListener
extends MetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbNotificationListener.class.getName());
    private static CleanerThread cleaner = null;
    private HiveConf hiveConf;
    private MessageFactory msgFactory;

    private synchronized void init(HiveConf conf) throws MetaException {
        if (cleaner == null) {
            cleaner = new CleanerThread(conf, RawStoreProxy.getProxy((HiveConf)conf, (Configuration)conf, (String)conf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL), (int)999999));
            cleaner.start();
        }
    }

    public DbNotificationListener(Configuration config) throws MetaException {
        super(config);
        this.hiveConf = (HiveConf)config;
        this.init(this.hiveConf);
        this.msgFactory = MessageFactory.getInstance();
    }

    public void onConfigChange(ConfigChangeEvent tableEvent) throws MetaException {
        String key = tableEvent.getKey();
        if (key.equals(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.toString())) {
            this.hiveConf.set(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.name(), tableEvent.getNewValue());
            cleaner.setTimeToLive(this.hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_TABLE.toString(), this.msgFactory.buildCreateTableMessage(t, (Iterator)new FileIterator(t.getSd().getLocation())).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_TABLE.toString(), this.msgFactory.buildDropTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        Table before = tableEvent.getOldTable();
        Table after = tableEvent.getNewTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_TABLE.toString(), this.msgFactory.buildAlterTableMessage(before, after).toString());
        event.setDbName(after.getDbName());
        event.setTableName(after.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        String msg = this.msgFactory.buildAddPartitionMessage(t, partitionEvent.getPartitionIterator(), (Iterator)new PartitionFilesIterator(partitionEvent.getPartitionIterator(), t)).toString();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PARTITION.toString(), msg);
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_PARTITION.toString(), this.msgFactory.buildDropPartitionMessage(t, partitionEvent.getPartitionIterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        Partition before = partitionEvent.getOldPartition();
        Partition after = partitionEvent.getNewPartition();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_PARTITION.toString(), this.msgFactory.buildAlterPartitionMessage(partitionEvent.getTable(), before, after).toString());
        event.setDbName(before.getDbName());
        event.setTableName(before.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_DATABASE.toString(), this.msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_DATABASE.toString(), this.msgFactory.buildDropDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onCreateFunction(CreateFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_FUNCTION.toString(), this.msgFactory.buildCreateFunctionMessage(fn).toString());
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onDropFunction(DropFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_FUNCTION.toString(), this.msgFactory.buildDropFunctionMessage(fn).toString());
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onAddIndex(AddIndexEvent indexEvent) throws MetaException {
        Index index = indexEvent.getIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_INDEX.toString(), this.msgFactory.buildCreateIndexMessage(index).toString());
        event.setDbName(index.getDbName());
        this.process(event, (ListenerEvent)indexEvent);
    }

    public void onDropIndex(DropIndexEvent indexEvent) throws MetaException {
        Index index = indexEvent.getIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_INDEX.toString(), this.msgFactory.buildDropIndexMessage(index).toString());
        event.setDbName(index.getDbName());
        this.process(event, (ListenerEvent)indexEvent);
    }

    public void onAlterIndex(AlterIndexEvent indexEvent) throws MetaException {
        Index before = indexEvent.getOldIndex();
        Index after = indexEvent.getNewIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_INDEX.toString(), this.msgFactory.buildAlterIndexMessage(before, after).toString());
        event.setDbName(before.getDbName());
        this.process(event, (ListenerEvent)indexEvent);
    }

    public void onInsert(InsertEvent insertEvent) throws MetaException {
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.INSERT.toString(), this.msgFactory.buildInsertMessage(insertEvent.getDb(), insertEvent.getTable(), insertEvent.getPartitionKeyValues(), (Iterator)new FileChksumIterator(insertEvent.getFiles(), insertEvent.getFileChecksums())).toString());
        event.setDbName(insertEvent.getDb());
        event.setTableName(insertEvent.getTable());
        this.process(event, (ListenerEvent)insertEvent);
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partSetDoneEvent) throws MetaException {
    }

    private int now() {
        long millis = System.currentTimeMillis();
        if ((millis /= 1000L) > Integer.MAX_VALUE) {
            LOG.warn("We've passed max int value in seconds since the epoch, all notification times will be the same!");
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    private void process(NotificationEvent event, ListenerEvent listenerEvent) throws MetaException {
        event.setMessageFormat(this.msgFactory.getMessageFormat());
        LOG.debug("DbNotificationListener: Processing : {}:{}", (Object)event.getEventId(), (Object)event.getMessage());
        HiveMetaStore.HMSHandler.getMSForConf((Configuration)this.hiveConf).addNotificationEvent(event);
        if (event.isSetEventId()) {
            listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
        }
    }

    private String encodeFileUri(String fileUriStr, String fileChecksum) {
        if (fileChecksum != null) {
            return fileUriStr + "#" + fileChecksum;
        }
        return fileUriStr;
    }

    private static class CleanerThread
    extends Thread {
        private RawStore rs;
        private int ttl;
        private static long sleepTime = 60000L;

        CleanerThread(HiveConf conf, RawStore rs) {
            super("CleanerThread");
            this.rs = rs;
            this.setTimeToLive(conf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.rs.cleanNotificationEvents(this.ttl);
                LOG.debug("Cleaner thread done");
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Cleaner thread sleep interupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public void setTimeToLive(long configTtl) {
            this.ttl = configTtl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)configTtl;
        }
    }

    class FileChksumIterator
    implements Iterator<String> {
        private List<String> files;
        private List<String> chksums;
        int i = 0;

        FileChksumIterator(List<String> files, List<String> chksums) {
            this.files = files;
            this.chksums = chksums;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.files.size();
        }

        @Override
        public String next() {
            String result = DbNotificationListener.this.encodeFileUri(this.files.get(this.i), this.chksums != null ? this.chksums.get(this.i) : null);
            ++this.i;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class PartitionFilesIterator
    implements Iterator<PartitionFiles> {
        private Iterator<Partition> partitionIter;
        private Table t;

        PartitionFilesIterator(Iterator<Partition> partitionIter, Table t) {
            this.partitionIter = partitionIter;
            this.t = t;
        }

        @Override
        public boolean hasNext() {
            return this.partitionIter.hasNext();
        }

        @Override
        public PartitionFiles next() {
            try {
                Partition p = this.partitionIter.next();
                ArrayList files = Lists.newArrayList((Iterator)new FileIterator(p.getSd().getLocation()));
                PartitionFiles partitionFiles = new PartitionFiles(Warehouse.makePartName((List)this.t.getPartitionKeys(), (List)p.getValues()), files.iterator());
                return partitionFiles;
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class FileIterator
    implements Iterator<String> {
        PathFilter VALID_FILES_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                try {
                    if (!FileIterator.this.fs.isFile(p)) {
                        return false;
                    }
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        private FileSystem fs;
        private FileStatus[] files;
        private int i = 0;

        FileIterator(String locString) {
            try {
                if (locString != null) {
                    Path loc = new Path(locString);
                    this.fs = loc.getFileSystem((Configuration)DbNotificationListener.this.hiveConf);
                    this.files = this.fs.listStatus(loc, this.VALID_FILES_FILTER);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.files == null) {
                return false;
            }
            return this.i < this.files.length;
        }

        @Override
        public String next() {
            try {
                FileStatus file = this.files[this.i];
                ++this.i;
                return ReplChangeManager.encodeFileUri((String)file.getPath().toString(), (String)ReplChangeManager.getChksumString((Path)file.getPath(), (FileSystem)this.fs));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

