/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.mapreduce.FileRecordWriterContainer;
import org.apache.hive.hcatalog.mapreduce.HCatBaseOutputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.TaskCommitContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicPartitionFileRecordWriterContainer
extends FileRecordWriterContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionFileRecordWriterContainer.class);
    private final List<Integer> dynamicPartCols;
    private int maxDynamicPartitions;
    private final Map<String, RecordWriter<? super WritableComparable<?>, ? super Writable>> baseDynamicWriters;
    private final Map<String, SerDe> baseDynamicSerDe;
    private final Map<String, org.apache.hadoop.mapred.OutputCommitter> baseDynamicCommitters;
    private final Map<String, org.apache.hadoop.mapred.TaskAttemptContext> dynamicContexts;
    private final Map<String, ObjectInspector> dynamicObjectInspectors;
    private Map<String, OutputJobInfo> dynamicOutputJobInfo;

    public DynamicPartitionFileRecordWriterContainer(RecordWriter<? super WritableComparable<?>, ? super Writable> baseWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        super(baseWriter, context);
        this.maxDynamicPartitions = this.jobInfo.getMaxDynamicPartitions();
        this.dynamicPartCols = this.jobInfo.getPosOfDynPartCols();
        if (this.dynamicPartCols == null) {
            throw new HCatException("It seems that setSchema() is not called on HCatOutputFormat. Please make sure that method is called.");
        }
        this.baseDynamicSerDe = new HashMap<String, SerDe>();
        this.baseDynamicWriters = new HashMap();
        this.baseDynamicCommitters = new HashMap<String, org.apache.hadoop.mapred.OutputCommitter>();
        this.dynamicContexts = new HashMap<String, org.apache.hadoop.mapred.TaskAttemptContext>();
        this.dynamicObjectInspectors = new HashMap<String, ObjectInspector>();
        this.dynamicOutputJobInfo = new HashMap<String, OutputJobInfo>();
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        Reporter reporter = InternalUtil.createReporter(context);
        for (RecordWriter<? super WritableComparable<?>, ? super Writable> recordWriter : this.baseDynamicWriters.values()) {
            recordWriter.close(reporter);
        }
        TaskCommitContextRegistry.getInstance().register(context, new TaskCommitContextRegistry.TaskCommitterProxy(){

            @Override
            public void abortTask(TaskAttemptContext context) throws IOException {
                for (Map.Entry outputJobInfoEntry : DynamicPartitionFileRecordWriterContainer.this.dynamicOutputJobInfo.entrySet()) {
                    String dynKey = (String)outputJobInfoEntry.getKey();
                    OutputJobInfo outputJobInfo = (OutputJobInfo)outputJobInfoEntry.getValue();
                    LOG.info("Aborting task-attempt for " + outputJobInfo.getLocation());
                    ((org.apache.hadoop.mapred.OutputCommitter)DynamicPartitionFileRecordWriterContainer.this.baseDynamicCommitters.get(dynKey)).abortTask((org.apache.hadoop.mapred.TaskAttemptContext)DynamicPartitionFileRecordWriterContainer.this.dynamicContexts.get(dynKey));
                }
            }

            @Override
            public void commitTask(TaskAttemptContext context) throws IOException {
                for (Map.Entry outputJobInfoEntry : DynamicPartitionFileRecordWriterContainer.this.dynamicOutputJobInfo.entrySet()) {
                    String dynKey = (String)outputJobInfoEntry.getKey();
                    OutputJobInfo outputJobInfo = (OutputJobInfo)outputJobInfoEntry.getValue();
                    LOG.info("Committing task-attempt for " + outputJobInfo.getLocation());
                    TaskAttemptContext dynContext = (TaskAttemptContext)DynamicPartitionFileRecordWriterContainer.this.dynamicContexts.get(dynKey);
                    OutputCommitter dynCommitter = (OutputCommitter)DynamicPartitionFileRecordWriterContainer.this.baseDynamicCommitters.get(dynKey);
                    if (dynCommitter.needsTaskCommit(dynContext)) {
                        dynCommitter.commitTask(dynContext);
                        continue;
                    }
                    LOG.info("Skipping commitTask() for " + outputJobInfo.getLocation());
                }
            }
        });
    }

    @Override
    protected FileRecordWriterContainer.LocalFileWriter getLocalFileWriter(HCatRecord value) throws IOException, HCatException {
        OutputJobInfo localJobInfo = null;
        ArrayList<String> dynamicPartValues = new ArrayList<String>();
        for (Integer colToAppend : this.dynamicPartCols) {
            dynamicPartValues.add(value.get(colToAppend).toString());
        }
        String dynKey = ((Object)dynamicPartValues).toString();
        if (!this.baseDynamicWriters.containsKey(dynKey)) {
            if (this.maxDynamicPartitions != -1 && this.baseDynamicWriters.size() > this.maxDynamicPartitions) {
                throw new HCatException(ErrorType.ERROR_TOO_MANY_DYNAMIC_PTNS, "Number of dynamic partitions being created exceeds configured max allowable partitions[" + this.maxDynamicPartitions + "], increase parameter [" + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + "] if needed.");
            }
            org.apache.hadoop.mapred.TaskAttemptContext currTaskContext = HCatMapRedUtil.createTaskAttemptContext(this.context);
            this.configureDynamicStorageHandler((JobContext)currTaskContext, dynamicPartValues);
            localJobInfo = HCatBaseOutputFormat.getJobInfo(currTaskContext.getConfiguration());
            SerDe currSerDe = (SerDe)ReflectionUtils.newInstance((Class)this.storageHandler.getSerDeClass(), (Configuration)currTaskContext.getJobConf());
            try {
                InternalUtil.initializeOutputSerDe(currSerDe, currTaskContext.getConfiguration(), localJobInfo);
            }
            catch (SerDeException e) {
                throw new IOException("Failed to initialize SerDe", e);
            }
            OutputFormat baseOF = (OutputFormat)ReflectionUtils.newInstance((Class)this.storageHandler.getOutputFormatClass(), (Configuration)currTaskContext.getJobConf());
            org.apache.hadoop.mapred.OutputCommitter baseOutputCommitter = currTaskContext.getJobConf().getOutputCommitter();
            org.apache.hadoop.mapred.JobContext currJobContext = HCatMapRedUtil.createJobContext((JobContext)currTaskContext);
            baseOutputCommitter.setupJob(currJobContext);
            currTaskContext = HCatMapRedUtil.createTaskAttemptContext(currJobContext.getJobConf(), currTaskContext.getTaskAttemptID(), currTaskContext.getProgressible());
            currTaskContext.getConfiguration().set("mapred.work.output.dir", new FileOutputCommitter(new Path(localJobInfo.getLocation()), (TaskAttemptContext)currTaskContext).getWorkPath().toString());
            baseOutputCommitter.setupTask(currTaskContext);
            Path parentDir = new Path(currTaskContext.getConfiguration().get("mapred.work.output.dir"));
            Path childPath = new Path(parentDir, FileOutputFormat.getUniqueFile((TaskAttemptContext)currTaskContext, (String)"part", (String)""));
            RecordWriter baseRecordWriter = baseOF.getRecordWriter(parentDir.getFileSystem(currTaskContext.getConfiguration()), currTaskContext.getJobConf(), childPath.toString(), (Progressable)InternalUtil.createReporter((TaskAttemptContext)currTaskContext));
            this.baseDynamicWriters.put(dynKey, baseRecordWriter);
            this.baseDynamicSerDe.put(dynKey, currSerDe);
            this.baseDynamicCommitters.put(dynKey, baseOutputCommitter);
            this.dynamicContexts.put(dynKey, currTaskContext);
            this.dynamicObjectInspectors.put(dynKey, (ObjectInspector)InternalUtil.createStructObjectInspector(this.jobInfo.getOutputSchema()));
            this.dynamicOutputJobInfo.put(dynKey, HCatOutputFormat.getJobInfo(this.dynamicContexts.get(dynKey).getConfiguration()));
        }
        return new FileRecordWriterContainer.LocalFileWriter(this, this.baseDynamicWriters.get(dynKey), this.dynamicObjectInspectors.get(dynKey), this.baseDynamicSerDe.get(dynKey), this.dynamicOutputJobInfo.get(dynKey));
    }

    protected void configureDynamicStorageHandler(JobContext context, List<String> dynamicPartVals) throws IOException {
        HCatOutputFormat.configureOutputStorageHandler(context, dynamicPartVals);
    }
}

