/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.shaded.common.protocol.ApiKeys;
import org.apache.kafka.shaded.common.protocol.Errors;
import org.apache.kafka.shaded.common.protocol.ProtoUtils;
import org.apache.kafka.shaded.common.protocol.types.Schema;
import org.apache.kafka.shaded.common.protocol.types.Struct;
import org.apache.kafka.shaded.common.requests.AbstractRequestResponse;

public class CreateTopicsResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.CREATE_TOPICS.id);
    private static final String TOPIC_ERROR_CODES_KEY_NAME = "topic_error_codes";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<String, Errors> errors;

    public CreateTopicsResponse(Map<String, Errors> errors) {
        super(new Struct(CURRENT_SCHEMA));
        ArrayList<Struct> topicErrorCodeStructs = new ArrayList<Struct>(errors.size());
        for (Map.Entry<String, Errors> topicError : errors.entrySet()) {
            Struct topicErrorCodeStruct = this.struct.instance(TOPIC_ERROR_CODES_KEY_NAME);
            topicErrorCodeStruct.set(TOPIC_KEY_NAME, (Object)topicError.getKey());
            topicErrorCodeStruct.set(ERROR_CODE_KEY_NAME, (Object)topicError.getValue().code());
            topicErrorCodeStructs.add(topicErrorCodeStruct);
        }
        this.struct.set(TOPIC_ERROR_CODES_KEY_NAME, (Object)topicErrorCodeStructs.toArray());
        this.errors = errors;
    }

    public CreateTopicsResponse(Struct struct) {
        super(struct);
        Object[] topicErrorCodesStructs = struct.getArray(TOPIC_ERROR_CODES_KEY_NAME);
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (Object topicErrorCodeStructObj : topicErrorCodesStructs) {
            Struct topicErrorCodeStruct = (Struct)topicErrorCodeStructObj;
            String topic = topicErrorCodeStruct.getString(TOPIC_KEY_NAME);
            short errorCode = topicErrorCodeStruct.getShort(ERROR_CODE_KEY_NAME);
            errors.put(topic, Errors.forCode(errorCode));
        }
        this.errors = errors;
    }

    public Map<String, Errors> errors() {
        return this.errors;
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer) {
        return new CreateTopicsResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer, int version) {
        return new CreateTopicsResponse(ProtoUtils.responseSchema(ApiKeys.CREATE_TOPICS.id, version).read(buffer));
    }
}

