/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.MembershipWriter;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MembershipProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(MembershipProvider.class);
    private final MembershipWriter writer = new MembershipWriter();

    MembershipProvider(@NotNull Root root, @NotNull ConfigurationParameters config) {
        super(root, config);
    }

    void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.writer.setMembershipSizeThreshold(membershipSizeThreshold);
    }

    @NotNull
    Iterator<String> getMembership(@NotNull Tree authorizableTree, boolean includeInherited) {
        return this.getMembership(authorizableTree, includeInherited, new HashSet<String>());
    }

    @NotNull
    private Iterator<String> getMembership(@NotNull Tree authorizableTree, final boolean includeInherited, final @NotNull Set<String> processedPaths) {
        Iterable<String> refPaths = this.identifierManager.getReferences(authorizableTree, "rep:members", "rep:MemberReferences", true);
        return new AbstractMemberIterator(refPaths.iterator()){

            @Override
            protected String internalGetNext(@NotNull String propPath) {
                String next = null;
                String groupPath = this.getGroupPath(propPath);
                if (groupPath != null) {
                    if (processedPaths.add(groupPath)) {
                        Tree group;
                        next = groupPath;
                        if (includeInherited && (group = MembershipProvider.this.getByPath(groupPath, AuthorizableType.GROUP)) != null) {
                            this.remember(group);
                        }
                    }
                } else {
                    log.debug("Not a membership reference property {}", (Object)propPath);
                }
                return next;
            }

            @Override
            @NotNull
            protected Iterator<String> getNextIterator(@NotNull Tree groupTree) {
                return MembershipProvider.this.getMembership(groupTree, true, processedPaths);
            }

            @Nullable
            private String getGroupPath(@NotNull String membersPropPath) {
                int index = membersPropPath.indexOf("/rep:membersList");
                if (index < 0) {
                    index = membersPropPath.indexOf("/rep:members");
                }
                if (index > 0) {
                    return membersPropPath.substring(0, index);
                }
                return null;
            }
        };
    }

    private boolean hasMembership(@NotNull Tree authorizableTree, @NotNull String groupPath) {
        return Iterators.contains(this.getMembership(authorizableTree, true), (Object)groupPath);
    }

    @NotNull
    Iterator<String> getMembers(@NotNull Tree groupTree, boolean includeInherited) {
        return this.getMembers(groupTree, this.getContentID(groupTree), includeInherited, new HashSet<String>());
    }

    @NotNull
    Iterator<String> getDeclaredMemberContentIDs(@NotNull Tree groupTree) {
        return this.getDeclaredMemberReferenceIterator(groupTree);
    }

    @NotNull
    private Iterator<String> getMembers(@NotNull Tree groupTree, final @NotNull String groupContentId, final boolean includeInherited, final @NotNull Set<String> processedRefs) {
        MemberReferenceIterator mrit = new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@NotNull String value) {
                if (groupContentId.equals(value)) {
                    log.warn("Cyclic group membership detected for contentId {}", (Object)groupContentId);
                    return false;
                }
                return processedRefs.add(value);
            }
        };
        return new AbstractMemberIterator(mrit){

            @Override
            protected String internalGetNext(@NotNull String value) {
                Tree gr;
                String next = MembershipProvider.this.identifierManager.getPath(PropertyValues.newWeakReference(value));
                if (next != null && includeInherited && (gr = MembershipProvider.this.getByPath(next, AuthorizableType.GROUP)) != null) {
                    this.remember(gr);
                }
                return next;
            }

            @Override
            @NotNull
            protected Iterator<String> getNextIterator(@NotNull Tree groupTree) {
                return MembershipProvider.this.getMembers(groupTree, groupContentId, true, processedRefs);
            }
        };
    }

    boolean isMember(@NotNull Tree groupTree, @NotNull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        if (this.pendingChanges(groupTree)) {
            return Iterators.contains(this.getMembers(groupTree, true), (Object)authorizableTree.getPath());
        }
        return this.hasMembership(authorizableTree, groupTree.getPath());
    }

    boolean isDeclaredMember(@NotNull Tree groupTree, @NotNull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        String contentId = this.getContentID(authorizableTree);
        MemberReferenceIterator refs = this.getDeclaredMemberReferenceIterator(groupTree);
        return Iterators.contains((Iterator)refs, (Object)contentId);
    }

    private static boolean hasMembers(@NotNull Tree groupTree) {
        return groupTree.getPropertyStatus("rep:members") != null || groupTree.hasChild("rep:membersList");
    }

    private boolean pendingChanges(@NotNull Tree groupTree) {
        Tree.Status memberPropStatus = groupTree.getPropertyStatus("rep:members");
        return Tree.Status.UNCHANGED != memberPropStatus || this.root.hasPendingChanges();
    }

    boolean addMember(@NotNull Tree groupTree, @NotNull Tree newMemberTree) {
        return this.writer.addMember(groupTree, this.getContentID(newMemberTree));
    }

    Set<String> addMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        return this.writer.addMembers(groupTree, memberIds);
    }

    boolean removeMember(@NotNull Tree groupTree, @NotNull Tree memberTree) {
        if (this.writer.removeMember(groupTree, this.getContentID(memberTree))) {
            return true;
        }
        log.debug("Authorizable {} was not member of {}", (Object)memberTree.getName(), (Object)groupTree.getName());
        return false;
    }

    Set<String> removeMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        return this.writer.removeMembers(groupTree, memberIds);
    }

    private MemberReferenceIterator getDeclaredMemberReferenceIterator(@NotNull Tree groupTree) {
        return new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@NotNull String value) {
                return true;
            }
        };
    }

    private abstract class AbstractMemberIterator
    extends AbstractLazyIterator<String> {
        private Iterator<String> references;
        private List<Tree> groupTrees;
        private Iterator<String> parent;

        AbstractMemberIterator(Iterator<String> references) {
            this.references = references;
        }

        @Override
        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.references.hasNext()) {
                    next = this.internalGetNext(this.references.next());
                    continue;
                }
                if (this.parent != null) {
                    if (this.parent.hasNext()) {
                        next = this.parent.next();
                        continue;
                    }
                    this.parent = null;
                    continue;
                }
                if (this.groupTrees == null || this.groupTrees.isEmpty()) break;
                this.parent = this.getNextIterator(this.groupTrees.remove(0));
            }
            return next;
        }

        void remember(@NotNull Tree groupTree) {
            if (this.groupTrees == null) {
                this.groupTrees = new ArrayList<Tree>();
            }
            this.groupTrees.add(groupTree);
        }

        @Nullable
        protected abstract String internalGetNext(@NotNull String var1);

        @NotNull
        protected abstract Iterator<String> getNextIterator(@NotNull Tree var1);
    }

    private abstract class MemberReferenceIterator
    extends AbstractLazyIterator<String> {
        private final Iterator<Tree> trees;
        private Iterator<String> propertyValues;

        private MemberReferenceIterator(Tree groupTree) {
            this.trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), groupTree.getChild("rep:membersList").getChildren().iterator());
        }

        @Override
        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.propertyValues == null) {
                    if (!this.trees.hasNext()) break;
                    PropertyState property = this.trees.next().getProperty("rep:members");
                    if (property == null) continue;
                    this.propertyValues = property.getValue(Type.STRINGS).iterator();
                    continue;
                }
                if (!this.propertyValues.hasNext()) {
                    this.propertyValues = null;
                    continue;
                }
                String value = this.propertyValues.next();
                if (!this.hasProcessedReference(value)) continue;
                next = value;
            }
            return next;
        }

        protected abstract boolean hasProcessedReference(@NotNull String var1);
    }
}

