/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractGroupPrincipal
extends TreeBasedPrincipal
implements GroupPrincipal,
Group {
    private static final Logger log = LoggerFactory.getLogger(AbstractGroupPrincipal.class);

    AbstractGroupPrincipal(@NotNull String principalName, @NotNull Tree groupTree, @NotNull NamePathMapper namePathMapper) {
        super(principalName, groupTree, namePathMapper);
    }

    AbstractGroupPrincipal(@NotNull String principalName, @NotNull String groupPath, @NotNull NamePathMapper namePathMapper) {
        super(principalName, groupPath, namePathMapper);
    }

    abstract UserManager getUserManager();

    abstract boolean isEveryone() throws RepositoryException;

    abstract boolean isMember(@NotNull Authorizable var1) throws RepositoryException;

    @NotNull
    abstract Iterator<Authorizable> getMembers() throws RepositoryException;

    public boolean isMember(Principal principal) {
        boolean isMember = false;
        try {
            if (this.isEveryone()) {
                isMember = !"everyone".equals(principal.getName());
            } else {
                Authorizable a = this.getUserManager().getAuthorizable(principal);
                if (a != null) {
                    isMember = this.isMember(a);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to determine group membership: {}", (Object)e.getMessage());
        }
        return isMember;
    }

    public Enumeration<? extends Principal> members() {
        Iterator<Authorizable> members;
        try {
            members = this.getMembers();
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve Group members: " + e.getMessage();
            log.error(msg);
            throw new IllegalStateException(msg, e);
        }
        Iterator principals = Iterators.transform(members, (Function)new Function<Authorizable, Principal>(){

            public Principal apply(Authorizable authorizable) {
                if (authorizable == null) {
                    return null;
                }
                try {
                    return authorizable.getPrincipal();
                }
                catch (RepositoryException e) {
                    String msg = "Internal error while retrieving principal: " + e.getMessage();
                    log.error(msg);
                    throw new IllegalStateException(msg, e);
                }
            }
        });
        return Iterators.asEnumeration((Iterator)Iterators.filter((Iterator)principals, (Predicate)Predicates.notNull()));
    }

    public boolean addMember(Principal principal) {
        throw new UnsupportedOperationException();
    }

    public boolean removeMember(Principal principal) {
        throw new UnsupportedOperationException();
    }
}

