/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTypePattern
implements RestrictionPattern {
    private static final Logger log = LoggerFactory.getLogger(NodeTypePattern.class);
    private final Set<String> nodeTypeNames;

    NodeTypePattern(@NotNull Iterable<String> nodeTypeNames) {
        this.nodeTypeNames = ImmutableSet.copyOf(nodeTypeNames);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        return this.nodeTypeNames.contains(TreeUtil.getPrimaryTypeName(tree));
    }

    @Override
    public boolean matches(@NotNull String path) {
        log.debug("Unable to validate node type restriction.");
        return false;
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return this.nodeTypeNames.hashCode();
    }

    public String toString() {
        return this.nodeTypeNames.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeTypePattern) {
            NodeTypePattern other = (NodeTypePattern)obj;
            return this.nodeTypeNames.equals(other.nodeTypeNames);
        }
        return false;
    }
}

