/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenProviderImpl;
import org.apache.jackrabbit.oak.security.authentication.token.TokenValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CompositeCredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.SimpleCredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={TokenConfiguration.class, SecurityConfiguration.class}, property={"oak.security.name=org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl"})
@Designate(ocd=Configuration.class)
public class TokenConfigurationImpl
extends ConfigurationBase
implements TokenConfiguration {
    private final Map<String, CredentialsSupport> credentialsSupport = new ConcurrentHashMap<String, CredentialsSupport>((Map<String, CredentialsSupport>)ImmutableMap.of((Object)SimpleCredentialsSupport.class.getName(), (Object)SimpleCredentialsSupport.getInstance()));

    public TokenConfigurationImpl() {
    }

    public TokenConfigurationImpl(@NotNull SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication.token"));
    }

    @Activate
    private void activate(Configuration configuration, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Reference(name="credentialsSupport", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindCredentialsSupport(CredentialsSupport credentialsSupport) {
        this.credentialsSupport.put(credentialsSupport.getClass().getName(), credentialsSupport);
    }

    public void unbindCredentialsSupport(CredentialsSupport credentialsSupport) {
        this.credentialsSupport.remove(credentialsSupport.getClass().getName());
    }

    @Override
    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication.token";
    }

    @Override
    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        TokenValidatorProvider vp = new TokenValidatorProvider(this.getSecurityProvider().getParameters("org.apache.jackrabbit.oak.user"), this.getTreeProvider());
        return ImmutableList.of((Object)vp);
    }

    @Override
    @NotNull
    public TokenProvider getTokenProvider(@NotNull Root root) {
        UserConfiguration uc = this.getSecurityProvider().getConfiguration(UserConfiguration.class);
        return new TokenProviderImpl(root, this.getParameters(), uc, this.newCredentialsSupport());
    }

    @NotNull
    private CredentialsSupport newCredentialsSupport() {
        int size = this.credentialsSupport.size();
        if (size == 0) {
            return SimpleCredentialsSupport.getInstance();
        }
        if (size == 1) {
            return this.credentialsSupport.values().iterator().next();
        }
        return CompositeCredentialsSupport.newInstance(() -> ImmutableSet.copyOf(this.credentialsSupport.values()));
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak TokenConfiguration")
    static @interface Configuration {
        @AttributeDefinition(name="Token Expiration", description="Expiration time of login tokens in ms.")
        public String tokenExpiration();

        @AttributeDefinition(name="Token Length", description="Length of the generated token.")
        public String tokenLength();

        @AttributeDefinition(name="Token Refresh", description="Enable/disable refresh of login tokens (i.e. resetting the expiration time).")
        public boolean tokenRefresh() default true;

        @AttributeDefinition(name="Token Cleanup Threshold", description="Setting this option to a value > 0 will trigger a cleanup upon token creation: if the number of existing token matches/exceeds the configured value an attempt is made to removed expired tokens.")
        public long tokenCleanupThreshold() default 0L;

        @AttributeDefinition(name="Hash Algorithm", description="Name of the algorithm to hash the token.")
        public String passwordHashAlgorithm() default "SHA-256";

        @AttributeDefinition(name="Hash Iterations", description="Number of iterations used to hash the token.")
        public int passwordHashIterations() default 1000;

        @AttributeDefinition(name="Hash Salt Size", description="Size of the salt used to generate the hash.")
        public int passwordSaltSize() default 8;
    }
}

