/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.util.Map;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.security.authentication.LoginContextProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleStatsCollector;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthenticationConfiguration.class, SecurityConfiguration.class})
@Designate(ocd=Configuration.class)
public class AuthenticationConfigurationImpl
extends ConfigurationBase
implements AuthenticationConfiguration,
LoginModuleStatsCollector {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConfigurationImpl.class);
    private LoginModuleMonitor lmMonitor = LoginModuleMonitor.NOOP;

    public AuthenticationConfigurationImpl() {
    }

    @Activate
    private void activate(Configuration configuration, Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    public AuthenticationConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication"));
    }

    @Override
    @NotNull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication";
    }

    @Override
    @NotNull
    public LoginContextProvider getLoginContextProvider(@NotNull ContentRepository contentRepository) {
        String appName = this.getParameters().getConfigValue("org.apache.jackrabbit.oak.authentication.appName", "jackrabbit.oak");
        SecurityProvider provider = this.getSecurityProvider();
        Whiteboard whiteboard = null;
        if (provider instanceof WhiteboardAware) {
            whiteboard = ((WhiteboardAware)((Object)provider)).getWhiteboard();
        } else {
            log.warn("Unable to obtain whiteboard from SecurityProvider");
        }
        return new LoginContextProviderImpl(appName, this.getParameters(), contentRepository, provider, whiteboard, this.lmMonitor);
    }

    @Override
    public void setLoginModuleMonitor(@NotNull LoginModuleMonitor lmMonitor) {
        this.lmMonitor = lmMonitor;
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak AuthenticationConfiguration")
    static @interface Configuration {
        @AttributeDefinition(name="Application Name", description="Application named used for JAAS authentication", defaultValue={"jackrabbit.oak"})
        public String org_apache_jackrabbit_oak_authentication_appName() default "jackrabbit.oak";

        @AttributeDefinition(name="JAAS Config SPI Name", description="Name of JAAS Configuration Spi. This needs to be set to JAAS config provider name if JAAS authentication is managed by Felix JAAS Support with its Global Configuration Policy set to 'default'.")
        public String org_apache_jackrabbit_oak_authentication_configSpiName();
    }
}

