/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.AbstractDecoratedNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteringNodeState
extends AbstractDecoratedNodeState {
    public static final Set<String> ALL = ImmutableSet.of((Object)"/");
    public static final Set<String> NONE = ImmutableSet.of();
    private final String path;
    private final Set<String> includedPaths;
    private final Set<String> excludedPaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludedFragments;

    @NotNull
    public static NodeState wrap(@NotNull String path, @NotNull NodeState delegate, @Nullable Set<String> includePaths, @Nullable Set<String> excludePaths, @Nullable Set<String> fragmentPaths, @Nullable Set<String> excludedFragments) {
        Set<String> safeExcludedFragments;
        Set<String> safeFragmentPaths;
        Set<String> excludes;
        Set<String> includes = FilteringNodeState.defaultIfEmpty(includePaths, ALL);
        if (FilteringNodeState.hasHiddenDescendants(path, includes, excludes = FilteringNodeState.defaultIfEmpty(excludePaths, NONE), safeFragmentPaths = FilteringNodeState.defaultIfEmpty(fragmentPaths, NONE), safeExcludedFragments = FilteringNodeState.defaultIfEmpty(excludedFragments, NONE))) {
            return new FilteringNodeState(path, delegate, includes, excludes, fragmentPaths, safeExcludedFragments);
        }
        return delegate;
    }

    private FilteringNodeState(@NotNull String path, @NotNull NodeState delegate, @NotNull Set<String> includedPaths, @NotNull Set<String> excludedPaths, @NotNull Set<String> fragmentPaths, @NotNull Set<String> excludedFragments) {
        super(delegate, false);
        this.path = path;
        this.includedPaths = includedPaths;
        this.excludedPaths = excludedPaths;
        this.fragmentPaths = fragmentPaths;
        this.excludedFragments = excludedFragments;
    }

    @Override
    @NotNull
    protected NodeState decorateChild(@NotNull String name, @NotNull NodeState child) {
        String childPath = PathUtils.concat(this.path, name);
        return FilteringNodeState.wrap(childPath, child, this.includedPaths, this.excludedPaths, this.fragmentPaths, this.excludedFragments);
    }

    @Override
    protected boolean hideChild(@NotNull String name, @NotNull NodeState delegateChild) {
        return FilteringNodeState.isHidden(PathUtils.concat(this.path, name), this.includedPaths, this.excludedPaths, this.excludedFragments);
    }

    @Override
    protected PropertyState decorateProperty(@NotNull PropertyState propertyState) {
        return FilteringNodeState.fixChildOrderPropertyState(this, propertyState);
    }

    private static boolean isHidden(@NotNull String path, @NotNull Set<String> includes, @NotNull Set<String> excludes, @NotNull Set<String> excludedFragments) {
        return FilteringNodeState.isExcluded(path, excludes, excludedFragments) || !FilteringNodeState.isIncluded(path, includes);
    }

    private static boolean hasHiddenDescendants(@NotNull String path, @NotNull Set<String> includePaths, @NotNull Set<String> excludePaths, @NotNull Set<String> fragmentPaths, @NotNull Set<String> excludedFragments) {
        return FilteringNodeState.isHidden(path, includePaths, excludePaths, excludedFragments) || FilteringNodeState.isAncestorOfAnyPath(path, fragmentPaths) || FilteringNodeState.isDescendantOfAnyPath(path, fragmentPaths) || fragmentPaths.contains(path) || FilteringNodeState.isAncestorOfAnyPath(path, excludePaths) || FilteringNodeState.isAncestorOfAnyPath(path, includePaths);
    }

    private static boolean isIncluded(@NotNull String path, @NotNull Set<String> includePaths) {
        return FilteringNodeState.isAncestorOfAnyPath(path, includePaths) || includePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, includePaths);
    }

    private static boolean isExcluded(@NotNull String path, @NotNull Set<String> excludePaths, @NotNull Set<String> excludedFragments) {
        return excludePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, excludePaths) || FilteringNodeState.containsAnyFragment(path, excludedFragments);
    }

    private static boolean isAncestorOfAnyPath(@NotNull String ancestor, @NotNull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor(ancestor, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescendantOfAnyPath(@NotNull String descendant, @NotNull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor(p, descendant)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnyFragment(@NotNull String path, @NotNull Set<String> fragments) {
        for (String f : fragments) {
            if (!path.contains(f)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static <T> Set<T> defaultIfEmpty(@Nullable Set<T> value, @NotNull Set<T> defaultValue) {
        return !FilteringNodeState.isEmpty(value) ? value : defaultValue;
    }

    private static <T> boolean isEmpty(@Nullable Set<T> set) {
        return set == null || set.isEmpty();
    }
}

