/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.jackrabbit.oak.api.blob.BlobDownloadOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataRecordDownloadOptions {
    static final String DISPOSITION_TYPE_INLINE = "inline";
    static final String DISPOSITION_TYPE_ATTACHMENT = "attachment";
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Set<Character> rfc5987AllowedChars = Sets.newHashSet((Object[])new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')});
    public static DataRecordDownloadOptions DEFAULT = new DataRecordDownloadOptions(null, null, null, "inline");
    private final String mediaType;
    private final String characterEncoding;
    private final String fileName;
    private final String dispositionType;
    private String contentTypeHeader = null;
    private String contentDispositionHeader = null;

    public static DataRecordDownloadOptions fromBlobDownloadOptions(@NotNull BlobDownloadOptions downloadOptions) {
        return new DataRecordDownloadOptions(downloadOptions.getMediaType(), downloadOptions.getCharacterEncoding(), downloadOptions.getFileName(), downloadOptions.getDispositionType());
    }

    private DataRecordDownloadOptions(String mediaType, String characterEncoding, String fileName, String dispositionType) {
        this.mediaType = mediaType;
        this.characterEncoding = characterEncoding;
        this.fileName = fileName;
        this.dispositionType = Strings.isNullOrEmpty((String)dispositionType) ? DISPOSITION_TYPE_INLINE : dispositionType;
    }

    @Nullable
    public String getContentTypeHeader() {
        if (Strings.isNullOrEmpty((String)this.contentTypeHeader) && !Strings.isNullOrEmpty((String)this.mediaType)) {
            this.contentTypeHeader = Strings.isNullOrEmpty((String)this.characterEncoding) ? this.mediaType : Joiner.on((String)"; charset=").join((Object)this.mediaType, (Object)this.characterEncoding, new Object[0]);
        }
        return this.contentTypeHeader;
    }

    @Nullable
    public String getContentDispositionHeader() {
        if (Strings.isNullOrEmpty((String)this.contentDispositionHeader)) {
            if (!Strings.isNullOrEmpty((String)this.fileName)) {
                String dispositionType = this.dispositionType;
                if (Strings.isNullOrEmpty((String)dispositionType)) {
                    dispositionType = DISPOSITION_TYPE_INLINE;
                }
                this.contentDispositionHeader = this.formatContentDispositionHeader(dispositionType, this.fileName, null);
            } else if (DISPOSITION_TYPE_ATTACHMENT.equals(this.dispositionType)) {
                this.contentDispositionHeader = DISPOSITION_TYPE_ATTACHMENT;
            }
        }
        return this.contentDispositionHeader;
    }

    private String formatContentDispositionHeader(@NotNull String dispositionType, @NotNull String fileName, @Nullable String rfc8187EncodedFileName) {
        return null != rfc8187EncodedFileName ? String.format("%s; filename=\"%s\"; filename*=UTF-8''%s", dispositionType, fileName, rfc8187EncodedFileName) : String.format("%s; filename=\"%s\"", dispositionType, fileName);
    }

    private String rfc8187Encode(@NotNull String input) {
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            char c = (char)b;
            if (rfc5987AllowedChars.contains(Character.valueOf(c))) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            sb.append(hex[0xF & b >>> 4]);
            sb.append(hex[b & 0xF]);
        }
        return sb.toString();
    }

    @Nullable
    public String getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public String getDispositionType() {
        return this.dispositionType;
    }
}

