/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hamcrest.matchers;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.hamcrest.matchers.ResourceNameMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsCollectionContaining;

public class ResourceChildrenMatcher
extends TypeSafeMatcher<Resource> {
    private final Matcher<?> iterarableMatcher;

    public ResourceChildrenMatcher(List<String> childNames, boolean exactMatch, boolean validateOrder) {
        if (childNames == null || childNames.isEmpty()) {
            throw new IllegalArgumentException("childNames is null or empty");
        }
        if (!exactMatch && validateOrder) {
            throw new IllegalArgumentException("Can only validate the order for exact matches");
        }
        ArrayList<ResourceNameMatcher> resourceMatchers = new ArrayList<ResourceNameMatcher>();
        for (String childName : childNames) {
            resourceMatchers.add(new ResourceNameMatcher(childName));
        }
        this.iterarableMatcher = exactMatch ? (validateOrder ? IsIterableContainingInOrder.contains(resourceMatchers) : IsIterableContainingInAnyOrder.containsInAnyOrder(resourceMatchers)) : IsCollectionContaining.hasItems((Matcher[])((Matcher[])resourceMatchers.toArray(new ResourceNameMatcher[0])));
    }

    public void describeTo(Description description) {
        this.iterarableMatcher.describeTo(description);
    }

    protected boolean matchesSafely(Resource item) {
        return this.iterarableMatcher.matches((Object)item.getChildren());
    }

    protected void describeMismatchSafely(Resource item, Description mismatchDescription) {
        this.iterarableMatcher.describeMismatch((Object)item.getChildren(), mismatchDescription);
    }
}

