/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlethelpers.MockRequestPathInfo;
import org.apache.sling.servlethelpers.MockSlingHttpServletRequest;
import org.apache.sling.servlethelpers.MockSlingHttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class InternalRequest {
    protected final ResourceResolver resourceResolver;
    protected final String path;
    protected String selectorString;
    protected String extension;
    protected String requestMethod = "GET";
    protected String contentType;
    private Reader bodyReader;
    private boolean explicitStatusCheck;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private MockSlingHttpServletRequest request;
    private MockSlingHttpServletResponse response;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_METHOD = "GET";
    public static final String MDC_KEY = "sling." + InternalRequest.class.getSimpleName();

    protected InternalRequest(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        this.checkNotNull(ResourceResolver.class, (Object)resourceResolver);
        this.checkNotNull("path", (Object)path);
        this.resourceResolver = resourceResolver;
        this.path = path;
    }

    protected void checkNotNull(String info, Object candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(info + " is null");
        }
    }

    protected void checkNotNull(Class<?> clazz, Object candidate) {
        this.checkNotNull(clazz.getSimpleName(), candidate);
    }

    public InternalRequest withRequestMethod(String method) {
        this.requestMethod = method.toUpperCase();
        return this;
    }

    public InternalRequest withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public InternalRequest withBody(Reader bodyContent) {
        this.bodyReader = bodyContent;
        return this;
    }

    public InternalRequest withSelectors(String ... selectors) {
        if (selectors == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        Arrays.stream(selectors).forEach(sel -> sb.append(sb.length() == 0 ? "" : ".").append((String)sel));
        this.selectorString = sb.toString();
        return this;
    }

    public InternalRequest withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public InternalRequest withParameter(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        this.parameters.put(key, value);
        return this;
    }

    public InternalRequest withParameters(Map<String, Object> additionalParameters) {
        if (additionalParameters != null) {
            this.parameters.putAll(additionalParameters);
        }
        return this;
    }

    public final InternalRequest execute() throws IOException {
        if (this.request != null) {
            throw new IOException("Request was already executed");
        }
        Resource resource = this.getExecutionResource();
        this.request = new MockSlingHttpServletRequest(this.resourceResolver){

            @Override
            protected MockRequestPathInfo newMockRequestPathInfo() {
                MockRequestPathInfo rpi = super.newMockRequestPathInfo();
                rpi.setResourcePath(InternalRequest.this.path);
                rpi.setExtension(InternalRequest.this.extension);
                rpi.setSelectorString(InternalRequest.this.selectorString);
                return rpi;
            }

            @Override
            public BufferedReader getReader() {
                if (InternalRequest.this.bodyReader != null) {
                    return new BufferedReader(InternalRequest.this.bodyReader);
                }
                return super.getReader();
            }
        };
        this.request.setMethod(this.requestMethod);
        this.request.setContentType(this.contentType);
        this.request.setResource(resource);
        this.request.setParameterMap(this.parameters);
        this.response = new MockSlingHttpServletResponse();
        MDC.put((String)MDC_KEY, (String)this.toString());
        try {
            this.delegateExecute(this.request, this.response, this.resourceResolver);
        }
        catch (ServletException sx) {
            throw new IOException("ServletException in execute()", sx);
        }
        return this;
    }

    protected abstract Resource getExecutionResource();

    protected abstract void delegateExecute(SlingHttpServletRequest var1, SlingHttpServletResponse var2, ResourceResolver var3) throws ServletException, IOException;

    protected void assertRequestExecuted() throws IOException {
        if (this.request == null) {
            throw new IOException("Request hasn't been executed");
        }
    }

    public InternalRequest checkStatus(int ... acceptableValues) throws IOException {
        this.assertRequestExecuted();
        this.explicitStatusCheck = true;
        if (acceptableValues == null || acceptableValues.length == 0) {
            return this;
        }
        int actualStatus = this.getStatus();
        OptionalInt found = Arrays.stream(acceptableValues).filter(expected -> expected == actualStatus).findFirst();
        if (!found.isPresent()) {
            StringBuilder sb = new StringBuilder();
            Arrays.stream(acceptableValues).forEach(val -> sb.append(sb.length() == 0 ? "" : ",").append(val));
            throw new IOException("Unexpected response status " + actualStatus + ", expected one of '" + sb + "'");
        }
        return this;
    }

    private void maybeCheckOkStatus() throws IOException {
        if (!this.explicitStatusCheck) {
            try {
                this.checkStatus(200);
            }
            finally {
                this.explicitStatusCheck = false;
            }
        }
    }

    public InternalRequest checkResponseContentType(String contentType) throws IOException {
        this.assertRequestExecuted();
        if (!contentType.equals(this.response.getContentType())) {
            throw new IOException("Expected content type " + contentType + " but got " + this.response.getContentType());
        }
        return this;
    }

    public int getStatus() throws IOException {
        this.assertRequestExecuted();
        return this.response.getStatus();
    }

    public SlingHttpServletResponse getResponse() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response;
    }

    public String getResponseAsString() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response.getOutputAsString();
    }
}

