/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.LinePrefixCleaner;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RegisterNodetypes
extends Operation {
    private final String cndStatements;
    public static final String CND_OPTIONAL_PREFIX = "<< ";

    public RegisterNodetypes(String cndStatements) {
        this.cndStatements = new LinePrefixCleaner().removePrefix(CND_OPTIONAL_PREFIX, cndStatements);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":\n" + this.getParametersDescription();
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCndStatements());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public String asRepoInitString() {
        try (Formatter formatter = new Formatter();){
            for (String nodetypeRegistrationSentence : RegisterNodetypes.generateRepoInitLines(new BufferedReader(new StringReader(this.cndStatements)))) {
                formatter.format("%s%n", nodetypeRegistrationSentence);
            }
            String string = formatter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    @NotNull
    public static List<String> generateRepoInitLines(@NotNull BufferedReader rawLines) throws IOException {
        String raw;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("register nodetypes");
        lines.add("<<===");
        while ((raw = rawLines.readLine()) != null) {
            if (raw.isEmpty()) {
                lines.add("");
                continue;
            }
            lines.add(CND_OPTIONAL_PREFIX + raw);
        }
        lines.add("===>>");
        return lines;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitRegisterNodetypes(this);
    }

    public String getCndStatements() {
        return this.cndStatements;
    }
}

