/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.couchbase.resourceprovider.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.nosql.couchbase.client.CouchbaseClient;
import org.apache.sling.nosql.couchbase.resourceprovider.impl.CouchbaseNoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.MetricsNoSqlAdapterWrapper;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.resource.AbstractNoSqlResourceProviderFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, name="org.apache.sling.nosql.couchbase.resourceprovider.CouchbaseNoSqlResourceProviderFactory.factory.config", label="Apache Sling NoSQL Couchbase Resource Provider Factory", description="Defines a resource provider factory with Couchbase persistence.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={ResourceProviderFactory.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Root paths: {provider.roots}"})
public final class CouchbaseNoSqlResourceProviderFactory
extends AbstractNoSqlResourceProviderFactory {
    public static final String COUCHBASE_CLIENT_ID = "sling-resourceprovider-couchbase";
    @Property(label="Cache Key Prefix", description="Prefix for caching keys.", value={"sling-resource:"})
    static final String CACHE_KEY_PREFIX_PROPERTY = "cacheKeyPrefix";
    private static final String CACHE_KEY_PREFIX_DEFAULT = "sling-resource:";
    @Property(label="Root paths", description="Root paths for resource provider.", cardinality=0x7FFFFFFF)
    static final String PROVIDER_ROOTS_PROPERTY = "provider.roots";
    @Reference(target="(clientId=sling-resourceprovider-couchbase)")
    private CouchbaseClient couchbaseClient;
    @Reference
    private EventAdmin eventAdmin;
    private NoSqlAdapter noSqlAdapter;

    @Activate
    private void activate(ComponentContext componentContext, Map<String, Object> config) {
        String cacheKeyPrefix = PropertiesUtil.toString((Object)config.get(CACHE_KEY_PREFIX_PROPERTY), (String)CACHE_KEY_PREFIX_DEFAULT);
        CouchbaseNoSqlAdapter couchbaseAdapter = new CouchbaseNoSqlAdapter(this.couchbaseClient, cacheKeyPrefix);
        this.noSqlAdapter = new MetricsNoSqlAdapterWrapper((NoSqlAdapter)couchbaseAdapter, LoggerFactory.getLogger(CouchbaseNoSqlAdapter.class));
    }

    protected NoSqlAdapter getNoSqlAdapter() {
        return this.noSqlAdapter;
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected void bindCouchbaseClient(CouchbaseClient couchbaseClient) {
        this.couchbaseClient = couchbaseClient;
    }

    protected void unbindCouchbaseClient(CouchbaseClient couchbaseClient) {
        if (this.couchbaseClient == couchbaseClient) {
            this.couchbaseClient = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

